/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.svg;

import java.io.IOException;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.svg.SvgGraphics;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.UClip;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;

public class DriverImagePng
implements UDriver<UImage, SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverImagePng(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UImage image, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            if (!clip.isInside(x, y)) {
                return;
            }
            if (!clip.isInside(x + (double)image.getWidth(), y + (double)image.getHeight())) {
                return;
            }
        }
        try {
            svg.svgImage(image.getImage(1.0), x, y);
        }
        catch (IOException e) {
            Log.error("Error in svg for image " + e);
        }
    }
}

