/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.svg;

import java.awt.geom.Rectangle2D;
import znaishaded.net.sourceforge.plantuml.svg.SvgGraphics;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.UClip;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorGradient;

public class DriverRectangleSvg
implements UDriver<URectangle, SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverRectangleSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(URectangle rect, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        double rx = rect.getRx();
        double ry = rect.getRy();
        double width = rect.getWidth();
        double height = rect.getHeight();
        DriverRectangleSvg.applyFillColor(svg, mapper, param);
        DriverRectangleSvg.applyStrokeColor(svg, mapper, param);
        svg.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDasharraySvg());
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            Rectangle2D.Double r = clip.getClippedRectangle(new Rectangle2D.Double(x, y, width, height));
            x = r.x;
            y = r.y;
            width = r.width;
            height = r.height;
            if (height <= 0.0) {
                return;
            }
        }
        svg.svgRectangle(x, y, width, height, rx / 2.0, ry / 2.0, rect.getDeltaShadow(), rect.getComment(), rect.getCodeLine());
    }

    public static void applyFillColor(SvgGraphics svg, ColorMapper mapper, UParam param) {
        HColor background = param.getBackcolor();
        if (background instanceof HColorGradient) {
            HColorGradient gr = (HColorGradient)background;
            String id = svg.createSvgGradient(mapper.toRGB(gr.getColor1()), mapper.toRGB(gr.getColor2()), gr.getPolicy());
            svg.setFillColor("url(#" + id + ")");
        } else {
            HColor dark;
            HColor hColor = dark = background == null ? null : background.darkSchemeTheme();
            if (dark == background) {
                svg.setFillColor(mapper.toSvg(background));
            } else {
                svg.setFillColor(mapper.toSvg(background), mapper.toSvg(dark));
            }
        }
    }

    public static void applyStrokeColor(SvgGraphics svg, ColorMapper mapper, UParam param) {
        HColor color = param.getColor();
        if (color instanceof HColorGradient) {
            HColorGradient gr = (HColorGradient)color;
            String id = svg.createSvgGradient(mapper.toRGB(gr.getColor1()), mapper.toRGB(gr.getColor2()), gr.getPolicy());
            svg.setStrokeColor("url(#" + id + ")");
        } else {
            HColor dark;
            HColor hColor = dark = color == null ? null : color.darkSchemeTheme();
            if (dark == color) {
                svg.setStrokeColor(mapper.toSvg(color));
            } else {
                svg.setStrokeColor(mapper.toSvg(color), mapper.toSvg(dark));
            }
        }
    }
}

