/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.version;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.PlainDiagram;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.graphic.GraphicStrings;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.svek.TextBlockBackcolored;
import znaishaded.net.sourceforge.plantuml.ugraphic.AffineTransformType;
import znaishaded.net.sourceforge.plantuml.ugraphic.PixelImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.version.License;
import znaishaded.net.sourceforge.plantuml.version.LicenseInfo;

public class PSystemLicense
extends PlainDiagram
implements UDrawable {
    @Override
    protected UDrawable getRootDrawable(FileFormatOption fileFormatOption) {
        return this;
    }

    public static PSystemLicense create(UmlSource source) throws IOException {
        return new PSystemLicense(source);
    }

    public PSystemLicense(UmlSource source) {
        super(source);
    }

    private TextBlockBackcolored getGraphicStrings(List<String> strings) {
        return GraphicStrings.createBlackOnWhite(strings);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(License)");
    }

    @Override
    public void drawU(UGraphic ug) {
        LicenseInfo licenseInfo = LicenseInfo.retrieveQuick();
        BufferedImage logo = LicenseInfo.retrieveDistributorImage(licenseInfo);
        if (logo == null) {
            ArrayList<String> strings = new ArrayList<String>();
            strings.addAll(License.getCurrent().getText1(licenseInfo));
            strings.addAll(License.getCurrent().getText2(licenseInfo));
            this.getGraphicStrings(strings).drawU(ug);
        } else {
            ArrayList<String> strings1 = new ArrayList<String>();
            ArrayList<String> strings2 = new ArrayList<String>();
            strings1.addAll(License.getCurrent().getText1(licenseInfo));
            strings2.addAll(License.getCurrent().getText2(licenseInfo));
            TextBlockBackcolored result1 = this.getGraphicStrings(strings1);
            result1.drawU(ug);
            ug = ug.apply(UTranslate.dy(4.0 + result1.calculateDimension(ug.getStringBounder()).getHeight()));
            UImage im = new UImage(new PixelImage(logo, AffineTransformType.TYPE_BILINEAR));
            ug.apply(UTranslate.dx(20.0)).draw(im);
            ug = ug.apply(UTranslate.dy(im.getHeight()));
            TextBlockBackcolored result2 = this.getGraphicStrings(strings2);
            result2.drawU(ug);
        }
    }
}

