/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.wbs;

import znaishaded.net.sourceforge.plantuml.Direction;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.mindmap.IdeaShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.wbs.WBSDiagram;

public class CommandWBSItem
extends SingleLineCommand2<WBSDiagram> {
    public CommandWBSItem() {
        super(false, CommandWBSItem.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandWBSItem.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "([ \t]*[*+-]+)"), new RegexOptional((IRegex)new RegexLeaf("BACKCOLOR", "\\[(#\\w+)\\]")), new RegexLeaf("SHAPE", "(_)?"), new RegexLeaf("DIRECTION", "([<>])?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("LABEL", "([^%s].*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(WBSDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String type = arg.get("TYPE", 0);
        String label = arg.get("LABEL", 0);
        String stringColor = arg.get("BACKCOLOR", 0);
        HColor backColor = null;
        if (stringColor != null) {
            backColor = diagram.getSkinParam().getIHtmlColorSet().getColor(diagram.getSkinParam().getThemeStyle(), stringColor);
        }
        Direction dir = type.contains("-") ? Direction.LEFT : Direction.RIGHT;
        String direction = arg.get("DIRECTION", 0);
        if ("<".equals(direction)) {
            dir = Direction.LEFT;
        } else if (">".equals(direction)) {
            dir = Direction.RIGHT;
        }
        return diagram.addIdea(backColor, diagram.getSmartLevel(type), label, dir, IdeaShape.fromDesc(arg.get("SHAPE", 0)));
    }
}

