/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.wire;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.command.Position;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.MinMax;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class Block
extends AbstractTextBlock {
    private final Map<Block, Pos> children = new LinkedHashMap<Block, Pos>();
    private final Display display;
    private final Dimension2DDouble fixedDim;
    private final ISkinParam skinParam;
    private final List<String> left = new ArrayList<String>();
    private final List<String> right = new ArrayList<String>();
    private final List<String> top = new ArrayList<String>();
    private final List<String> bottom = new ArrayList<String>();
    private double x = 10.0;
    private double y = 10.0;
    private MinMax minMax = MinMax.getEmpty(true);
    private Block parent;

    public Block(ISkinParam skinParam) {
        this(skinParam, Display.empty(), null);
    }

    private Block(ISkinParam skinParam, Display display, Dimension2DDouble fixedDim) {
        this.skinParam = skinParam;
        this.display = display;
        this.fixedDim = fixedDim;
    }

    private List<String> getPins(Position position) {
        switch (position) {
            case LEFT: {
                return this.left;
            }
            case RIGHT: {
                return this.right;
            }
            case TOP: {
                return this.top;
            }
            case BOTTOM: {
                return this.bottom;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        if (this.fixedDim == null) {
            return this.minMax.getDimension();
        }
        return this.fixedDim;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(this.getBlack());
        if (this.children.size() == 0) {
            TextBlock label = this.display.create(FontConfiguration.create(this.skinParam, FontParam.COMPONENT, null), HorizontalAlignment.CENTER, this.skinParam);
            label.drawU(ug.apply(new UTranslate(10.0, 10.0)));
        } else {
            for (Map.Entry<Block, Pos> ent : this.children.entrySet()) {
                ent.getKey().drawU(ent.getValue().move(ug));
            }
        }
        ug.draw(new URectangle(this.calculateDimension(ug.getStringBounder())));
        this.drawPins(Position.BOTTOM, ug);
        this.drawPins(Position.TOP, ug);
        this.drawPins(Position.LEFT, ug);
        this.drawPins(Position.RIGHT, ug);
    }

    private HColor getBlack() {
        return HColorUtils.BLACK.withDark(HColorUtils.WHITE);
    }

    private void drawPins(Position pos, UGraphic ug) {
        double px = -2.0;
        double py = 10.0;
        if (pos == Position.RIGHT) {
            px = this.calculateDimension(ug.getStringBounder()).getWidth() - 2.0;
        }
        if (pos == Position.TOP) {
            px = 10.0;
            py = -2.0;
        }
        if (pos == Position.BOTTOM) {
            px = 10.0;
            py = this.calculateDimension(ug.getStringBounder()).getHeight() - 2.0;
        }
        for (String pin : this.getPins(pos)) {
            ug.apply(new UTranslate(px, py)).draw(new UEllipse(4.0, 4.0));
            if (pos == Position.LEFT || pos == Position.RIGHT) {
                py += 15.0;
                continue;
            }
            px += 15.0;
        }
    }

    public Block componentEnd() {
        this.parent.minMax = this.parent.minMax.addPoint(this.parent.x + this.minMax.getMaxX() + 10.0, this.parent.y + this.minMax.getMaxY() + 10.0);
        this.parent.x += this.minMax.getMaxX() + 10.0;
        return this.parent;
    }

    public Block addNewBlock(String name, int width, int height) {
        Dimension2DDouble dim = new Dimension2DDouble(width, height);
        Block child = new Block(this.skinParam, Display.create(name), dim);
        this.children.put(child, new Pos(this.x, this.y));
        this.y += dim.getHeight() + 10.0;
        this.minMax = this.minMax.addPoint(this.x + dim.getWidth() + 10.0, this.y);
        return child;
    }

    public Block createContainer(String name) {
        Block result = new Block(this.skinParam);
        result.parent = this;
        this.children.put(result, new Pos(this.x, this.y));
        return result;
    }

    public void vspace(int vspace) {
        this.y += (double)(vspace - 10);
        this.minMax = this.minMax.addPoint(this.x, this.y);
    }

    public void newColumn() {
        this.x = this.minMax.getMaxX();
        this.y = 10.0;
    }

    public void addPin(Position position, String pin) {
        this.getPins(position).add(pin);
    }

    static class Pos {
        final double x;
        final double y;

        public Pos(double x, double y) {
            this.x = x;
            this.y = y;
        }

        UGraphic move(UGraphic ug) {
            return ug.apply(new UTranslate(this.x, this.y));
        }
    }
}

