/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.zopfli;

import znaishaded.net.sourceforge.plantuml.zopfli.Buffer;
import znaishaded.net.sourceforge.plantuml.zopfli.Cookie;
import znaishaded.net.sourceforge.plantuml.zopfli.Deflate;
import znaishaded.net.sourceforge.plantuml.zopfli.Options;

public class Zopfli {
    private final Cookie cookie;

    public synchronized Buffer compress(Options options, byte[] input) {
        Buffer output = new Buffer();
        switch (options.outputType) {
            case GZIP: {
                this.compressGzip(options, input, output);
                break;
            }
            case ZLIB: {
                this.compressZlib(options, input, output);
                break;
            }
            case DEFLATE: {
                Deflate.compress(this.cookie, options, input, output);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected output format: " + (Object)((Object)options.outputType));
            }
        }
        return output;
    }

    private static int adler32(byte[] data) {
        int s1 = 1;
        int s2 = 0;
        int i = 0;
        while (i < data.length) {
            int tick = Math.min(data.length, i + 1024);
            while (i < tick) {
                s2 += (s1 += data[i++]);
            }
            s1 %= 65521;
            s2 %= 65521;
        }
        return s2 << 16 | s1;
    }

    private void compressZlib(Options options, byte[] input, Buffer output) {
        output.append((byte)120);
        output.append((byte)30);
        Deflate.compress(this.cookie, options, input, output);
        int checksum = Zopfli.adler32(input);
        output.append((byte)(checksum >> 24 & 0xFF));
        output.append((byte)(checksum >> 16 & 0xFF));
        output.append((byte)(checksum >> 8 & 0xFF));
        output.append((byte)(checksum & 0xFF));
    }

    private void compressGzip(Options options, byte[] input, Buffer output) {
        output.append((byte)31);
        output.append((byte)-117);
        output.append((byte)8);
        output.append((byte)0);
        output.append((byte)0);
        output.append((byte)0);
        output.append((byte)0);
        output.append((byte)0);
        output.append((byte)2);
        output.append((byte)3);
        Deflate.compress(this.cookie, options, input, output);
        int crc = Crc.calculate(input);
        output.append((byte)(crc & 0xFF));
        output.append((byte)(crc >> 8 & 0xFF));
        output.append((byte)(crc >> 16 & 0xFF));
        output.append((byte)(crc >> 24 & 0xFF));
        int size = input.length;
        output.append((byte)(size & 0xFF));
        output.append((byte)(size >> 8 & 0xFF));
        output.append((byte)(size >> 16 & 0xFF));
        output.append((byte)(size >> 24 & 0xFF));
    }

    public Zopfli(int masterBlockSize) {
        this.cookie = new Cookie(masterBlockSize);
    }

    private static class Crc {
        private static final int[] table = Crc.makeTable();

        private Crc() {
        }

        private static int[] makeTable() {
            int[] result = new int[256];
            for (int n = 0; n < 256; ++n) {
                int c = n;
                for (int k = 0; k < 8; ++k) {
                    if ((c & 1) == 1) {
                        c = 0xEDB88320 ^ c >>> 1;
                        continue;
                    }
                    c >>>= 1;
                }
                result[n] = c;
            }
            return result;
        }

        public static int calculate(byte[] input) {
            int c = -1;
            int n = input.length;
            for (int i = 0; i < n; ++i) {
                c = table[(c ^ input[i]) & 0xFF] ^ c >>> 8;
            }
            return ~c;
        }
    }
}

