/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.docpreparation;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationHandler;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationProgress;
import znaishaded.io.vertx.core.impl.ConcurrentHashSet;

public class DocumentationPreparationTestHandler
implements DocumentationPreparationHandler {
    private static final List<String> DUMMY_DOC_IDS = Arrays.asList("preview", "hello", "world");
    private final Set<String> isReadyById = new ConcurrentHashSet<String>();

    @Override
    public boolean handles(String docId) {
        return DUMMY_DOC_IDS.contains(docId);
    }

    @Override
    public boolean isReady(String docId) {
        return this.isReadyById.contains(docId);
    }

    @Override
    public void prepare(String docId, DocumentationPreparationProgress preparationProgress) {
        LinkedHashMap<String, String> keyValues = new LinkedHashMap<String, String>();
        try {
            this.sleep(1000);
            preparationProgress.reportProgress(docId + ": hello", keyValues, 15);
            this.sleep(1000);
            keyValues.put("code base", "test_codebase");
            preparationProgress.reportProgress(docId + ": world", keyValues, 45);
            this.sleep(2000);
            keyValues.put("branch", "branch name");
            preparationProgress.reportProgress(docId + ": some progress", keyValues, 75);
            this.sleep(1000);
            this.isReadyById.add(docId);
            preparationProgress.reportProgress(docId + ": another progress", keyValues, 100);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void sleep(int millis) throws InterruptedException {
        Thread.sleep(millis);
        System.out.println(Thread.currentThread().getName());
    }
}

