/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.log;

import org.testingisdocumenting.znai.console.ConsoleOutput;
import org.testingisdocumenting.znai.console.ansi.IgnoreAnsiString;
import znaishaded.org.slf4j.Logger;
import znaishaded.org.slf4j.LoggerFactory;

public class RedirectToFileConsoleOutput
implements ConsoleOutput {
    private static final Logger logger = RedirectToFileConsoleOutput.createLogger();

    @Override
    public void out(Object ... styleOrValues) {
        if (logger == null) {
            return;
        }
        logger.info(RedirectToFileConsoleOutput.stripAnsi(styleOrValues));
    }

    @Override
    public void err(Object ... styleOrValues) {
        if (logger == null) {
            return;
        }
        logger.error(RedirectToFileConsoleOutput.stripAnsi(styleOrValues));
    }

    private static Logger createLogger() {
        String logPath = System.getProperty("logPath");
        if (logPath == null) {
            return null;
        }
        return LoggerFactory.getLogger(RedirectToFileConsoleOutput.class);
    }

    private static String stripAnsi(Object[] styleOrValues) {
        return new IgnoreAnsiString(styleOrValues).toString();
    }
}

