/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.testingisdocumenting.webtau.Matchers;
import org.testingisdocumenting.webtau.WebTauCore;
import org.testingisdocumenting.znai.extensions.include.PluginsTestUtils;
import org.testingisdocumenting.znai.utils.ResourceUtils;
import znaishaded.org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileIncludePluginTest
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public FileIncludePluginTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void should trim empty lines from start and end() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[0].callStatic(FileIncludePluginTest.class, (Object)"file-with-empty-lines.txt", (Object)"");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-empty-lines.txt", "");
            text = string;
        }
        callSiteArray[1].call(text, callSiteArray[2].callStatic(WebTauCore.class, callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call((Object)"this is a\n", (Object)"\n"), (Object)"a multiple lines\n"), (Object)"\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"\n"), (Object)"and then six")));
    }

    @Test
    public void should extract file snippet based on start line and number of lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[11].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'multiple lines', numberOfLines: 2}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'multiple lines', numberOfLines: 2}");
            text = string;
        }
        callSiteArray[12].call(text, callSiteArray[13].callStatic(WebTauCore.class, callSiteArray[14].call((Object)"a multiple lines\n", (Object)"line number")));
    }

    @Test
    public void should extract file snippet based on start and stop end lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[15].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'multiple lines', endLine: 'stop'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'multiple lines', endLine: 'stop'}");
            text = string;
        }
        callSiteArray[16].call(text, callSiteArray[17].callStatic(WebTauCore.class, callSiteArray[18].call(callSiteArray[19].call((Object)"a multiple lines\n", (Object)"line number\n"), (Object)"--- stop")));
    }

    @Test
    public void should extract not match start line to the end line pattern but start from the one below() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[20].callStatic(FileIncludePluginTest.class, (Object)"file-with-similar-lines.txt", (Object)"{startLine: '$prompt >', endLine: '$prompt >'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-similar-lines.txt", "{startLine: '$prompt >', endLine: '$prompt >'}");
            text = string;
        }
        callSiteArray[21].call(text, callSiteArray[22].callStatic(WebTauCore.class, callSiteArray[23].call(callSiteArray[24].call(callSiteArray[25].call((Object)"$prompt >\n", (Object)"some output\n"), (Object)"goes here\n"), (Object)"$prompt >")));
    }

    @Test
    public void should fail when surrounded content is empty() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_fail_when_surrounded_content_is_empty_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_fail_when_surrounded_content_is_empty_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_fail_when_surrounded_content_is_empty_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_fail_when_surrounded_content_is_empty_closure1.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-with-similar-lines-empty.txt", (Object)"{surroundedBy: '$prompt'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_fail_when_surrounded_content_is_empty_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_fail_when_surrounded_content_is_empty_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_fail_when_surrounded_content_is_empty_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_fail_when_surrounded_content_is_empty_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[26].call(callSiteArray[27].callStatic(Matchers.class, (Object)new _should_fail_when_surrounded_content_is_empty_closure1(this, this)), callSiteArray[28].callStatic(Matchers.class, (Object)"no content present after surroundedBy $prompt"));
    }

    @Test
    public void should fail if one of the surroundedBy is missing() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_fail_if_one_of_the_surroundedBy_is_missing_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_fail_if_one_of_the_surroundedBy_is_missing_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_fail_if_one_of_the_surroundedBy_is_missing_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_fail_if_one_of_the_surroundedBy_is_missing_closure2.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-with-missing-marker.txt", (Object)"{surroundedBy: '$prompt'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_fail_if_one_of_the_surroundedBy_is_missing_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_fail_if_one_of_the_surroundedBy_is_missing_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_fail_if_one_of_the_surroundedBy_is_missing_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_fail_if_one_of_the_surroundedBy_is_missing_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[29].call(callSiteArray[30].callStatic(Matchers.class, (Object)new _should_fail_if_one_of_the_surroundedBy_is_missing_closure2(this, this)), callSiteArray[31].callStatic(Matchers.class, callSiteArray[32].call(callSiteArray[33].call(callSiteArray[34].call((Object)"there is no second marker \"$prompt\" in <file-with-missing-marker.txt>:\n", (Object)"$prompt >\n"), (Object)"some output\n"), (Object)"goes here")));
    }

    @Test
    public void should validate start and stop end lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_validate_start_and_stop_end_lines_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_start_and_stop_end_lines_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure3.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file.txt", (Object)"{startLine: '1multiple lines', endLine: 'stop'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_start_and_stop_end_lines_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_start_and_stop_end_lines_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_start_and_stop_end_lines_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[35].call(callSiteArray[36].callStatic(Matchers.class, (Object)new _should_validate_start_and_stop_end_lines_closure3(this, this)), callSiteArray[37].callStatic(Matchers.class, callSiteArray[38].call(callSiteArray[39].call(callSiteArray[40].call(callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].call((Object)"there is no line containing \"1multiple lines\" in <file.txt>:\n", (Object)"this is a\n"), (Object)"test file in\n"), (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"and then six")));
        public final class _should_validate_start_and_stop_end_lines_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_start_and_stop_end_lines_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure4.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file.txt", (Object)"{startLine: 'multiple lines', endLine: 'stop2'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_start_and_stop_end_lines_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_start_and_stop_end_lines_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_start_and_stop_end_lines_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[45].call(callSiteArray[46].callStatic(Matchers.class, (Object)new _should_validate_start_and_stop_end_lines_closure4(this, this)), callSiteArray[47].callStatic(Matchers.class, callSiteArray[48].call(callSiteArray[49].call(callSiteArray[50].call(callSiteArray[51].call(callSiteArray[52].call((Object)"there is no line containing \"stop2\" in <file.txt>:\n", (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"and then six")));
    }

    @Test
    public void should extract file snippet based on start and stop end lines excluding them() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[53].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'number', endLine: 'stop', excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'number', endLine: 'stop', excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[54].call(text, callSiteArray[55].callStatic(WebTauCore.class, (Object)""));
    }

    @Test
    public void multiple start lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[56].callStatic(FileIncludePluginTest.class, (Object)"multiple-lines-start-stop.txt", (Object)"{startLine: ['if (conditionA)', 'if (conditionB)']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("multiple-lines-start-stop.txt", "{startLine: ['if (conditionA)', 'if (conditionB)']}");
            text = string;
        }
        callSiteArray[57].call(text, callSiteArray[58].callStatic(WebTauCore.class, callSiteArray[59].call(callSiteArray[60].call(callSiteArray[61].call(callSiteArray[62].call(callSiteArray[63].call(callSiteArray[64].call(callSiteArray[65].call(callSiteArray[66].call(callSiteArray[67].call(callSiteArray[68].call((Object)"if (conditionA) {\n", (Object)"  // line between\n"), (Object)"  if (conditionB) {\n"), (Object)"    // inside condition A and condition B\n"), (Object)"    doAction()\n"), (Object)"  }\n"), (Object)"}\n"), (Object)"\n"), (Object)"if (conditionC) {\n"), (Object)"    // inside condition C\n"), (Object)"}")));
    }

    @Test
    public void multiple start lines no match() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _multiple_start_lines_no_match_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _multiple_start_lines_no_match_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _multiple_start_lines_no_match_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _multiple_start_lines_no_match_closure5.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"multiple-lines-start-stop.txt", (Object)"{startLine: ['if (conditionA)', 'if (conditionD)']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _multiple_start_lines_no_match_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _multiple_start_lines_no_match_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_multiple_start_lines_no_match_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _multiple_start_lines_no_match_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[69].call(callSiteArray[70].callStatic(Matchers.class, (Object)new _multiple_start_lines_no_match_closure5(this, this)), callSiteArray[71].callStatic(Matchers.class, callSiteArray[72].call(callSiteArray[73].call(callSiteArray[74].call((Object)"can't find sequence of start lines:\n", (Object)"  if (conditionA)\n"), (Object)"  if (conditionD) in <multiple-lines-start-stop.txt>:\n"), callSiteArray[75].call(callSiteArray[76].call(ResourceUtils.class, (Object)"multiple-lines-start-stop.txt")))));
    }

    @Test
    public void multiple start lines with exclude start() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[77].callStatic(FileIncludePluginTest.class, (Object)"multiple-lines-start-stop.txt", (Object)"{startLine: ['if (conditionA)', 'if (conditionB)'], excludeStart: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("multiple-lines-start-stop.txt", "{startLine: ['if (conditionA)', 'if (conditionB)'], excludeStart: true}");
            text = string;
        }
        callSiteArray[78].call(text, callSiteArray[79].callStatic(WebTauCore.class, callSiteArray[80].call(callSiteArray[81].call(callSiteArray[82].call(callSiteArray[83].call(callSiteArray[84].call(callSiteArray[85].call(callSiteArray[86].call((Object)"    // inside condition A and condition B\n", (Object)"    doAction()\n"), (Object)"  }\n"), (Object)"}\n"), (Object)"\n"), (Object)"if (conditionC) {\n"), (Object)"    // inside condition C\n"), (Object)"}")));
    }

    @Test
    public void should extract file snippet based on surrounding pattern and exclude the pattern() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[87].callStatic(FileIncludePluginTest.class, (Object)"file-with-surround-marker.txt", (Object)"{surroundedBy: '# concept-example'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-surround-marker.txt", "{surroundedBy: '# concept-example'}");
            text = string;
        }
        callSiteArray[88].call(text, callSiteArray[89].callStatic(WebTauCore.class, callSiteArray[90].call((Object)"foo()\n", (Object)"bar()")));
    }

    @Test
    public void surrounded by keep() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[91].callStatic(FileIncludePluginTest.class, (Object)"file-with-surround-marker.txt", (Object)"{surroundedBy: '# concept-example', surroundedByKeep: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-surround-marker.txt", "{surroundedBy: '# concept-example', surroundedByKeep: true}");
            text = string;
        }
        callSiteArray[92].call(text, callSiteArray[93].callStatic(WebTauCore.class, callSiteArray[94].call(callSiteArray[95].call(callSiteArray[96].call((Object)"# concept-example\n", (Object)"   foo()\n"), (Object)"   bar()\n"), (Object)"# concept-example")));
    }

    @Test
    public void should extract file snippet based on multiple surrounding patterns and indent each block() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[97].callStatic(FileIncludePluginTest.class, (Object)"file-with-multiple-surround-marker.txt", (Object)"{surroundedBy: ['# import-list', '# concept-example']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-multiple-surround-marker.txt", "{surroundedBy: ['# import-list', '# concept-example']}");
            text = string;
        }
        callSiteArray[98].call(text, callSiteArray[99].callStatic(WebTauCore.class, callSiteArray[100].call(callSiteArray[101].call(callSiteArray[102].call((Object)"import abc\n", (Object)"import def\n"), (Object)"foo()\n"), (Object)"bar()")));
    }

    @Test
    public void should extract file snippet based on multiple surrounding patterns and add specified separator() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = callSiteArray[103].callStatic(FileIncludePluginTest.class, (Object)"file-with-multiple-surround-marker.txt", callSiteArray[104].call((Object)"{surroundedBy: ['# import-list', '# concept-example', '# another-example', '# next-last-example', '# last-example', ],", (Object)" surroundedBySeparator: ['...', null, '%']}"));
        callSiteArray[105].call(text, callSiteArray[106].callStatic(WebTauCore.class, callSiteArray[107].call(callSiteArray[108].call(callSiteArray[109].call(callSiteArray[110].call(callSiteArray[111].call(callSiteArray[112].call(callSiteArray[113].call(callSiteArray[114].call(callSiteArray[115].call((Object)"import abc\n", (Object)"import def\n"), (Object)"...\n"), (Object)"foo()\n"), (Object)"bar()\n"), (Object)"foobar()\n"), (Object)"%\n"), (Object)"almostFinish()\n"), (Object)"%\n"), (Object)"finish()")));
    }

    @Test
    public void should extract using surrounded with scope() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[116].callStatic(FileIncludePluginTest.class, (Object)"file-with-scopes.txt", (Object)"{surroundedByScope: {start: 'if', scope: '{}'}}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-scopes.txt", "{surroundedByScope: {start: 'if', scope: '{}'}}");
            text = string;
        }
        callSiteArray[117].call(text, callSiteArray[118].callStatic(WebTauCore.class, callSiteArray[119].call(callSiteArray[120].call((Object)"if (condition) {\n", (Object)"   print \"inside\"\n"), (Object)"}")));
    }

    @Test
    public void surrounded with scope validates presence of start line() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _surrounded_with_scope_validates_presence_of_start_line_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _surrounded_with_scope_validates_presence_of_start_line_closure6(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_start_line_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_start_line_closure6.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-with-scopes.txt", (Object)"{surroundedByScope: {start: 'if-else', scope: '{}'}}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_start_line_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _surrounded_with_scope_validates_presence_of_start_line_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_surrounded_with_scope_validates_presence_of_start_line_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _surrounded_with_scope_validates_presence_of_start_line_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[121].call(callSiteArray[122].callStatic(Matchers.class, (Object)new _surrounded_with_scope_validates_presence_of_start_line_closure6(this, this)), callSiteArray[123].callStatic(Matchers.class, callSiteArray[124].call((Object)"there is no line containing \"if-else\" in <file-with-scopes.txt>:\n", callSiteArray[125].call(callSiteArray[126].call(ResourceUtils.class, (Object)"file-with-scopes.txt")))));
    }

    @Test
    public void surrounded with scope validates presence of markers() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _surrounded_with_scope_validates_presence_of_markers_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _surrounded_with_scope_validates_presence_of_markers_closure7(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_markers_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_markers_closure7.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-with-scopes.txt", (Object)"{surroundedByScope: {start: 'if (anotherCondition)', scope: '{}'}}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_markers_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _surrounded_with_scope_validates_presence_of_markers_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_surrounded_with_scope_validates_presence_of_markers_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _surrounded_with_scope_validates_presence_of_markers_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[127].call(callSiteArray[128].callStatic(Matchers.class, (Object)new _surrounded_with_scope_validates_presence_of_markers_closure7(this, this)), callSiteArray[129].callStatic(Matchers.class, callSiteArray[130].call((Object)"can't find scope start \"{\" after line \"if (anotherCondition)\" in <file-with-scopes.txt>:\n", callSiteArray[131].call(callSiteArray[132].call(ResourceUtils.class, (Object)"file-with-scopes.txt")))));
        public final class _surrounded_with_scope_validates_presence_of_markers_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _surrounded_with_scope_validates_presence_of_markers_closure8(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_markers_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_markers_closure8.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-with-scopes.txt", (Object)"{surroundedByScope: {start: 'if (someCondition)', scope: '{}'}}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_markers_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _surrounded_with_scope_validates_presence_of_markers_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_surrounded_with_scope_validates_presence_of_markers_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _surrounded_with_scope_validates_presence_of_markers_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[133].call(callSiteArray[134].callStatic(Matchers.class, (Object)new _surrounded_with_scope_validates_presence_of_markers_closure8(this, this)), callSiteArray[135].callStatic(Matchers.class, callSiteArray[136].call((Object)"can't find scope end \"}\" after line \"if (someCondition)\" in <file-with-scopes.txt>:\n", callSiteArray[137].call(callSiteArray[138].call(ResourceUtils.class, (Object)"file-with-scopes.txt")))));
    }

    @Test
    public void should replace text by exact match() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[139].callStatic(FileIncludePluginTest.class, (Object)"file-replace-all.txt", (Object)"{replace: ['foo', 'foo2']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-replace-all.txt", "{replace: ['foo', 'foo2']}");
            text = string;
        }
        callSiteArray[140].call(text, callSiteArray[141].callStatic(WebTauCore.class, callSiteArray[142].call(callSiteArray[143].call((Object)"foo2 foo2 foo2\n", (Object)"bar bar bar\n"), (Object)"test12 great16")));
    }

    @Test
    public void should replace text by exact match using multiple pairs() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[144].callStatic(FileIncludePluginTest.class, (Object)"file-replace-all.txt", (Object)"{replace: [['foo', 'foo2'], ['bar', 'bar3']]}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-replace-all.txt", "{replace: [['foo', 'foo2'], ['bar', 'bar3']]}");
            text = string;
        }
        callSiteArray[145].call(text, callSiteArray[146].callStatic(WebTauCore.class, callSiteArray[147].call(callSiteArray[148].call((Object)"foo2 foo2 foo2\n", (Object)"bar3 bar3 bar3\n"), (Object)"test12 great16")));
    }

    @Test
    public void should replace text using match group() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[149].callStatic(FileIncludePluginTest.class, (Object)"file-replace-all.txt", (Object)"{replace: ['test(\\\\d+)', '$1-TEST']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-replace-all.txt", "{replace: ['test(\\\\d+)', '$1-TEST']}");
            text = string;
        }
        callSiteArray[150].call(text, callSiteArray[151].callStatic(WebTauCore.class, callSiteArray[152].call(callSiteArray[153].call((Object)"foo foo foo\n", (Object)"bar bar bar\n"), (Object)"12-TEST great16")));
    }

    @Test
    public void should replace text inside surroundBy extracted group() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[154].callStatic(FileIncludePluginTest.class, (Object)"file-with-multiple-surround-marker.txt", (Object)"{surroundedBy: ['# import-list', '# concept-example'], replace: [['abc', 'ABC'], ['bar', 'Bar']]}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-multiple-surround-marker.txt", "{surroundedBy: ['# import-list', '# concept-example'], replace: [['abc', 'ABC'], ['bar', 'Bar']]}");
            text = string;
        }
        callSiteArray[155].call(text, callSiteArray[156].callStatic(WebTauCore.class, callSiteArray[157].call(callSiteArray[158].call(callSiteArray[159].call((Object)"import ABC\n", (Object)"import def\n"), (Object)"foo()\n"), (Object)"Bar()")));
    }

    @Test
    public void should validate replace parameters() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        String expectedError = "replace expects list with two values [from, to] or a list of pairs [[from1, to1], [from2, to2]]";
        public final class _should_validate_replace_parameters_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_replace_parameters_closure9(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure9.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-replace-all.txt", (Object)"{replace: ['a']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure9.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_replace_parameters_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_replace_parameters_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_replace_parameters_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[160].call(callSiteArray[161].callStatic(Matchers.class, (Object)new _should_validate_replace_parameters_closure9(this, this)), callSiteArray[162].callStatic(Matchers.class, (Object)expectedError));
        public final class _should_validate_replace_parameters_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_replace_parameters_closure10(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure10.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure10.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-replace-all.txt", (Object)"{replace: [['a']]}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure10.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_replace_parameters_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_replace_parameters_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_replace_parameters_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[163].call(callSiteArray[164].callStatic(Matchers.class, (Object)new _should_validate_replace_parameters_closure10(this, this)), callSiteArray[165].callStatic(Matchers.class, (Object)expectedError));
    }

    @Test
    public void should validate replace actually replaced something() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_validate_replace_actually_replaced_something_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_replace_actually_replaced_something_closure11(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_replace_actually_replaced_something_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_replace_actually_replaced_something_closure11.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-replace-all.txt", (Object)"{replace: ['no-match', 'new-value']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_replace_actually_replaced_something_closure11.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_replace_actually_replaced_something_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_replace_actually_replaced_something_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_replace_actually_replaced_something_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[166].call(callSiteArray[167].callStatic(Matchers.class, (Object)new _should_validate_replace_actually_replaced_something_closure11(this, this)), callSiteArray[168].callStatic(Matchers.class, (Object)"content was not modified using replace from: <no-match> to: <new-value>"));
    }

    @Test
    public void should extract file and exclude first and last line when excludeStartEnd is set and no start end is set() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[169].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[170].call(text, callSiteArray[171].callStatic(WebTauCore.class, callSiteArray[172].call(callSiteArray[173].call(callSiteArray[174].call(callSiteArray[175].call((Object)"test file in\n", (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five")));
    }

    @Test
    public void should extract file snippet based on start line only() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[176].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'multiple lines'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'multiple lines'}");
            text = string;
        }
        callSiteArray[177].call(text, callSiteArray[178].callStatic(WebTauCore.class, callSiteArray[179].call(callSiteArray[180].call(callSiteArray[181].call(callSiteArray[182].call((Object)"a multiple lines\n", (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"and then six")));
    }

    @Test
    public void should extract file snippet based on start line and exclude only start() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[183].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'this is a', excludeStart: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'this is a', excludeStart: true}");
            text = string;
        }
        callSiteArray[184].call(text, callSiteArray[185].callStatic(WebTauCore.class, callSiteArray[186].call(callSiteArray[187].call(callSiteArray[188].call(callSiteArray[189].call(callSiteArray[190].call((Object)"test file in\n", (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"and then six")));
    }

    @Test
    public void should extract file snippet based on end line and exclude only end() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[191].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{endLine: '--- stop', excludeEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{endLine: '--- stop', excludeEnd: true}");
            text = string;
        }
        callSiteArray[192].call(text, callSiteArray[193].callStatic(WebTauCore.class, callSiteArray[194].call(callSiteArray[195].call(callSiteArray[196].call((Object)"this is a\n", (Object)"test file in\n"), (Object)"a multiple lines\n"), (Object)"line number")));
    }

    @Test
    public void should extract file snippet based on end line only() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[197].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{endLine: 'stop'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{endLine: 'stop'}");
            text = string;
        }
        callSiteArray[198].call(text, callSiteArray[199].callStatic(WebTauCore.class, callSiteArray[200].call(callSiteArray[201].call(callSiteArray[202].call(callSiteArray[203].call((Object)"this is a\n", (Object)"test file in\n"), (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop")));
    }

    @Test
    public void should extract file snippet based on multiple end lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[204].callStatic(FileIncludePluginTest.class, (Object)"multiple-lines-start-stop.txt", (Object)"{endLine: ['if (conditionB)', '}', '}']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("multiple-lines-start-stop.txt", "{endLine: ['if (conditionB)', '}', '}']}");
            text = string;
        }
        callSiteArray[205].call(text, callSiteArray[206].callStatic(WebTauCore.class, callSiteArray[207].call(callSiteArray[208].call(callSiteArray[209].call(callSiteArray[210].call(callSiteArray[211].call(callSiteArray[212].call(callSiteArray[213].call(callSiteArray[214].call(callSiteArray[215].call(callSiteArray[216].call(callSiteArray[217].call(callSiteArray[218].call(callSiteArray[219].call(callSiteArray[220].call((Object)"if (conditionA) {\n", (Object)"    // inside condition A\n"), (Object)"}\n"), (Object)"\n"), (Object)"if (conditionB) {\n"), (Object)"    // inside condition B\n"), (Object)"}\n"), (Object)"\n"), (Object)"if (conditionA) {\n"), (Object)"  // line between\n"), (Object)"  if (conditionB) {\n"), (Object)"    // inside condition A and condition B\n"), (Object)"    doAction()\n"), (Object)"  }\n"), (Object)"}")));
    }

    @Test
    public void should extract file snippet based on multiple end lines with exclude end() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[221].callStatic(FileIncludePluginTest.class, (Object)"multiple-lines-start-stop.txt", (Object)"{endLine: ['}', '}'], excludeEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("multiple-lines-start-stop.txt", "{endLine: ['}', '}'], excludeEnd: true}");
            text = string;
        }
        callSiteArray[222].call(text, callSiteArray[223].callStatic(WebTauCore.class, callSiteArray[224].call(callSiteArray[225].call(callSiteArray[226].call(callSiteArray[227].call(callSiteArray[228].call(callSiteArray[229].call(callSiteArray[230].call(callSiteArray[231].call(callSiteArray[232].call(callSiteArray[233].call(callSiteArray[234].call(callSiteArray[235].call((Object)"if (conditionA) {\n", (Object)"    // inside condition A\n"), (Object)"}\n"), (Object)"\n"), (Object)"if (conditionB) {\n"), (Object)"    // inside condition B\n"), (Object)"}\n"), (Object)"\n"), (Object)"if (conditionA) {\n"), (Object)"  // line between\n"), (Object)"  if (conditionB) {\n"), (Object)"    // inside condition A and condition B\n"), (Object)"    doAction()")));
    }

    @Test
    public void should extract file snippet based on multiple end lines no match() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure12(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure12.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"multiple-lines-start-stop.txt", (Object)"{endLine: ['if (conditionA)', 'if (conditionD)']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure12.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[236].call(callSiteArray[237].callStatic(Matchers.class, (Object)new _should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure12(this, this)), callSiteArray[238].callStatic(Matchers.class, callSiteArray[239].call(callSiteArray[240].call(callSiteArray[241].call((Object)"can't find sequence of end lines:\n", (Object)"  if (conditionA)\n"), (Object)"  if (conditionD) in <multiple-lines-start-stop.txt>:\n"), callSiteArray[242].call(callSiteArray[243].call(ResourceUtils.class, (Object)"multiple-lines-start-stop.txt")))));
    }

    @Test
    public void should automatically strip extra indentation() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[244].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{startLine: 'class', endLine: '}', excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{startLine: 'class', endLine: '}', excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[245].call(text, callSiteArray[246].callStatic(WebTauCore.class, callSiteArray[247].call((Object)"def a\n", (Object)"int b")));
    }

    @Test
    public void should only include lines containing text() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[248].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{include: ['int', 'def']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{include: ['int', 'def']}");
            result = string;
        }
        callSiteArray[249].call(result, callSiteArray[250].callStatic(WebTauCore.class, callSiteArray[251].call((Object)"def a\n", (Object)"int b")));
    }

    @Test
    public void should fail if none of the contains matches() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_fail_if_none_of_the_contains_matches_closure13
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_fail_if_none_of_the_contains_matches_closure13(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_contains_matches_closure13.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_contains_matches_closure13.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{include: ['in2t', 'de2f']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_contains_matches_closure13.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_fail_if_none_of_the_contains_matches_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_fail_if_none_of_the_contains_matches_closure13.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_fail_if_none_of_the_contains_matches_closure13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[252].call(callSiteArray[253].callStatic(Matchers.class, (Object)new _should_fail_if_none_of_the_contains_matches_closure13(this, this)), callSiteArray[254].callStatic(Matchers.class, callSiteArray[255].call(callSiteArray[256].call(callSiteArray[257].call(callSiteArray[258].call(callSiteArray[259].call(callSiteArray[260].call(callSiteArray[261].call((Object)"there are no lines containing <in2t>, <de2f> in <script.groovy>:\n", (Object)"import e.d.g.AnotherName\n"), (Object)"import a.b.c.ClassName\n"), (Object)"\n"), (Object)"class HelloWorld {\n"), (Object)"    def a\n"), (Object)"    int b\n"), (Object)"}")));
    }

    @Test
    public void should only include lines matching regexp() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object singleImport = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            singleImport = object = callSiteArray[262].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{includeRegexp: 'import.*ClassName'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{includeRegexp: 'import.*ClassName'}");
            singleImport = string;
        }
        callSiteArray[263].call(singleImport, callSiteArray[264].callStatic(WebTauCore.class, (Object)"import a.b.c.ClassName"));
        Object allImports = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            allImports = object = callSiteArray[265].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{includeRegexp: 'import'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{includeRegexp: 'import'}");
            allImports = string;
        }
        callSiteArray[266].call(allImports, callSiteArray[267].callStatic(WebTauCore.class, callSiteArray[268].call((Object)"import e.d.g.AnotherName\n", (Object)"import a.b.c.ClassName")));
    }

    @Test
    public void should only include lines matching regexps list() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[269].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{includeRegexp: ['i.t', 'd.f']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{includeRegexp: ['i.t', 'd.f']}");
            result = string;
        }
        callSiteArray[270].call(result, callSiteArray[271].callStatic(WebTauCore.class, callSiteArray[272].call((Object)"def a\n", (Object)"int b")));
    }

    @Test
    public void should fail if none of the include regexps matches() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_fail_if_none_of_the_include_regexps_matches_closure14
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_fail_if_none_of_the_include_regexps_matches_closure14(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_include_regexps_matches_closure14.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_include_regexps_matches_closure14.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{includeRegexp: ['in2t', 'de2f']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_include_regexps_matches_closure14.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_fail_if_none_of_the_include_regexps_matches_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_fail_if_none_of_the_include_regexps_matches_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_fail_if_none_of_the_include_regexps_matches_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[273].call(callSiteArray[274].callStatic(Matchers.class, (Object)new _should_fail_if_none_of_the_include_regexps_matches_closure14(this, this)), callSiteArray[275].callStatic(Matchers.class, callSiteArray[276].call(callSiteArray[277].call(callSiteArray[278].call(callSiteArray[279].call(callSiteArray[280].call(callSiteArray[281].call(callSiteArray[282].call((Object)"there are no lines matching regexp <in2t>, <de2f> in <script.groovy>:\n", (Object)"import e.d.g.AnotherName\n"), (Object)"import a.b.c.ClassName\n"), (Object)"\n"), (Object)"class HelloWorld {\n"), (Object)"    def a\n"), (Object)"    int b\n"), (Object)"}")));
    }

    @Test
    public void should exclude lines that don't contain text() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object withoutMarkers = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            withoutMarkers = object = callSiteArray[283].callStatic(FileIncludePluginTest.class, (Object)"sample-with-marker.py", (Object)"{exclude: '# example'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("sample-with-marker.py", "{exclude: '# example'}");
            withoutMarkers = string;
        }
        callSiteArray[284].call(withoutMarkers, callSiteArray[285].callStatic(WebTauCore.class, (Object)"print(\"hello\")"));
    }

    @Test
    public void should fail if none of the exclude contains matches() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_fail_if_none_of_the_exclude_contains_matches_closure15
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_fail_if_none_of_the_exclude_contains_matches_closure15(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_contains_matches_closure15.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_contains_matches_closure15.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"sample-with-multi-marker.py", (Object)"{exclude: [\"# exam34ple\", \"# .roc3edur.\"]}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_contains_matches_closure15.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_fail_if_none_of_the_exclude_contains_matches_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_fail_if_none_of_the_exclude_contains_matches_closure15.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_fail_if_none_of_the_exclude_contains_matches_closure15.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[286].call(callSiteArray[287].callStatic(Matchers.class, (Object)new _should_fail_if_none_of_the_exclude_contains_matches_closure15(this, this)), callSiteArray[288].callStatic(Matchers.class, callSiteArray[289].call(callSiteArray[290].call(callSiteArray[291].call(callSiteArray[292].call(callSiteArray[293].call(callSiteArray[294].call(callSiteArray[295].call((Object)"there are no lines containing <# exam34ple>, <# .roc3edur.> in <sample-with-multi-marker.py>:\n", (Object)"# example: how to print\n"), (Object)"print(\"hello\")\n"), (Object)"# example-end\n"), (Object)"\n"), (Object)"# procedure: how to print\n"), (Object)"print(\"hello world\")\n"), (Object)"# procedure-end")));
    }

    @Test
    public void should exclude lines matching regexp() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object withoutMarkers = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            withoutMarkers = object = callSiteArray[296].callStatic(FileIncludePluginTest.class, (Object)"sample-with-marker.py", (Object)"{excludeRegexp: '# exa..le'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("sample-with-marker.py", "{excludeRegexp: '# exa..le'}");
            withoutMarkers = string;
        }
        callSiteArray[297].call(withoutMarkers, callSiteArray[298].callStatic(WebTauCore.class, (Object)"print(\"hello\")"));
    }

    @Test
    public void should exclude lines matching regexps list() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object withoutMarkers = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            withoutMarkers = object = callSiteArray[299].callStatic(FileIncludePluginTest.class, (Object)"sample-with-multi-marker.py", (Object)"{excludeRegexp: [\"# example\", \"# .rocedur.\"]}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("sample-with-multi-marker.py", "{excludeRegexp: [\"# example\", \"# .rocedur.\"]}");
            withoutMarkers = string;
        }
        callSiteArray[300].call(withoutMarkers, callSiteArray[301].callStatic(WebTauCore.class, callSiteArray[302].call(callSiteArray[303].call((Object)"print(\"hello\")\n", (Object)"\n"), (Object)"print(\"hello world\")")));
    }

    @Test
    public void should fail if none of the exclude regexp matches() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_fail_if_none_of_the_exclude_regexp_matches_closure16
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_fail_if_none_of_the_exclude_regexp_matches_closure16(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_regexp_matches_closure16.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_regexp_matches_closure16.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"sample-with-multi-marker.py", (Object)"{excludeRegexp: [\"# exam34ple\", \"# .roc3edur.\"]}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_regexp_matches_closure16.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_fail_if_none_of_the_exclude_regexp_matches_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_fail_if_none_of_the_exclude_regexp_matches_closure16.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_fail_if_none_of_the_exclude_regexp_matches_closure16.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[304].call(callSiteArray[305].callStatic(Matchers.class, (Object)new _should_fail_if_none_of_the_exclude_regexp_matches_closure16(this, this)), callSiteArray[306].callStatic(Matchers.class, callSiteArray[307].call(callSiteArray[308].call(callSiteArray[309].call(callSiteArray[310].call(callSiteArray[311].call(callSiteArray[312].call(callSiteArray[313].call((Object)"there are no lines matching regexp <# exam34ple>, <# .roc3edur.> in <sample-with-multi-marker.py>:\n", (Object)"# example: how to print\n"), (Object)"print(\"hello\")\n"), (Object)"# example-end\n"), (Object)"\n"), (Object)"# procedure: how to print\n"), (Object)"print(\"hello world\")\n"), (Object)"# procedure-end")));
    }

    @Test
    public void should validate highlight lines presence when highlight is a line idx() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[314].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 3}");
        } else {
            FileIncludePluginTest.resultingSnippet("script.groovy", "{highlight: 3}");
        }
        public final class _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure17
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure17(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure17.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure17.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{highlight: 7}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure17.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure17.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure17.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[315].call(callSiteArray[316].callStatic(Matchers.class, (Object)new _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure17(this, this)), callSiteArray[317].callStatic(Matchers.class, callSiteArray[318].call((Object)"highlight idx is out of range: 7\n", (Object)"check: script.groovy")));
    }

    @Test
    public void should validate highlight lines presence when highlight is a text() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[319].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 'def a'}");
        } else {
            FileIncludePluginTest.resultingSnippet("script.groovy", "{highlight: 'def a'}");
        }
        public final class _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure18
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure18(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure18.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure18.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{highlight: 'def c'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure18.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_highlight_lines_presence_when_highlight_is_a_text_closure18.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure18.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[320].call(callSiteArray[321].callStatic(Matchers.class, (Object)new _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure18(this, this)), callSiteArray[322].callStatic(Matchers.class, callSiteArray[323].call(callSiteArray[324].call(callSiteArray[325].call(callSiteArray[326].call(callSiteArray[327].call(callSiteArray[328].call(callSiteArray[329].call(callSiteArray[330].call((Object)"highlight text <def c> is not found\n", (Object)"check: script.groovy\n"), (Object)"import e.d.g.AnotherName\n"), (Object)"import a.b.c.ClassName\n"), (Object)"\n"), (Object)"class HelloWorld {\n"), (Object)"    def a\n"), (Object)"    int b\n"), (Object)"}")));
    }

    @Test
    public void should highlight lines based on contains() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object props = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            props = object = callSiteArray[331].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 'class'}");
        } else {
            Map<String, Object> map = FileIncludePluginTest.resultingProps("script.groovy", "{highlight: 'class'}");
            props = map;
        }
        callSiteArray[332].call(callSiteArray[333].callGetProperty(props), callSiteArray[334].callStatic(WebTauCore.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{3})));
    }

    @Test
    public void should highlight all lines based on contains() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object props = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            props = object = callSiteArray[335].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 'import'}");
        } else {
            Map<String, Object> map = FileIncludePluginTest.resultingProps("script.groovy", "{highlight: 'import'}");
            props = map;
        }
        callSiteArray[336].call(callSiteArray[337].callGetProperty(props), callSiteArray[338].callStatic(WebTauCore.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{0, 1})));
    }

    @Test
    public void should highlight lines from a highlight text file() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object props = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            props = object = callSiteArray[339].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlightPath: 'highlight.txt'}");
        } else {
            Map<String, Object> map = FileIncludePluginTest.resultingProps("script.groovy", "{highlightPath: 'highlight.txt'}");
            props = map;
        }
        callSiteArray[340].call(callSiteArray[341].callGetProperty(props), callSiteArray[342].callStatic(WebTauCore.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{4, 5})));
    }

    @Test
    public void when title is not set should auto generate title based file name() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[343].call(callSiteArray[344].callGetProperty(callSiteArray[345].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{autoTitle: true}")), callSiteArray[346].callStatic(WebTauCore.class, (Object)"script.groovy"));
            callSiteArray[347].call(callSiteArray[348].callGetProperty(callSiteArray[349].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{autoTitle: false}")), callSiteArray[350].callStatic(WebTauCore.class, null));
        } else {
            callSiteArray[351].call(callSiteArray[352].callGetProperty(FileIncludePluginTest.resultingProps("script.groovy", "{autoTitle: true}")), callSiteArray[353].callStatic(WebTauCore.class, (Object)"script.groovy"));
            callSiteArray[354].call(callSiteArray[355].callGetProperty(FileIncludePluginTest.resultingProps("script.groovy", "{autoTitle: false}")), callSiteArray[356].callStatic(WebTauCore.class, null));
        }
    }

    @Test
    public void should not allow autoTitle and title() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_not_allow_autoTitle_and_title_closure19
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_not_allow_autoTitle_and_title_closure19(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_not_allow_autoTitle_and_title_closure19.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_not_allow_autoTitle_and_title_closure19.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(callSiteArray[2].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{title: 'hello', autoTitle: false}")), callSiteArray[3].callStatic(WebTauCore.class, null));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_not_allow_autoTitle_and_title_closure19.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_not_allow_autoTitle_and_title_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "should";
                stringArray[1] = "title";
                stringArray[2] = "resultingProps";
                stringArray[3] = "equal";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _should_not_allow_autoTitle_and_title_closure19.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_should_not_allow_autoTitle_and_title_closure19.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_not_allow_autoTitle_and_title_closure19.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[357].call(callSiteArray[358].callStatic(Matchers.class, (Object)new _should_not_allow_autoTitle_and_title_closure19(this, this)), callSiteArray[359].callStatic(Matchers.class, (Object)"Can't have both <title> and <autoTitle> specified"));
    }

    @Test
    public void should validate lines from a highlight text file() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_validate_lines_from_a_highlight_text_file_closure20
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_lines_from_a_highlight_text_file_closure20(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure20.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure20.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{highlightPath: 'missing-highlight.txt'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure20.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_lines_from_a_highlight_text_file_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingProps";
                return new CallSiteArray(_should_validate_lines_from_a_highlight_text_file_closure20.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure20.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[360].call(callSiteArray[361].callStatic(Matchers.class, (Object)new _should_validate_lines_from_a_highlight_text_file_closure20(this, this)), callSiteArray[362].callStatic(Matchers.class, ScriptBytecodeAdapter.bitwiseNegate((Object)"highlightPath text <def g> is not found")));
    }

    private static String resultingSnippet(String fileName, String value) {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[363].call(PluginsTestUtils.class, (Object)new GStringImpl(new Object[]{fileName, value}, new String[]{":include-file: ", " ", ""})));
    }

    private static Map<String, Object> resultingProps(String fileName, String value) {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[364].call(PluginsTestUtils.class, (Object)new GStringImpl(new Object[]{fileName, value}, new String[]{":include-file: ", " ", ""})), Map.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileIncludePluginTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "resultingSnippet";
        stringArray[1] = "should";
        stringArray[2] = "equal";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "plus";
        stringArray[10] = "plus";
        stringArray[11] = "resultingSnippet";
        stringArray[12] = "should";
        stringArray[13] = "equal";
        stringArray[14] = "plus";
        stringArray[15] = "resultingSnippet";
        stringArray[16] = "should";
        stringArray[17] = "equal";
        stringArray[18] = "plus";
        stringArray[19] = "plus";
        stringArray[20] = "resultingSnippet";
        stringArray[21] = "should";
        stringArray[22] = "equal";
        stringArray[23] = "plus";
        stringArray[24] = "plus";
        stringArray[25] = "plus";
        stringArray[26] = "should";
        stringArray[27] = "code";
        stringArray[28] = "throwException";
        stringArray[29] = "should";
        stringArray[30] = "code";
        stringArray[31] = "throwException";
        stringArray[32] = "plus";
        stringArray[33] = "plus";
        stringArray[34] = "plus";
        stringArray[35] = "should";
        stringArray[36] = "code";
        stringArray[37] = "throwException";
        stringArray[38] = "plus";
        stringArray[39] = "plus";
        stringArray[40] = "plus";
        stringArray[41] = "plus";
        stringArray[42] = "plus";
        stringArray[43] = "plus";
        stringArray[44] = "plus";
        stringArray[45] = "should";
        stringArray[46] = "code";
        stringArray[47] = "throwException";
        stringArray[48] = "plus";
        stringArray[49] = "plus";
        stringArray[50] = "plus";
        stringArray[51] = "plus";
        stringArray[52] = "plus";
        stringArray[53] = "resultingSnippet";
        stringArray[54] = "should";
        stringArray[55] = "equal";
        stringArray[56] = "resultingSnippet";
        stringArray[57] = "should";
        stringArray[58] = "equal";
        stringArray[59] = "plus";
        stringArray[60] = "plus";
        stringArray[61] = "plus";
        stringArray[62] = "plus";
        stringArray[63] = "plus";
        stringArray[64] = "plus";
        stringArray[65] = "plus";
        stringArray[66] = "plus";
        stringArray[67] = "plus";
        stringArray[68] = "plus";
        stringArray[69] = "should";
        stringArray[70] = "code";
        stringArray[71] = "throwException";
        stringArray[72] = "plus";
        stringArray[73] = "plus";
        stringArray[74] = "plus";
        stringArray[75] = "trim";
        stringArray[76] = "textContent";
        stringArray[77] = "resultingSnippet";
        stringArray[78] = "should";
        stringArray[79] = "equal";
        stringArray[80] = "plus";
        stringArray[81] = "plus";
        stringArray[82] = "plus";
        stringArray[83] = "plus";
        stringArray[84] = "plus";
        stringArray[85] = "plus";
        stringArray[86] = "plus";
        stringArray[87] = "resultingSnippet";
        stringArray[88] = "should";
        stringArray[89] = "equal";
        stringArray[90] = "plus";
        stringArray[91] = "resultingSnippet";
        stringArray[92] = "should";
        stringArray[93] = "equal";
        stringArray[94] = "plus";
        stringArray[95] = "plus";
        stringArray[96] = "plus";
        stringArray[97] = "resultingSnippet";
        stringArray[98] = "should";
        stringArray[99] = "equal";
        stringArray[100] = "plus";
        stringArray[101] = "plus";
        stringArray[102] = "plus";
        stringArray[103] = "resultingSnippet";
        stringArray[104] = "plus";
        stringArray[105] = "should";
        stringArray[106] = "equal";
        stringArray[107] = "plus";
        stringArray[108] = "plus";
        stringArray[109] = "plus";
        stringArray[110] = "plus";
        stringArray[111] = "plus";
        stringArray[112] = "plus";
        stringArray[113] = "plus";
        stringArray[114] = "plus";
        stringArray[115] = "plus";
        stringArray[116] = "resultingSnippet";
        stringArray[117] = "should";
        stringArray[118] = "equal";
        stringArray[119] = "plus";
        stringArray[120] = "plus";
        stringArray[121] = "should";
        stringArray[122] = "code";
        stringArray[123] = "throwException";
        stringArray[124] = "plus";
        stringArray[125] = "trim";
        stringArray[126] = "textContent";
        stringArray[127] = "should";
        stringArray[128] = "code";
        stringArray[129] = "throwException";
        stringArray[130] = "plus";
        stringArray[131] = "trim";
        stringArray[132] = "textContent";
        stringArray[133] = "should";
        stringArray[134] = "code";
        stringArray[135] = "throwException";
        stringArray[136] = "plus";
        stringArray[137] = "trim";
        stringArray[138] = "textContent";
        stringArray[139] = "resultingSnippet";
        stringArray[140] = "should";
        stringArray[141] = "equal";
        stringArray[142] = "plus";
        stringArray[143] = "plus";
        stringArray[144] = "resultingSnippet";
        stringArray[145] = "should";
        stringArray[146] = "equal";
        stringArray[147] = "plus";
        stringArray[148] = "plus";
        stringArray[149] = "resultingSnippet";
        stringArray[150] = "should";
        stringArray[151] = "equal";
        stringArray[152] = "plus";
        stringArray[153] = "plus";
        stringArray[154] = "resultingSnippet";
        stringArray[155] = "should";
        stringArray[156] = "equal";
        stringArray[157] = "plus";
        stringArray[158] = "plus";
        stringArray[159] = "plus";
        stringArray[160] = "should";
        stringArray[161] = "code";
        stringArray[162] = "throwException";
        stringArray[163] = "should";
        stringArray[164] = "code";
        stringArray[165] = "throwException";
        stringArray[166] = "should";
        stringArray[167] = "code";
        stringArray[168] = "throwException";
        stringArray[169] = "resultingSnippet";
        stringArray[170] = "should";
        stringArray[171] = "equal";
        stringArray[172] = "plus";
        stringArray[173] = "plus";
        stringArray[174] = "plus";
        stringArray[175] = "plus";
        stringArray[176] = "resultingSnippet";
        stringArray[177] = "should";
        stringArray[178] = "equal";
        stringArray[179] = "plus";
        stringArray[180] = "plus";
        stringArray[181] = "plus";
        stringArray[182] = "plus";
        stringArray[183] = "resultingSnippet";
        stringArray[184] = "should";
        stringArray[185] = "equal";
        stringArray[186] = "plus";
        stringArray[187] = "plus";
        stringArray[188] = "plus";
        stringArray[189] = "plus";
        stringArray[190] = "plus";
        stringArray[191] = "resultingSnippet";
        stringArray[192] = "should";
        stringArray[193] = "equal";
        stringArray[194] = "plus";
        stringArray[195] = "plus";
        stringArray[196] = "plus";
        stringArray[197] = "resultingSnippet";
        stringArray[198] = "should";
        stringArray[199] = "equal";
        stringArray[200] = "plus";
        stringArray[201] = "plus";
        stringArray[202] = "plus";
        stringArray[203] = "plus";
        stringArray[204] = "resultingSnippet";
        stringArray[205] = "should";
        stringArray[206] = "equal";
        stringArray[207] = "plus";
        stringArray[208] = "plus";
        stringArray[209] = "plus";
        stringArray[210] = "plus";
        stringArray[211] = "plus";
        stringArray[212] = "plus";
        stringArray[213] = "plus";
        stringArray[214] = "plus";
        stringArray[215] = "plus";
        stringArray[216] = "plus";
        stringArray[217] = "plus";
        stringArray[218] = "plus";
        stringArray[219] = "plus";
        stringArray[220] = "plus";
        stringArray[221] = "resultingSnippet";
        stringArray[222] = "should";
        stringArray[223] = "equal";
        stringArray[224] = "plus";
        stringArray[225] = "plus";
        stringArray[226] = "plus";
        stringArray[227] = "plus";
        stringArray[228] = "plus";
        stringArray[229] = "plus";
        stringArray[230] = "plus";
        stringArray[231] = "plus";
        stringArray[232] = "plus";
        stringArray[233] = "plus";
        stringArray[234] = "plus";
        stringArray[235] = "plus";
        stringArray[236] = "should";
        stringArray[237] = "code";
        stringArray[238] = "throwException";
        stringArray[239] = "plus";
        stringArray[240] = "plus";
        stringArray[241] = "plus";
        stringArray[242] = "trim";
        stringArray[243] = "textContent";
        stringArray[244] = "resultingSnippet";
        stringArray[245] = "should";
        stringArray[246] = "equal";
        stringArray[247] = "plus";
        stringArray[248] = "resultingSnippet";
        stringArray[249] = "should";
        stringArray[250] = "equal";
        stringArray[251] = "plus";
        stringArray[252] = "should";
        stringArray[253] = "code";
        stringArray[254] = "throwException";
        stringArray[255] = "plus";
        stringArray[256] = "plus";
        stringArray[257] = "plus";
        stringArray[258] = "plus";
        stringArray[259] = "plus";
        stringArray[260] = "plus";
        stringArray[261] = "plus";
        stringArray[262] = "resultingSnippet";
        stringArray[263] = "should";
        stringArray[264] = "equal";
        stringArray[265] = "resultingSnippet";
        stringArray[266] = "should";
        stringArray[267] = "equal";
        stringArray[268] = "plus";
        stringArray[269] = "resultingSnippet";
        stringArray[270] = "should";
        stringArray[271] = "equal";
        stringArray[272] = "plus";
        stringArray[273] = "should";
        stringArray[274] = "code";
        stringArray[275] = "throwException";
        stringArray[276] = "plus";
        stringArray[277] = "plus";
        stringArray[278] = "plus";
        stringArray[279] = "plus";
        stringArray[280] = "plus";
        stringArray[281] = "plus";
        stringArray[282] = "plus";
        stringArray[283] = "resultingSnippet";
        stringArray[284] = "should";
        stringArray[285] = "equal";
        stringArray[286] = "should";
        stringArray[287] = "code";
        stringArray[288] = "throwException";
        stringArray[289] = "plus";
        stringArray[290] = "plus";
        stringArray[291] = "plus";
        stringArray[292] = "plus";
        stringArray[293] = "plus";
        stringArray[294] = "plus";
        stringArray[295] = "plus";
        stringArray[296] = "resultingSnippet";
        stringArray[297] = "should";
        stringArray[298] = "equal";
        stringArray[299] = "resultingSnippet";
        stringArray[300] = "should";
        stringArray[301] = "equal";
        stringArray[302] = "plus";
        stringArray[303] = "plus";
        stringArray[304] = "should";
        stringArray[305] = "code";
        stringArray[306] = "throwException";
        stringArray[307] = "plus";
        stringArray[308] = "plus";
        stringArray[309] = "plus";
        stringArray[310] = "plus";
        stringArray[311] = "plus";
        stringArray[312] = "plus";
        stringArray[313] = "plus";
        stringArray[314] = "resultingSnippet";
        stringArray[315] = "should";
        stringArray[316] = "code";
        stringArray[317] = "throwException";
        stringArray[318] = "plus";
        stringArray[319] = "resultingSnippet";
        stringArray[320] = "should";
        stringArray[321] = "code";
        stringArray[322] = "throwException";
        stringArray[323] = "plus";
        stringArray[324] = "plus";
        stringArray[325] = "plus";
        stringArray[326] = "plus";
        stringArray[327] = "plus";
        stringArray[328] = "plus";
        stringArray[329] = "plus";
        stringArray[330] = "plus";
        stringArray[331] = "resultingProps";
        stringArray[332] = "should";
        stringArray[333] = "highlight";
        stringArray[334] = "equal";
        stringArray[335] = "resultingProps";
        stringArray[336] = "should";
        stringArray[337] = "highlight";
        stringArray[338] = "equal";
        stringArray[339] = "resultingProps";
        stringArray[340] = "should";
        stringArray[341] = "highlight";
        stringArray[342] = "equal";
        stringArray[343] = "should";
        stringArray[344] = "title";
        stringArray[345] = "resultingProps";
        stringArray[346] = "equal";
        stringArray[347] = "should";
        stringArray[348] = "title";
        stringArray[349] = "resultingProps";
        stringArray[350] = "equal";
        stringArray[351] = "should";
        stringArray[352] = "title";
        stringArray[353] = "equal";
        stringArray[354] = "should";
        stringArray[355] = "title";
        stringArray[356] = "equal";
        stringArray[357] = "should";
        stringArray[358] = "code";
        stringArray[359] = "throwException";
        stringArray[360] = "should";
        stringArray[361] = "code";
        stringArray[362] = "throwException";
        stringArray[363] = "processAndGetSimplifiedCodeBlock";
        stringArray[364] = "processIncludeAndGetProps";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[365];
        FileIncludePluginTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(FileIncludePluginTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = FileIncludePluginTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

