/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import java.util.ArrayList;
import java.util.List;

public class SnippetContainerEntriesConverter {
    private final String[] lines;
    private final String content;
    private final String snippetId;

    public SnippetContainerEntriesConverter(String snippetId, String content) {
        this.content = content;
        this.snippetId = snippetId;
        this.lines = content.split("\n");
    }

    public List<Integer> convertAndValidate(String label, List<Object> idxOrContains) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Object idxOrText : idxOrContains) {
            if (idxOrText instanceof Number) {
                result.add(this.validateIdx(label, (Number)idxOrText));
                continue;
            }
            result.addAll(this.validateContainsAndGetIdx(label, (String)idxOrText));
        }
        return result;
    }

    public int validateIdx(String label, Number idx) {
        int idxInt = idx.intValue();
        if (idxInt >= this.lines.length || idxInt < 0) {
            throw new IllegalArgumentException(label + " idx is out of range: " + idx + this.exceptionIdMessage());
        }
        return idxInt;
    }

    public String[] getLines() {
        return this.lines;
    }

    public int findAndValidateFirstContain(String label, int startIdx, String partial) {
        for (int idx = startIdx; idx < this.lines.length; ++idx) {
            String line = this.lines[idx];
            if (!line.contains(partial)) continue;
            return idx;
        }
        throw new IllegalArgumentException(this.notFoundMessage(label, partial));
    }

    public List<Integer> findAllContainsIdx(String partial) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int idx = 0;
        for (String line : this.lines) {
            if (line.contains(partial)) {
                result.add(idx);
            }
            ++idx;
        }
        return result;
    }

    public List<Integer> validateContainsAndGetIdx(String label, String partial) {
        List<Integer> containsIndexes = this.findAllContainsIdx(partial);
        if (containsIndexes.isEmpty()) {
            throw new IllegalArgumentException(this.notFoundMessage(label, partial));
        }
        return containsIndexes;
    }

    private String notFoundMessage(String label, String partial) {
        return label + " text <" + partial + "> is not found" + this.exceptionIdMessage() + "\n" + this.content;
    }

    private String exceptionIdMessage() {
        if (this.snippetId.isEmpty()) {
            return "";
        }
        return "\ncheck: " + this.snippetId;
    }
}

