/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.features.PluginFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetCleaner;
import org.testingisdocumenting.znai.extensions.file.SnippetContainerEntriesConverter;
import org.testingisdocumenting.znai.extensions.file.SnippetContentProvider;
import org.testingisdocumenting.znai.text.RegionScopeExtractor;
import org.testingisdocumenting.znai.text.TextLinesAccessor;

public class SnippetHighlightFeature
implements PluginFeature {
    public static final PluginParamsDefinition paramsDefinition = SnippetHighlightFeature.createParamsDefinition();
    private static final String HIGHLIGHT_KEY = "highlight";
    private static final String HIGHLIGHT_PATH_KEY = "highlightPath";
    private static final String HIGHLIGHT_REGION_KEY = "highlightRegion";
    private static final String HIGHLIGHT_REGION_START_SUB_KEY = "start";
    private static final String HIGHLIGHT_REGION_END_SUB_KEY = "end";
    private static final String HIGHLIGHT_REGION_SCOPE_SUB_KEY = "scope";
    private static final String HIGHLIGHT_REGION_START_FULL_KEY = "highlightRegion.start";
    private static final String HIGHLIGHT_REGION_END_FULL_KEY = "highlightRegion.end";
    private final ComponentsRegistry componentsRegistry;
    private final Path highlightFileFullPath;
    private final String highlightPath;
    private final PluginParams pluginParams;
    private final SnippetContainerEntriesConverter snippetIdxConverter;

    public SnippetHighlightFeature(ComponentsRegistry componentsRegistry, PluginParams pluginParams, SnippetContentProvider contentProvider) {
        this.componentsRegistry = componentsRegistry;
        this.pluginParams = pluginParams;
        this.highlightPath = pluginParams.getOpts().get(HIGHLIGHT_PATH_KEY, null);
        this.highlightFileFullPath = this.highlightPath != null ? componentsRegistry.resourceResolver().fullPath(this.highlightPath) : null;
        this.snippetIdxConverter = new SnippetContainerEntriesConverter(contentProvider.snippetId(), SnippetCleaner.removeNonAnsiCharacters(contentProvider.snippetContent()));
    }

    @Override
    public void updateProps(Map<String, Object> props) {
        Set<Integer> indexes = this.generateHighlightIndexes(this.pluginParams);
        if (indexes.isEmpty()) {
            return;
        }
        props.put(HIGHLIGHT_KEY, indexes);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles() {
        return this.highlightFileFullPath != null ? Stream.of(AuxiliaryFile.builtTime(this.highlightFileFullPath)) : Stream.empty();
    }

    private Set<Integer> generateHighlightIndexes(PluginParams pluginParams) {
        TreeSet<Integer> combined = new TreeSet<Integer>();
        combined.addAll(this.generateHighlightIndexesFromPassed(pluginParams));
        combined.addAll(this.generateHighlightIndexesFromFile());
        combined.addAll(this.generateIndexesFromRegionsList(pluginParams));
        return combined;
    }

    private List<Integer> generateHighlightIndexesFromPassed(PluginParams pluginParams) {
        List<Object> passed = pluginParams.getOpts().getList(HIGHLIGHT_KEY);
        return this.generateHighlightIndexesFromStringOrIdx(HIGHLIGHT_KEY, passed);
    }

    private List<Integer> generateHighlightIndexesFromFile() {
        if (this.highlightPath == null) {
            return Collections.emptyList();
        }
        String textContent = this.componentsRegistry.resourceResolver().textContent(this.highlightPath);
        List<Object> fromFile = Arrays.asList(textContent.split("\n"));
        return this.generateHighlightIndexesFromStringOrIdx(HIGHLIGHT_PATH_KEY, fromFile);
    }

    private List<Integer> generateIndexesFromRegionsList(PluginParams pluginParams) {
        List regionList = pluginParams.getOpts().getList(HIGHLIGHT_REGION_KEY);
        return regionList.stream().flatMap(m3 -> this.generateIndexesFromRegionMap(m3).stream()).toList();
    }

    private List<Integer> generateIndexesFromRegionMap(Object regionRaw) {
        if (!(regionRaw instanceof Map)) {
            throw new IllegalArgumentException(SnippetHighlightFeature.regionWrongFormatMessage());
        }
        Map region = (Map)regionRaw;
        if (region.containsKey(HIGHLIGHT_REGION_SCOPE_SUB_KEY)) {
            return this.generateIndexesFromRegionScope(region);
        }
        return this.generateIndexesFromRegionStartEnd(region);
    }

    private List<Integer> generateIndexesFromRegionScope(Map<String, Object> region) {
        String start = this.getRequiredStringSubValue(region, HIGHLIGHT_REGION_START_SUB_KEY);
        String scope = this.getRequiredStringSubValue(region, HIGHLIGHT_REGION_SCOPE_SUB_KEY);
        int startIdx = this.snippetIdxConverter.findAndValidateFirstContain(HIGHLIGHT_REGION_START_FULL_KEY, 0, start);
        RegionScopeExtractor regionScopeExtractor = new RegionScopeExtractor(TextLinesAccessor.createFromArray(this.snippetIdxConverter.getLines()), startIdx, scope);
        regionScopeExtractor.process();
        if (regionScopeExtractor.getResultEndLineIdx() == -1) {
            throw new IllegalArgumentException("can't find region to highlight that starts with line: \"" + start + "\" and scoped with: " + scope);
        }
        return SnippetHighlightFeature.generateIndexesFromStartAndEnd(regionScopeExtractor.getResultStartLineIdx(), regionScopeExtractor.getResultEndLineIdx());
    }

    private List<Integer> generateIndexesFromRegionStartEnd(Map<String, Object> region) {
        String start = this.getRequiredStringSubValue(region, HIGHLIGHT_REGION_START_SUB_KEY);
        String end = this.getRequiredStringSubValue(region, HIGHLIGHT_REGION_END_SUB_KEY);
        int startIdx = this.snippetIdxConverter.findAndValidateFirstContain(HIGHLIGHT_REGION_START_FULL_KEY, 0, start);
        int endIdx = this.snippetIdxConverter.findAndValidateFirstContain(HIGHLIGHT_REGION_END_FULL_KEY, startIdx + 1, end);
        return SnippetHighlightFeature.generateIndexesFromStartAndEnd(startIdx, endIdx);
    }

    private static List<Integer> generateIndexesFromStartAndEnd(int startIdx, int endIdx) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int idx = startIdx; idx <= endIdx; ++idx) {
            result.add(idx);
        }
        return result;
    }

    private List<Integer> generateHighlightIndexesFromStringOrIdx(String paramKeyForValidation, List<Object> idsOrStrings) {
        return this.snippetIdxConverter.convertAndValidate(paramKeyForValidation, idsOrStrings);
    }

    private static PluginParamsDefinition createParamsDefinition() {
        return new PluginParamsDefinition().add(HIGHLIGHT_KEY, PluginParamType.LIST_OR_SINGLE_STRING_OR_NUMBER, "lines to highlight by index or partial match", "[3, \"constructor\"] or \"class\"").add(HIGHLIGHT_PATH_KEY, PluginParamType.STRING, "path to a file with lines to highlight", "highlight.txt").add(HIGHLIGHT_REGION_KEY, PluginParamType.LIST_OR_OBJECT, "region to highlight", "{start: \"line-a\", end: \"line-b\"}");
    }

    private String getRequiredStringSubValue(Map<String, Object> values, String subKey) {
        Object valueRaw = values.get(subKey);
        if (valueRaw == null) {
            throw new IllegalArgumentException("highlightRegion." + subKey + " is missing");
        }
        if (!(valueRaw instanceof String)) {
            throw new IllegalArgumentException(SnippetHighlightFeature.regionWrongFormatMessage());
        }
        String value = valueRaw.toString();
        if (value.isEmpty()) {
            throw new IllegalArgumentException("highlightRegion." + subKey + " can't be empty");
        }
        return value;
    }

    private static String regionWrongFormatMessage() {
        return "highlightRegion should be in format {start: \"line-star\", end: \"line-end\"} or {\"start\": \"line-star\", scope: \"{}\"}";
    }
}

