/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.json;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.Plugin;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinitionCommon;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.features.PluginFeature;
import org.testingisdocumenting.znai.extensions.features.PluginFeatureList;
import org.testingisdocumenting.znai.extensions.file.AnchorFeature;
import org.testingisdocumenting.znai.extensions.file.CodeReferencesFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetHighlightFeature;
import org.testingisdocumenting.znai.extensions.json.JsonPaths;
import org.testingisdocumenting.znai.extensions.validation.EntryPresenceValidation;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.commonmark.MarkdownParser;
import org.testingisdocumenting.znai.parser.table.CsvTableParser;
import org.testingisdocumenting.znai.parser.table.MarkupTableData;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.utils.JsonUtils;
import znaishaded.com.jayway.jsonpath.JsonPath;
import znaishaded.com.jayway.jsonpath.Predicate;

public abstract class JsonBasePlugin
implements Plugin {
    private static final String INCLUDE_KEY = "include";
    private static final String HIGHLIGHT_KEYS_KEY = "highlightKey";
    private static final String HIGHLIGHT_KEYS_FILE_KEY = "highlightKeyFile";
    private static final String HIGHLIGHT_VALUES_KEY = "highlightValue";
    private static final String HIGHLIGHT_VALUES_FILE_KEY = "highlightValueFile";
    private static final String COLLAPSED_PATHS_KEY = "collapsedPaths";
    private static final String ENCLOSE_IN_OBJECT_KEY = "encloseInObject";
    private static final String CALLOUTS_KEY = "callouts";
    private static final String CALLOUTS_FILE_KEY = "calloutsFile";
    private static final String HIGHLIGHT_VALUES_DEPRECATED_KEY = "paths";
    private static final String HIGHLIGHT_VALUES_DEPRECATED_FILE_KEY = "pathsFile";
    private Path highlightValuesFilePath;
    private Path highlightKeysFilePath;
    private Path calloutsFilePath;
    protected PluginFeatureList features;
    protected ResourcesResolver resourcesResolver;
    private MarkdownParser markdownParser;

    @Override
    public String id() {
        return "json";
    }

    @Override
    public PluginParamsDefinition parameters() {
        PluginParamsDefinition params = new PluginParamsDefinition().add(PluginParamsDefinitionCommon.title).add(INCLUDE_KEY, PluginParamType.STRING, "json path to include", "$..book[0,1]").add(HIGHLIGHT_VALUES_KEY, PluginParamType.LIST_OR_SINGLE_STRING, "path(s) to leaf values to highlight", "\"root.store.book[0].category\" or [\"root.store.book[0].category\", \"root.store.book[2].category\"]").add(HIGHLIGHT_VALUES_FILE_KEY, PluginParamType.STRING, "path to a json file with list of paths to highlight values", "\"paths.json\"").add(HIGHLIGHT_KEYS_KEY, PluginParamType.LIST_OR_SINGLE_STRING, "path(s) to key to highlight", "\"root.store.book[0].category\" or [\"root.store.book[0].category\", \"root.store.book[2].category\"]").add(HIGHLIGHT_KEYS_FILE_KEY, PluginParamType.STRING, "path to a json file with list of paths to highlight keys", "\"paths.json\"").add(COLLAPSED_PATHS_KEY, PluginParamType.LIST_OR_SINGLE_STRING, "path(s) to nodes to collapse initially", "\"root.store.book\" or [\"root.store.book\", \"root.store.discount\"]").add(ENCLOSE_IN_OBJECT_KEY, PluginParamType.STRING, "wrap resulting json into an extra object with provided parent(s)", "\"person.address\"").add(CALLOUTS_KEY, PluginParamType.OBJECT, "callout text per json path", "{\"root.key1.nested[0]\": \"important value for config\"").add(CALLOUTS_FILE_KEY, PluginParamType.STRING, "json or csv file with callout text per json path", "\"common-callouts.json\"").add(SnippetHighlightFeature.paramsDefinition).add(PluginParamsDefinitionCommon.snippetReadMore).add(CodeReferencesFeature.paramsDefinition).add(AnchorFeature.paramsDefinition).rename(HIGHLIGHT_VALUES_DEPRECATED_KEY, HIGHLIGHT_VALUES_KEY).rename(HIGHLIGHT_VALUES_DEPRECATED_FILE_KEY, HIGHLIGHT_VALUES_FILE_KEY);
        this.registerAdditionalParams(params);
        return params;
    }

    public PluginResult commonProcess(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String jsonText) {
        this.resourcesResolver = componentsRegistry.resourceResolver();
        this.markdownParser = componentsRegistry.markdownParser();
        PluginParamsOpts opts = pluginParams.getOpts();
        String jsonPath = opts.get(INCLUDE_KEY, "$");
        Object parsed = JsonPath.read(jsonText, jsonPath, new Predicate[0]);
        parsed = this.encloseInObjectIfRequired(opts, parsed);
        this.features = new PluginFeatureList(new CodeReferencesFeature(componentsRegistry, markupPath, pluginParams));
        this.additionalPluginFeatures().forEach(this.features::add);
        this.features.add(new AnchorFeature(componentsRegistry.docStructure(), markupPath, pluginParams));
        Set<String> existingPaths = JsonBasePlugin.buildPaths(parsed);
        List<String> highlightValues = this.extractHighlightValues(opts);
        EntryPresenceValidation.validateItemsPresence(HIGHLIGHT_VALUES_KEY, "JSON", existingPaths, highlightValues);
        List<String> highlightKeys = this.extractHighlightKeys(opts);
        EntryPresenceValidation.validateItemsPresence(HIGHLIGHT_KEYS_KEY, "JSON", existingPaths, highlightKeys);
        List<String> collapsedPaths = opts.getList(COLLAPSED_PATHS_KEY);
        EntryPresenceValidation.validateItemsPresence(COLLAPSED_PATHS_KEY, "JSON", existingPaths, collapsedPaths);
        Map<String, List<Map<String, Object>>> docElementDescByPath = this.extractAndParseCallouts(markupPath, opts);
        EntryPresenceValidation.validateItemsPresence(CALLOUTS_KEY, "JSON", existingPaths, docElementDescByPath.keySet());
        Map<String, Object> props = opts.toMap();
        props.put("data", parsed);
        props.put("highlightValues", highlightValues);
        props.put("highlightKeys", highlightKeys);
        if (!docElementDescByPath.isEmpty()) {
            props.put("calloutsByPath", docElementDescByPath);
        }
        this.features.updateProps(props);
        props.remove(HIGHLIGHT_KEYS_KEY);
        props.remove(HIGHLIGHT_KEYS_FILE_KEY);
        props.remove(HIGHLIGHT_VALUES_KEY);
        props.remove(HIGHLIGHT_VALUES_FILE_KEY);
        props.remove(HIGHLIGHT_VALUES_DEPRECATED_KEY);
        props.remove(HIGHLIGHT_VALUES_DEPRECATED_FILE_KEY);
        props.remove(CALLOUTS_KEY);
        return PluginResult.docElement("Json", props);
    }

    private Object encloseInObjectIfRequired(PluginParamsOpts opts, Object original) {
        String enclosePath = opts.getString(ENCLOSE_IN_OBJECT_KEY);
        if (enclosePath == null) {
            return original;
        }
        if ((enclosePath = enclosePath.trim()).isEmpty()) {
            throw new IllegalArgumentException("encloseInObject can't be empty");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] parts = enclosePath.split("\\.");
        HashMap<String, Object> cursor = result;
        for (int idx = 0; idx < parts.length - 1; ++idx) {
            String part = parts[idx];
            HashMap entry = new HashMap();
            cursor.put(part, entry);
            cursor = entry;
        }
        cursor.put(parts[parts.length - 1], original);
        return result;
    }

    protected abstract void registerAdditionalParams(PluginParamsDefinition var1);

    protected abstract Stream<PluginFeature> additionalPluginFeatures();

    protected abstract Stream<AuxiliaryFile> additionalAuxiliaryFiles();

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        Stream pathsFile = this.highlightValuesFilePath == null ? Stream.empty() : Stream.of(AuxiliaryFile.builtTime(this.highlightValuesFilePath));
        Stream highlightKeysFile = this.highlightKeysFilePath == null ? Stream.empty() : Stream.of(AuxiliaryFile.builtTime(this.highlightKeysFilePath));
        Stream calloutsFile = this.calloutsFilePath == null ? Stream.empty() : Stream.of(AuxiliaryFile.builtTime(this.calloutsFilePath));
        return Stream.concat(pathsFile, Stream.concat(highlightKeysFile, Stream.concat(calloutsFile, Stream.concat(this.features.auxiliaryFiles(), this.additionalAuxiliaryFiles()))));
    }

    private List<String> extractHighlightValues(PluginParamsOpts opts) {
        if (opts.has(HIGHLIGHT_VALUES_FILE_KEY)) {
            String filePath = (String)opts.get(HIGHLIGHT_VALUES_FILE_KEY);
            this.highlightValuesFilePath = this.resourcesResolver.fullPath(filePath);
            return JsonUtils.deserializeAsList(this.resourcesResolver.textContent(filePath));
        }
        return opts.getList(HIGHLIGHT_VALUES_KEY);
    }

    private List<String> extractHighlightKeys(PluginParamsOpts opts) {
        if (opts.has(HIGHLIGHT_KEYS_FILE_KEY)) {
            String filePath = (String)opts.get(HIGHLIGHT_KEYS_FILE_KEY);
            this.highlightKeysFilePath = this.resourcesResolver.fullPath(filePath);
            return JsonUtils.deserializeAsList(this.resourcesResolver.textContent(filePath));
        }
        return opts.getList(HIGHLIGHT_KEYS_KEY);
    }

    private Map<String, List<Map<String, Object>>> extractAndParseCallouts(Path parentFilePath, PluginParamsOpts opts) {
        if (opts.has(CALLOUTS_KEY)) {
            Map markdownByPath = (Map)opts.get(CALLOUTS_KEY);
            return this.convertMarkdownToDocElements(this.markdownParser, parentFilePath, markdownByPath);
        }
        if (opts.has(CALLOUTS_FILE_KEY)) {
            String filePath = (String)opts.get(CALLOUTS_FILE_KEY);
            this.calloutsFilePath = this.resourcesResolver.fullPath(filePath);
            Map<String, ?> markdownByPath = this.parseCallouts(this.resourcesResolver.textContent(filePath));
            return this.convertMarkdownToDocElements(this.markdownParser, parentFilePath, markdownByPath);
        }
        return Collections.emptyMap();
    }

    private Map<String, ?> parseCallouts(String content) {
        return (content = content.trim()).startsWith("{") ? this.parseCalloutsJson(content) : this.parseCalloutsCsv(content);
    }

    private Map<String, ?> parseCalloutsCsv(String content) {
        MarkupTableData tableData = CsvTableParser.parseWithHeader(content, "path", "markdown");
        LinkedHashMap result = new LinkedHashMap();
        tableData.forEachRow(row -> result.put((String)row.get(0), (String)row.get(1)));
        return result;
    }

    private Map<String, ?> parseCalloutsJson(String content) {
        return JsonUtils.deserializeAsMap(content);
    }

    private Map<String, List<Map<String, Object>>> convertMarkdownToDocElements(MarkdownParser parser, Path parentFilePath, Map<String, ?> markdownByPath) {
        LinkedHashMap<String, List<Map<String, Object>>> result = new LinkedHashMap<String, List<Map<String, Object>>>();
        markdownByPath.forEach((nodePath, markdown) -> {
            MarkupParserResult parseResult = parser.parse(parentFilePath, markdown.toString());
            List<Map<String, Object>> docElements = parseResult.getDocElement().contentToListOfMaps();
            result.put((String)nodePath, docElements);
        });
        return result;
    }

    private static Set<String> buildPaths(Object json) {
        return new JsonPaths(json).getPaths();
    }
}

