/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.markup;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.testingisdocumenting.znai.codesnippets.CodeSnippetsProps;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;

public class MarkdownAndResultFencePlugin
implements FencePlugin {
    @Override
    public String id() {
        return "markdown-and-result";
    }

    @Override
    public FencePlugin create() {
        return new MarkdownAndResultFencePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String content) {
        MarkupParser parser = componentsRegistry.defaultParser();
        MarkupParserResult parserResult = parser.parse(markupPath, content);
        Map<String, Object> markdown = CodeSnippetsProps.create("markdown", content);
        markdown.put("type", "Snippet");
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("markdown", markdown);
        props.put("result", parserResult.contentToListOfMaps());
        return PluginResult.docElement("MarkdownAndResult", props);
    }
}

