/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.resources;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.core.Log;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.utils.FileUtils;

public class ZipJarFileResourceResolver
implements ResourcesResolver {
    private final Log log;
    private final Path docRootPath;
    private Path allUnarchivedRoot;
    private final List<Path> resolvedArchivesPaths = new ArrayList<Path>();

    public ZipJarFileResourceResolver(Log log, Path docRootPath) {
        this.log = log;
        this.docRootPath = docRootPath;
    }

    @Override
    public void initialize(Stream<String> filteredLookupPaths) {
        this.allUnarchivedRoot = this.createTempDirectory();
        this.resolvedArchivesPaths.clear();
        filteredLookupPaths.map(this::archiveAbsolutePath).forEach(this.resolvedArchivesPaths::add);
        if (!this.resolvedArchivesPaths.isEmpty()) {
            this.log.phase("un-archiving lookup files");
        }
        this.resolvedArchivesPaths.forEach(this::unArchive);
    }

    @Override
    public boolean supportsLookupPath(String lookupPath) {
        Path path = this.docRootPath.resolve(lookupPath);
        return Files.exists(path, new LinkOption[0]) && (lookupPath.endsWith(".zip") || lookupPath.endsWith(".jar"));
    }

    @Override
    public boolean canResolve(String path) {
        return Files.exists(this.allUnarchivedRoot.resolve(path), new LinkOption[0]);
    }

    @Override
    public List<String> listOfTriedLocations(String path) {
        return this.resolvedArchivesPaths.stream().map(archivePath -> archivePath + "/" + path).collect(Collectors.toList());
    }

    @Override
    public Path fullPath(String path) {
        return this.allUnarchivedRoot.resolve(path);
    }

    @Override
    public Path docRootRelativePath(Path path) {
        return null;
    }

    @Override
    public boolean isInsideDoc(Path path) {
        return false;
    }

    @Override
    public boolean isLocalFile(String path) {
        return false;
    }

    private void unArchive(Path archivePath) {
        try {
            this.log.info(new Object[]{Color.BLUE, "un-archiving ", Color.PURPLE, archivePath, Color.BLUE, " to ", Color.PURPLE, this.allUnarchivedRoot});
            this.unarchive(archivePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void unarchive(Path archivePath) throws IOException {
        try (FileSystem archiveFs = FileSystems.newFileSystem(archivePath, (ClassLoader)null);){
            Iterable<Path> rootDirectories = archiveFs.getRootDirectories();
            for (Path root : rootDirectories) {
                Stream<Path> files = Files.walk(root, new FileVisitOption[0]);
                try {
                    files.forEach(path -> {
                        try {
                            if (Files.isRegularFile(path, new LinkOption[0])) {
                                Path dest = this.allUnarchivedRoot.resolve(path.toString().substring(1));
                                Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                                Files.copy(path, dest, new CopyOption[0]);
                            }
                        }
                        catch (IOException e) {
                            this.log.warn("can't unarchive file " + path + " from " + archivePath);
                        }
                    });
                }
                finally {
                    if (files == null) continue;
                    files.close();
                }
            }
        }
    }

    private Path archiveAbsolutePath(String archiveLookupPath) {
        Path archiveRelativeOrAbsolutePath = Paths.get(archiveLookupPath, new String[0]);
        if (archiveRelativeOrAbsolutePath.isAbsolute()) {
            return archiveRelativeOrAbsolutePath;
        }
        return this.docRootPath.resolve(archiveLookupPath);
    }

    private Path createTempDirectory() {
        try {
            Path tempDirectory = Files.createTempDirectory("znai-archive-resource-resolver", new FileAttribute[0]);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> FileUtils.deleteFileOrDirQuietly(tempDirectory)));
            return tempDirectory;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

