/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.processors.build;

import java.util.Map;
import java.util.TreeMap;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.processing.Processor;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.util.Dictionary;
import znaishaded.com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import znaishaded.com.github.fge.jsonschema.keyword.validator.KeywordValidatorFactory;
import znaishaded.com.github.fge.jsonschema.library.Library;
import znaishaded.com.github.fge.jsonschema.processors.data.SchemaDigest;
import znaishaded.com.github.fge.jsonschema.processors.data.ValidatorList;
import znaishaded.com.google.common.collect.Maps;

public final class ValidatorBuilder
implements Processor<SchemaDigest, ValidatorList> {
    private final Map<String, KeywordValidatorFactory> factories;

    public ValidatorBuilder(Library library) {
        this.factories = library.getValidators().entries();
    }

    public ValidatorBuilder(Dictionary<KeywordValidatorFactory> dict) {
        this.factories = dict.entries();
    }

    @Override
    public ValidatorList process(ProcessingReport report, SchemaDigest input) throws ProcessingException {
        TreeMap<String, KeywordValidator> map = Maps.newTreeMap();
        for (Map.Entry<String, JsonNode> entry : input.getDigests().entrySet()) {
            String keyword = entry.getKey();
            JsonNode digest = entry.getValue();
            KeywordValidatorFactory factory = this.factories.get(keyword);
            KeywordValidator validator = factory.getKeywordValidator(digest);
            map.put(keyword, validator);
        }
        return new ValidatorList(input.getContext(), map.values());
    }

    public String toString() {
        return "validator builder";
    }
}

