/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.processors.digest;

import java.util.HashMap;
import java.util.Map;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.processing.Processor;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.util.Dictionary;
import znaishaded.com.github.fge.jsonschema.keyword.digest.Digester;
import znaishaded.com.github.fge.jsonschema.library.Library;
import znaishaded.com.github.fge.jsonschema.processors.data.SchemaContext;
import znaishaded.com.github.fge.jsonschema.processors.data.SchemaDigest;
import znaishaded.com.google.common.collect.ArrayListMultimap;
import znaishaded.com.google.common.collect.ImmutableMap;
import znaishaded.com.google.common.collect.ListMultimap;
import znaishaded.com.google.common.collect.Maps;
import znaishaded.com.google.common.collect.Sets;

public final class SchemaDigester
implements Processor<SchemaContext, SchemaDigest> {
    private final ListMultimap<NodeType, String> typeMap = ArrayListMultimap.create();
    private final Map<String, Digester> digesterMap = Maps.newHashMap();

    public SchemaDigester(Library library) {
        this(library.getDigesters());
    }

    public SchemaDigester(Dictionary<Digester> dict) {
        Map<String, Digester> map = dict.entries();
        for (Map.Entry<String, Digester> entry : map.entrySet()) {
            String keyword = entry.getKey();
            Digester digester = entry.getValue();
            this.digesterMap.put(keyword, digester);
            for (NodeType type : digester.supportedTypes()) {
                this.typeMap.put(type, keyword);
            }
        }
    }

    @Override
    public SchemaDigest process(ProcessingReport report, SchemaContext input) throws ProcessingException {
        JsonNode schema = input.getSchema().getNode();
        NodeType type = input.getInstanceType();
        HashMap<String, JsonNode> map = Maps.newHashMap(this.buildDigests(schema));
        map.keySet().retainAll(this.typeMap.get((Object)type));
        return new SchemaDigest(input, map);
    }

    private Map<String, JsonNode> buildDigests(JsonNode schema) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashMap<String, Digester> map = Maps.newHashMap(this.digesterMap);
        map.keySet().retainAll(Sets.newHashSet(schema.fieldNames()));
        for (Map.Entry entry : map.entrySet()) {
            builder.put(entry.getKey(), ((Digester)entry.getValue()).digest(schema));
        }
        return builder.build();
    }

    public String toString() {
        return "schema digester";
    }
}

