/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.parser.processors;

import java.util.List;
import java.util.Map;
import znaishaded.io.swagger.models.Swagger;
import znaishaded.io.swagger.models.properties.ArrayProperty;
import znaishaded.io.swagger.models.properties.ComposedProperty;
import znaishaded.io.swagger.models.properties.MapProperty;
import znaishaded.io.swagger.models.properties.ObjectProperty;
import znaishaded.io.swagger.models.properties.Property;
import znaishaded.io.swagger.models.properties.RefProperty;
import znaishaded.io.swagger.models.refs.RefType;
import znaishaded.io.swagger.parser.ResolverCache;
import znaishaded.io.swagger.parser.processors.ExternalRefProcessor;
import znaishaded.io.swagger.parser.util.RefUtils;

public class PropertyProcessor {
    private final ExternalRefProcessor externalRefProcessor;

    public PropertyProcessor(ResolverCache cache, Swagger swagger) {
        this.externalRefProcessor = new ExternalRefProcessor(cache, swagger);
    }

    public void processProperty(Property property) {
        if (property instanceof RefProperty) {
            this.processRefProperty((RefProperty)property);
        } else if (property instanceof ArrayProperty) {
            this.processArrayProperty((ArrayProperty)property);
        } else if (property instanceof MapProperty) {
            this.processMapProperty((MapProperty)property);
        } else if (property instanceof ObjectProperty) {
            this.processObjectProperty((ObjectProperty)property);
        } else if (property instanceof ComposedProperty) {
            this.processComposedProperty((ComposedProperty)property);
        }
    }

    private void processRefProperty(RefProperty refProperty) {
        String newRef;
        if (RefUtils.isAnExternalRefFormat(refProperty.getRefFormat()) && (newRef = this.externalRefProcessor.processRefToExternalDefinition(refProperty.get$ref(), refProperty.getRefFormat())) != null) {
            refProperty.set$ref(RefType.DEFINITION.getInternalPrefix() + newRef);
        }
    }

    private void processMapProperty(MapProperty property) {
        Property additionalProperties = property.getAdditionalProperties();
        if (additionalProperties != null) {
            this.processProperty(additionalProperties);
        }
    }

    private void processArrayProperty(ArrayProperty property) {
        Property items = property.getItems();
        if (items != null) {
            this.processProperty(items);
        }
    }

    private void processObjectProperty(ObjectProperty property) {
        Map<String, Property> properties = property.getProperties();
        if (properties != null) {
            for (Property p : properties.values()) {
                this.processProperty(p);
            }
        }
    }

    private void processComposedProperty(ComposedProperty property) {
        List<Property> properties = property.getAllOf();
        if (properties != null) {
            for (Property p : properties) {
                this.processProperty(p);
            }
        }
    }
}

