/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.dns;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.dns.AddressResolverOptions;
import znaishaded.io.vertx.core.json.JsonArray;
import znaishaded.io.vertx.core.json.JsonObject;

class AddressResolverOptionsConverter {
    AddressResolverOptionsConverter() {
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, AddressResolverOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "cacheMaxTimeToLive": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setCacheMaxTimeToLive(((Number)member.getValue()).intValue());
                    break;
                }
                case "cacheMinTimeToLive": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setCacheMinTimeToLive(((Number)member.getValue()).intValue());
                    break;
                }
                case "cacheNegativeTimeToLive": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setCacheNegativeTimeToLive(((Number)member.getValue()).intValue());
                    break;
                }
                case "hostsPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHostsPath((String)member.getValue());
                    break;
                }
                case "hostsValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHostsValue(Buffer.buffer(Base64.getDecoder().decode((String)member.getValue())));
                    break;
                }
                case "maxQueries": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxQueries(((Number)member.getValue()).intValue());
                    break;
                }
                case "ndots": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setNdots(((Number)member.getValue()).intValue());
                    break;
                }
                case "optResourceEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setOptResourceEnabled((Boolean)member.getValue());
                    break;
                }
                case "queryTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setQueryTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "rdFlag": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRdFlag((Boolean)member.getValue());
                    break;
                }
                case "rotateServers": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRotateServers((Boolean)member.getValue());
                    break;
                }
                case "searchDomains": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setSearchDomains(list);
                    break;
                }
                case "servers": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setServers(list);
                }
            }
        }
    }

    static void toJson(AddressResolverOptions obj, JsonObject json) {
        AddressResolverOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(AddressResolverOptions obj, Map<String, Object> json) {
        JsonArray array;
        json.put("cacheMaxTimeToLive", obj.getCacheMaxTimeToLive());
        json.put("cacheMinTimeToLive", obj.getCacheMinTimeToLive());
        json.put("cacheNegativeTimeToLive", obj.getCacheNegativeTimeToLive());
        if (obj.getHostsPath() != null) {
            json.put("hostsPath", obj.getHostsPath());
        }
        if (obj.getHostsValue() != null) {
            json.put("hostsValue", Base64.getEncoder().encodeToString(obj.getHostsValue().getBytes()));
        }
        json.put("maxQueries", obj.getMaxQueries());
        json.put("ndots", obj.getNdots());
        json.put("optResourceEnabled", obj.isOptResourceEnabled());
        json.put("queryTimeout", obj.getQueryTimeout());
        json.put("rdFlag", obj.getRdFlag());
        json.put("rotateServers", obj.isRotateServers());
        if (obj.getSearchDomains() != null) {
            array = new JsonArray();
            obj.getSearchDomains().forEach(item -> array.add((String)item));
            json.put("searchDomains", array);
        }
        if (obj.getServers() != null) {
            array = new JsonArray();
            obj.getServers().forEach(item -> array.add((String)item));
            json.put("servers", array);
        }
    }
}

