/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.net.impl.transport;

import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.concurrent.ThreadFactory;
import znaishaded.io.netty.bootstrap.Bootstrap;
import znaishaded.io.netty.bootstrap.ServerBootstrap;
import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.ChannelFactory;
import znaishaded.io.netty.channel.ChannelOption;
import znaishaded.io.netty.channel.EventLoopGroup;
import znaishaded.io.netty.channel.FixedRecvByteBufAllocator;
import znaishaded.io.netty.channel.ServerChannel;
import znaishaded.io.netty.channel.nio.NioEventLoopGroup;
import znaishaded.io.netty.channel.socket.DatagramChannel;
import znaishaded.io.netty.channel.socket.InternetProtocolFamily;
import znaishaded.io.netty.channel.socket.nio.NioDatagramChannel;
import znaishaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import znaishaded.io.netty.channel.socket.nio.NioSocketChannel;
import znaishaded.io.vertx.core.datagram.DatagramSocketOptions;
import znaishaded.io.vertx.core.net.ClientOptionsBase;
import znaishaded.io.vertx.core.net.NetServerOptions;
import znaishaded.io.vertx.core.net.SocketAddress;
import znaishaded.io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import znaishaded.io.vertx.core.net.impl.SocketAddressImpl;
import znaishaded.io.vertx.core.net.impl.transport.EpollTransport;
import znaishaded.io.vertx.core.net.impl.transport.KQueueTransport;

public class Transport {
    public static final int ACCEPTOR_EVENT_LOOP_GROUP = 0;
    public static final int IO_EVENT_LOOP_GROUP = 1;
    public static Transport JDK = new Transport();

    public static Transport nativeTransport() {
        Transport transport = null;
        try {
            EpollTransport epoll = new EpollTransport();
            if (((Transport)epoll).isAvailable()) {
                return epoll;
            }
            transport = epoll;
        }
        catch (Throwable epoll) {
            // empty catch block
        }
        try {
            KQueueTransport kqueue = new KQueueTransport();
            if (((Transport)kqueue).isAvailable()) {
                return kqueue;
            }
            if (transport == null) {
                transport = kqueue;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return transport;
    }

    public static Transport transport(boolean preferNative) {
        if (preferNative) {
            Transport nativeTransport = Transport.nativeTransport();
            if (nativeTransport != null && nativeTransport.isAvailable()) {
                return nativeTransport;
            }
            return JDK;
        }
        return JDK;
    }

    protected Transport() {
    }

    public boolean isAvailable() {
        return true;
    }

    public Throwable unavailabilityCause() {
        return null;
    }

    public java.net.SocketAddress convert(SocketAddress address, boolean resolved) {
        if (address.path() != null) {
            throw new IllegalArgumentException("Domain socket not supported by JDK transport");
        }
        if (resolved) {
            return new InetSocketAddress(address.host(), address.port());
        }
        return InetSocketAddress.createUnresolved(address.host(), address.port());
    }

    public SocketAddress convert(java.net.SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
            if (inetSocketAddress.isUnresolved()) {
                return new SocketAddressImpl(inetSocketAddress.getPort(), inetSocketAddress.getHostName());
            }
            return new SocketAddressImpl(inetSocketAddress.getPort(), inetSocketAddress.getAddress().getHostAddress());
        }
        return null;
    }

    ChannelOption<?> channelOption(String name) {
        return null;
    }

    public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ioRatio) {
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    public DatagramChannel datagramChannel() {
        return new NioDatagramChannel();
    }

    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        switch (family) {
            case IPv4: {
                return new NioDatagramChannel(InternetProtocolFamily.IPv4);
            }
            case IPv6: {
                return new NioDatagramChannel(InternetProtocolFamily.IPv6);
            }
        }
        throw new UnsupportedOperationException();
    }

    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        return NioSocketChannel::new;
    }

    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        return NioServerSocketChannel::new;
    }

    public void configure(DatagramChannel channel, DatagramSocketOptions options) {
        channel.config().setAllocator(PartialPooledByteBufAllocator.INSTANCE);
        if (options.getSendBufferSize() != -1) {
            channel.config().setSendBufferSize(options.getSendBufferSize());
        }
        if (options.getReceiveBufferSize() != -1) {
            channel.config().setReceiveBufferSize(options.getReceiveBufferSize());
            channel.config().setRecvByteBufAllocator(new FixedRecvByteBufAllocator(options.getReceiveBufferSize()));
        }
        channel.config().setOption(ChannelOption.SO_REUSEADDR, options.isReuseAddress());
        if (options.getTrafficClass() != -1) {
            channel.config().setTrafficClass(options.getTrafficClass());
        }
        channel.config().setBroadcast(options.isBroadcast());
        if (this == JDK) {
            channel.config().setLoopbackModeDisabled(options.isLoopbackModeDisabled());
            if (options.getMulticastTimeToLive() != -1) {
                channel.config().setTimeToLive(options.getMulticastTimeToLive());
            }
            if (options.getMulticastNetworkInterface() != null) {
                try {
                    channel.config().setNetworkInterface(NetworkInterface.getByName(options.getMulticastNetworkInterface()));
                }
                catch (SocketException e) {
                    throw new IllegalArgumentException("Could not find network interface with name " + options.getMulticastNetworkInterface());
                }
            }
        }
    }

    public void configure(ClientOptionsBase options, boolean domainSocket, Bootstrap bootstrap) {
        if (!domainSocket) {
            bootstrap.option(ChannelOption.SO_REUSEADDR, options.isReuseAddress());
            bootstrap.option(ChannelOption.TCP_NODELAY, options.isTcpNoDelay());
            bootstrap.option(ChannelOption.SO_KEEPALIVE, options.isTcpKeepAlive());
        }
        if (options.getLocalAddress() != null) {
            bootstrap.localAddress(options.getLocalAddress(), 0);
        }
        if (options.getSendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, options.getSendBufferSize());
        }
        if (options.getReceiveBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, options.getReceiveBufferSize());
            bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, new FixedRecvByteBufAllocator(options.getReceiveBufferSize()));
        }
        if (options.getSoLinger() != -1) {
            bootstrap.option(ChannelOption.SO_LINGER, options.getSoLinger());
        }
        if (options.getTrafficClass() != -1) {
            bootstrap.option(ChannelOption.IP_TOS, options.getTrafficClass());
        }
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, options.getConnectTimeout());
        bootstrap.option(ChannelOption.ALLOCATOR, PartialPooledByteBufAllocator.INSTANCE);
    }

    public void configure(NetServerOptions options, boolean domainSocket, ServerBootstrap bootstrap) {
        bootstrap.option(ChannelOption.SO_REUSEADDR, options.isReuseAddress());
        if (!domainSocket) {
            bootstrap.childOption(ChannelOption.SO_KEEPALIVE, options.isTcpKeepAlive());
            bootstrap.childOption(ChannelOption.TCP_NODELAY, options.isTcpNoDelay());
        }
        if (options.getSendBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, options.getSendBufferSize());
        }
        if (options.getReceiveBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, options.getReceiveBufferSize());
            bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, new FixedRecvByteBufAllocator(options.getReceiveBufferSize()));
        }
        if (options.getSoLinger() != -1) {
            bootstrap.childOption(ChannelOption.SO_LINGER, options.getSoLinger());
        }
        if (options.getTrafficClass() != -1) {
            bootstrap.childOption(ChannelOption.IP_TOS, options.getTrafficClass());
        }
        bootstrap.childOption(ChannelOption.ALLOCATOR, PartialPooledByteBufAllocator.INSTANCE);
        if (options.getAcceptBacklog() != -1) {
            bootstrap.option(ChannelOption.SO_BACKLOG, options.getAcceptBacklog());
        }
    }
}

