/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.asciiart;

import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.asciiart.AbstractComponentText;
import znaishaded.net.sourceforge.plantuml.asciiart.ComponentTextArrow;
import znaishaded.net.sourceforge.plantuml.asciiart.UmlCharArea;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.txt.UGraphicTxt;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.ArrowComponent;
import znaishaded.net.sourceforge.plantuml.skin.ArrowConfiguration;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;

public class ComponentTextSelfArrow
extends AbstractComponentText
implements ArrowComponent {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;
    private final ArrowConfiguration config;

    public ComponentTextSelfArrow(ComponentType type, ArrowConfiguration config, Display stringsToDisplay, FileFormat fileFormat) {
        this.type = type;
        this.stringsToDisplay = ComponentTextArrow.cleanAndManageBoldNumber(stringsToDisplay, fileFormat);
        this.fileFormat = fileFormat;
        this.config = config;
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        if (this.config.isHidden()) {
            return;
        }
        XDimension2D dimensionToUse = area.getDimensionToUse();
        UmlCharArea charArea = ((UGraphicTxt)ug).getCharArea();
        int width = (int)dimensionToUse.getWidth();
        int height = (int)dimensionToUse.getHeight() - 1;
        charArea.fillRect(' ', 0, 0, width, height);
        if (this.fileFormat == FileFormat.UTXT) {
            if (this.config.isDotted()) {
                charArea.drawStringLR("\u2500 \u2500 \u2510", 0, 0);
                charArea.drawStringLR("|", 4, 1);
                charArea.drawStringLR("< \u2500 \u2518", 0, 2);
            } else {
                charArea.drawStringLR("\u2500\u2500\u2500\u2500\u2510", 0, 0);
                charArea.drawStringLR("\u2502", 4, 1);
                charArea.drawStringLR("<\u2500\u2500\u2500\u2518", 0, 2);
            }
        } else if (this.config.isDotted()) {
            charArea.drawStringLR("- - .", 0, 0);
            charArea.drawStringLR("|", 4, 1);
            charArea.drawStringLR("< - '", 0, 2);
        } else {
            charArea.drawStringLR("----.", 0, 0);
            charArea.drawStringLR("|", 4, 1);
            charArea.drawStringLR("<---'", 0, 2);
        }
        if (this.fileFormat == FileFormat.UTXT) {
            charArea.drawStringsLRUnicode(this.stringsToDisplay.asList(), 6, 1);
        } else {
            charArea.drawStringsLRSimple(this.stringsToDisplay.asList(), 6, 1);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 3;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWcWidth(this.stringsToDisplay) + 6;
    }

    @Override
    public XPoint2D getStartPoint(StringBounder stringBounder, XDimension2D dimensionToUse) {
        return new XPoint2D(0.0, 0.0);
    }

    @Override
    public XPoint2D getEndPoint(StringBounder stringBounder, XDimension2D dimensionToUse) {
        return new XPoint2D(0.0, 0.0);
    }

    @Override
    public double getPaddingY() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getYPoint(StringBounder stringBounder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getPosArrow(StringBounder stringBounder) {
        throw new UnsupportedOperationException();
    }
}

