/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.core.DiagramType;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.text.StringLocated;
import znaishaded.net.sourceforge.plantuml.utils.LineLocation;
import znaishaded.net.sourceforge.plantuml.utils.StartUtils;
import znaishaded.net.sourceforge.plantuml.version.IteratorCounter2;
import znaishaded.net.sourceforge.plantuml.version.IteratorCounter2Impl;

public final class UmlSource {
    private final List<StringLocated> source;
    private final List<StringLocated> rawSource;

    public UmlSource removeInitialSkinparam() {
        if (!UmlSource.hasInitialSkinparam(this.source)) {
            return this;
        }
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.source);
        while (UmlSource.hasInitialSkinparam(copy)) {
            copy.remove(1);
        }
        return new UmlSource(copy, this.rawSource);
    }

    public boolean containsIgnoreCase(String searched) {
        for (StringLocated s2 : this.source) {
            if (!StringUtils.goLowerCase(s2.getString()).contains(searched)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasInitialSkinparam(List<StringLocated> copy) {
        return copy.size() > 1 && (copy.get(1).getString().startsWith("skinparam ") || copy.get(1).getString().startsWith("skinparamlocked "));
    }

    private UmlSource(List<StringLocated> source, List<StringLocated> rawSource) {
        this.source = source;
        this.rawSource = rawSource;
    }

    public static UmlSource create(List<StringLocated> source, boolean checkEndingBackslash) {
        return UmlSource.createWithRaw(source, checkEndingBackslash, UmlSource.emptyArrayList());
    }

    public static UmlSource createWithRaw(List<StringLocated> source, boolean checkEndingBackslash, List<StringLocated> rawSource) {
        UmlSource result = new UmlSource(UmlSource.emptyArrayList(), rawSource);
        result.loadInternal(source, checkEndingBackslash);
        return result;
    }

    private static ArrayList<StringLocated> emptyArrayList() {
        return new ArrayList<StringLocated>();
    }

    private void loadInternal(List<StringLocated> source, boolean checkEndingBackslash) {
        if (checkEndingBackslash) {
            StringBuilder pending = new StringBuilder();
            for (StringLocated cs : source) {
                String s2 = cs.getString();
                if (StringUtils.endsWithBackslash(s2)) {
                    pending.append(s2, 0, s2.length() - 1);
                    continue;
                }
                pending.append(s2);
                this.source.add(new StringLocated(pending.toString(), cs.getLocation()));
                pending.setLength(0);
            }
        } else {
            this.source.addAll(source);
        }
    }

    public DiagramType getDiagramType() {
        return DiagramType.getTypeFromArobaseStart(this.source.get(0).getString());
    }

    public IteratorCounter2 iterator2() {
        return new IteratorCounter2Impl(this.source);
    }

    @Deprecated
    public String getPlainString() {
        return this.getPlainString("\n");
    }

    public String getPlainString(String separator) {
        StringBuilder sb = new StringBuilder();
        for (StringLocated s2 : this.source) {
            sb.append(s2.getString());
            sb.append(separator);
        }
        return sb.toString();
    }

    public String getRawString(String separator) {
        StringBuilder sb = new StringBuilder();
        for (StringLocated s2 : this.rawSource) {
            sb.append(s2.getString());
            sb.append(separator);
        }
        return sb.toString();
    }

    public long seed() {
        return StringUtils.seed(this.getPlainString("\n"));
    }

    public String getLine(LineLocation n) {
        for (StringLocated s2 : this.source) {
            if (s2.getLocation().compareTo(n) != 0) continue;
            return s2.getString();
        }
        return null;
    }

    public int getTotalLineCount() {
        return this.source.size();
    }

    public boolean getTotalLineCountLessThan5() {
        return this.getTotalLineCount() < 5;
    }

    public boolean isEmpty() {
        for (StringLocated s2 : this.source) {
            if (StartUtils.isArobaseStartDiagram(s2.getString()) || StartUtils.isArobaseEndDiagram(s2.getString()) || s2.getString().matches("\\s*'.*") || StringUtils.trin(s2.getString()).length() == 0) continue;
            return false;
        }
        return true;
    }

    public Display getTitle() {
        Pattern2 p = MyPattern.cmpile("^[%s]*title[%s]+(.+)$");
        for (StringLocated s2 : this.source) {
            Matcher2 m3 = p.matcher(s2.getString());
            boolean ok = m3.matches();
            if (!ok) continue;
            return Display.create(m3.group(1));
        }
        return Display.empty();
    }

    public boolean isStartDef() {
        return this.source.get(0).getString().startsWith("@startdef");
    }

    public String getId() {
        Pattern p = Pattern.compile("id=([\\w]+)\\b");
        Matcher m3 = p.matcher(this.source.get(0).getString());
        if (m3.find()) {
            return m3.group(1);
        }
        return null;
    }
}

