/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.klimt.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UEllipse;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;
import znaishaded.net.sourceforge.plantuml.skin.VisibilityModifier;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.svek.Ports;
import znaishaded.net.sourceforge.plantuml.svek.WithPorts;

public class TextBlockMap
extends AbstractTextBlock
implements WithPorts {
    private final ISkinParam skinParam;
    private final FontConfiguration fontConfiguration;
    private final Map<TextBlock, TextBlock> blocksMap = new LinkedHashMap<TextBlock, TextBlock>();
    private final List<String> keys = new ArrayList<String>();
    private double totalWidth;

    public TextBlockMap(FontConfiguration fontConfiguration, ISkinParam skinParam, Map<String, String> map, LineBreakStrategy wordWrap) {
        this.skinParam = skinParam;
        this.fontConfiguration = fontConfiguration;
        for (Map.Entry<String, String> ent : map.entrySet()) {
            String key = ent.getKey();
            if (VisibilityModifier.isVisibilityCharacter(key)) {
                key = key.substring(1);
            }
            this.keys.add(key);
            String value = ent.getValue();
            TextBlock block1 = this.getTextBlock(key, wordWrap);
            TextBlock block2 = this.getTextBlock(value, wordWrap);
            this.blocksMap.put(block1, block2);
        }
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        Ports ports = new Ports();
        int i = 0;
        double y = 0.0;
        for (Map.Entry<TextBlock, TextBlock> ent : this.blocksMap.entrySet()) {
            TextBlock key = ent.getKey();
            TextBlock value = ent.getValue();
            double height = this.getHeightOfRow(stringBounder, key, value);
            ports.add(this.keys.get(i), 100, y, height);
            y += height;
            ++i;
        }
        return ports;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(this.getWidthColA(stringBounder) + this.getWidthColB(stringBounder), this.getTotalHeight(stringBounder));
    }

    private double getWidthColA(StringBounder stringBounder) {
        return this.getMaxWidth(stringBounder, this.blocksMap.keySet());
    }

    private double getWidthColB(StringBounder stringBounder) {
        return this.getMaxWidth(stringBounder, this.blocksMap.values());
    }

    private double getMaxWidth(StringBounder stringBounder, Collection<TextBlock> blocks) {
        double width = 0.0;
        for (TextBlock block : blocks) {
            width = Math.max(width, block.calculateDimension(stringBounder).getWidth());
        }
        return width;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D fullDim = this.calculateDimension(stringBounder);
        double trueWidth = Math.max(fullDim.getWidth(), this.totalWidth);
        double widthColA = this.getWidthColA(stringBounder);
        double widthColB = this.getWidthColB(stringBounder);
        double y = 0.0;
        for (Map.Entry<TextBlock, TextBlock> ent : this.blocksMap.entrySet()) {
            double posColA;
            TextBlock key = ent.getKey();
            TextBlock value = ent.getValue();
            UGraphic ugline = ug.apply(UTranslate.dy(y));
            ugline.draw(ULine.hline(trueWidth));
            double heightOfRow = this.getHeightOfRow(stringBounder, key, value);
            if (value instanceof Point) {
                posColA = (trueWidth - key.calculateDimension(stringBounder).getWidth()) / 2.0;
                key.drawU(ugline.apply(UTranslate.dx(posColA)));
            } else {
                posColA = (widthColA - key.calculateDimension(stringBounder).getWidth()) / 2.0;
                key.drawU(ugline.apply(UTranslate.dx(posColA)));
                value.drawU(ugline.apply(UTranslate.dx(widthColA)));
                ugline.apply(UTranslate.dx(widthColA)).draw(ULine.vline(heightOfRow));
            }
            y += heightOfRow;
        }
    }

    private double getTotalHeight(StringBounder stringBounder) {
        double height = 0.0;
        for (Map.Entry<TextBlock, TextBlock> ent : this.blocksMap.entrySet()) {
            TextBlock key = ent.getKey();
            TextBlock value = ent.getValue();
            height += this.getHeightOfRow(stringBounder, key, value);
        }
        return height;
    }

    private double getHeightOfRow(StringBounder stringBounder, TextBlock key, TextBlock value) {
        return Math.max(key.calculateDimension(stringBounder).getHeight(), value.calculateDimension(stringBounder).getHeight());
    }

    private TextBlock getTextBlock(String key, LineBreakStrategy wordWrap) {
        if (key.equals("\u0000")) {
            return new Point(this.fontConfiguration.getColor());
        }
        Display display = Display.getWithNewlines(key);
        TextBlock result = display.create0(this.fontConfiguration, HorizontalAlignment.LEFT, this.skinParam, wordWrap, CreoleMode.FULL, null, null);
        result = TextBlockUtils.withMargin(result, 5.0, 2.0);
        return result;
    }

    public void setTotalWidth(double totalWidth) {
        this.totalWidth = totalWidth;
    }

    static class Point
    extends AbstractTextBlock {
        private final HColor color;

        public Point(HColor color) {
            this.color = color;
        }

        @Override
        public XDimension2D calculateDimension(StringBounder stringBounder) {
            return new XDimension2D(this.getDiameter(), this.getDiameter());
        }

        @Override
        public void drawU(UGraphic ug) {
            UEllipse point = UEllipse.build(this.getDiameter(), this.getDiameter());
            ug = ug.apply(this.color).apply(this.color.bg());
            ug.draw(point);
        }

        private double getDiameter() {
            return 7.0;
        }
    }
}

