/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ebnf;

import java.util.ArrayDeque;
import java.util.Deque;
import znaishaded.net.sourceforge.plantuml.ebnf.ETile;
import znaishaded.net.sourceforge.plantuml.ebnf.ETileAlternation;
import znaishaded.net.sourceforge.plantuml.ebnf.ETileBox;
import znaishaded.net.sourceforge.plantuml.ebnf.ETileConcatenation;
import znaishaded.net.sourceforge.plantuml.ebnf.ETileOneOrMore;
import znaishaded.net.sourceforge.plantuml.ebnf.ETileOptional;
import znaishaded.net.sourceforge.plantuml.ebnf.ETileWithCircles;
import znaishaded.net.sourceforge.plantuml.ebnf.ETileZeroOrMore;
import znaishaded.net.sourceforge.plantuml.ebnf.Token;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColorSet;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.Style;

public class EbnfEngine {
    private final Deque<ETile> stack = new ArrayDeque<ETile>();
    private final FontConfiguration fontConfiguration;
    private final Style style;
    private final HColorSet colorSet;
    private final ISkinParam skinParam;
    private final HColor lineColor;

    public EbnfEngine(ISkinParam skinParam) {
        this.skinParam = skinParam;
        this.style = ETile.getStyleSignature().getMergedStyle(skinParam.getCurrentStyleBuilder());
        this.fontConfiguration = this.style.getFontConfiguration(skinParam.getIHtmlColorSet());
        this.colorSet = skinParam.getIHtmlColorSet();
        this.lineColor = this.style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
    }

    public void push(Token element) {
        this.stack.addFirst(new ETileBox(element.getData(), element.getSymbol(), this.fontConfiguration, this.style, this.colorSet, this.skinParam));
    }

    public void optional() {
        ETile arg1 = this.stack.removeFirst();
        this.stack.addFirst(new ETileOptional(arg1, this.skinParam));
    }

    public void repetitionZeroOrMore(boolean isCompact) {
        ETile arg1 = this.stack.removeFirst();
        if (isCompact) {
            this.stack.addFirst(new ETileZeroOrMore(arg1));
        } else {
            this.stack.addFirst(new ETileOptional(new ETileOneOrMore(arg1), this.skinParam));
        }
    }

    public void repetitionOneOrMore() {
        ETile arg1 = this.stack.removeFirst();
        this.stack.addFirst(new ETileOneOrMore(arg1));
    }

    public void repetitionSymbol() {
        ETile arg1 = this.stack.removeFirst();
        String arg2 = this.stack.removeFirst().getRepetitionLabel() + "\u00d7";
        this.stack.addFirst(new ETileOneOrMore(arg1, arg2, this.fontConfiguration.bigger(-2.0), this.skinParam));
    }

    public void alternation() {
        ETile arg1 = this.stack.removeFirst();
        ETile arg2 = this.stack.removeFirst();
        if (arg1 instanceof ETileAlternation) {
            arg1.push(arg2);
            this.stack.addFirst(arg1);
        } else if (arg2 instanceof ETileAlternation) {
            arg2.push(arg1);
            this.stack.addFirst(arg2);
        } else {
            ETileAlternation concat = new ETileAlternation();
            ((ETile)concat).push(arg1);
            ((ETile)concat).push(arg2);
            this.stack.addFirst(concat);
        }
    }

    public void concatenation() {
        ETile arg1 = this.stack.removeFirst();
        ETile arg2 = this.stack.removeFirst();
        if (arg1 instanceof ETileConcatenation) {
            arg1.push(arg2);
            this.stack.addFirst(arg1);
        } else if (arg2 instanceof ETileConcatenation) {
            arg2.push(arg1);
            this.stack.addFirst(arg2);
        } else {
            ETileConcatenation concat = new ETileConcatenation();
            ((ETile)concat).push(arg1);
            ((ETile)concat).push(arg2);
            this.stack.addFirst(concat);
        }
    }

    public TextBlock getTextBlock() {
        if (this.stack.size() != 1) {
            return EbnfEngine.syntaxError(this.fontConfiguration, this.skinParam);
        }
        return new ETileWithCircles(this.stack.peekFirst(), this.lineColor);
    }

    public static TextBlock syntaxError(FontConfiguration fontConfiguration, ISkinSimple spriteContainer) {
        Display msg = Display.create("Syntax error!");
        return msg.create(fontConfiguration, HorizontalAlignment.LEFT, spriteContainer);
    }

    public void commentBelow(String comment) {
        ETile arg1 = this.stack.peekFirst();
        if (arg1 == null) {
            throw new IllegalStateException();
        }
        arg1.addCommentBelow(comment);
    }

    public void commentAbove(String comment) {
        ETile arg1 = this.stack.peekFirst();
        if (arg1 == null) {
            throw new IllegalStateException();
        }
        arg1.addCommentAbove(comment);
    }
}

