/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.filesdiagram;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.filesdiagram.FilesListing;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.skin.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.text.StringLocated;
import znaishaded.net.sourceforge.plantuml.version.IteratorCounter2;

public class FilesDiagram
extends UmlDiagram {
    private final FilesListing list = new FilesListing(this.getSkinParam());

    public FilesDiagram(UmlSource source) {
        super(source, UmlDiagramType.FILES, null);
        IteratorCounter2 it = source.iterator2();
        it.next();
        while (it.hasNext()) {
            String line = ((StringLocated)it.next()).getString();
            if (line.startsWith("/")) {
                this.list.addRawEntry(line.substring(1));
                continue;
            }
            if (!line.startsWith("<note>")) continue;
            this.list.addNote(this.getNote(it));
        }
    }

    private List<String> getNote(Iterator<StringLocated> it) {
        ArrayList<String> result = new ArrayList<String>();
        while (it.hasNext()) {
            String line = it.next().getString();
            if (line.startsWith("</note>")) {
                return result;
            }
            result.add(line);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Files)");
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextBlock()).write(os);
    }

    @Override
    protected TextBlock getTextBlock() {
        return this.list;
    }
}

