/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.creole.command;

import znaishaded.net.sourceforge.plantuml.klimt.creole.command.Command;
import znaishaded.net.sourceforge.plantuml.klimt.creole.command.Splitter;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import znaishaded.net.sourceforge.plantuml.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.regex.Pattern2;

public class CommandCreoleEmoji
implements Command {
    private static final Pattern2 pattern = MyPattern.cmpile("^(" + Splitter.emojiPattern + ")");

    @Override
    public String startingChars() {
        return "<";
    }

    private CommandCreoleEmoji() {
    }

    public static Command create() {
        return new CommandCreoleEmoji();
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m3 = pattern.matcher(line);
        if (!m3.find()) {
            return 0;
        }
        return m3.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m3 = pattern.matcher(line);
        if (!m3.find()) {
            throw new IllegalStateException();
        }
        String color = m3.group(2);
        String emoji = m3.group(3);
        stripe.addEmoji(emoji, color);
        return line.substring(m3.group(1).length());
    }
}

