/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.drawing.svg;

import znaishaded.net.sourceforge.plantuml.klimt.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.LengthAdjust;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;

public class SvgOption {
    private final boolean interactive;
    private final LengthAdjust lengthAdjust;
    private final String preserveAspectRatio;
    private final String hover;
    private final boolean svgDimensionStyle;
    private final XDimension2D minDim;
    private final HColor backcolor;
    private final double scale;
    private final ColorMapper colorMapper;
    private final String linkTarget;
    private final String font;

    public static SvgOption basic() {
        return new SvgOption(false, LengthAdjust.defaultValue(), "none", null, true, new XDimension2D(0.0, 0.0), null, 1.0, ColorMapper.IDENTITY, null, null);
    }

    private SvgOption(boolean interactive, LengthAdjust lengthAdjust, String preserveAspectRatio, String hover, boolean svgDimensionStyle, XDimension2D minDim, HColor backcolor, double scale, ColorMapper colorMapper, String linkTarget, String font) {
        this.interactive = interactive;
        this.lengthAdjust = lengthAdjust;
        this.preserveAspectRatio = preserveAspectRatio;
        this.hover = hover;
        this.svgDimensionStyle = svgDimensionStyle;
        this.minDim = minDim;
        this.backcolor = backcolor;
        this.scale = scale;
        this.colorMapper = colorMapper;
        this.linkTarget = linkTarget;
        this.font = font;
    }

    public SvgOption withInteractive() {
        return new SvgOption(true, this.lengthAdjust, this.preserveAspectRatio, this.hover, this.svgDimensionStyle, this.minDim, this.backcolor, this.scale, this.colorMapper, this.linkTarget, this.font);
    }

    public SvgOption withLengthAdjust(LengthAdjust lengthAdjust) {
        return new SvgOption(this.interactive, lengthAdjust, this.preserveAspectRatio, this.hover, this.svgDimensionStyle, this.minDim, this.backcolor, this.scale, this.colorMapper, this.linkTarget, this.font);
    }

    public SvgOption withPreserveAspectRatio(String preserveAspectRatio) {
        return new SvgOption(this.interactive, this.lengthAdjust, preserveAspectRatio, this.hover, this.svgDimensionStyle, this.minDim, this.backcolor, this.scale, this.colorMapper, this.linkTarget, this.font);
    }

    public SvgOption withHoverPathColorRGB(String hover) {
        return new SvgOption(this.interactive, this.lengthAdjust, this.preserveAspectRatio, hover, this.svgDimensionStyle, this.minDim, this.backcolor, this.scale, this.colorMapper, this.linkTarget, this.font);
    }

    public SvgOption withSvgDimensionStyle(boolean svgDimensionStyle) {
        return new SvgOption(this.interactive, this.lengthAdjust, this.preserveAspectRatio, this.hover, svgDimensionStyle, this.minDim, this.backcolor, this.scale, this.colorMapper, this.linkTarget, this.font);
    }

    public SvgOption withMinDim(XDimension2D minDim) {
        return new SvgOption(this.interactive, this.lengthAdjust, this.preserveAspectRatio, this.hover, this.svgDimensionStyle, minDim, this.backcolor, this.scale, this.colorMapper, this.linkTarget, this.font);
    }

    public SvgOption withBackcolor(HColor backcolor) {
        return new SvgOption(this.interactive, this.lengthAdjust, this.preserveAspectRatio, this.hover, this.svgDimensionStyle, this.minDim, backcolor, this.scale, this.colorMapper, this.linkTarget, this.font);
    }

    public SvgOption withScale(double scale) {
        return new SvgOption(this.interactive, this.lengthAdjust, this.preserveAspectRatio, this.hover, this.svgDimensionStyle, this.minDim, this.backcolor, scale, this.colorMapper, this.linkTarget, this.font);
    }

    public SvgOption withColorMapper(ColorMapper colorMapper) {
        return new SvgOption(this.interactive, this.lengthAdjust, this.preserveAspectRatio, this.hover, this.svgDimensionStyle, this.minDim, this.backcolor, this.scale, colorMapper, this.linkTarget, this.font);
    }

    public SvgOption withLinkTarget(String linkTarget) {
        return new SvgOption(this.interactive, this.lengthAdjust, this.preserveAspectRatio, this.hover, this.svgDimensionStyle, this.minDim, this.backcolor, this.scale, this.colorMapper, linkTarget, this.font);
    }

    public SvgOption withFont(String font) {
        return new SvgOption(this.interactive, this.lengthAdjust, this.preserveAspectRatio, this.hover, this.svgDimensionStyle, this.minDim, this.backcolor, this.scale, this.colorMapper, this.linkTarget, font);
    }

    public String getPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public LengthAdjust getLengthAdjust() {
        return this.lengthAdjust;
    }

    public String getHover() {
        return this.hover;
    }

    public boolean getSvgDimensionStyle() {
        return this.svgDimensionStyle;
    }

    public XDimension2D getMinDim() {
        return this.minDim;
    }

    public HColor getBackcolor() {
        return this.backcolor;
    }

    public double getScale() {
        return this.scale;
    }

    public ColorMapper getColorMapper() {
        return this.colorMapper;
    }

    public final String getLinkTarget() {
        return this.linkTarget;
    }

    public final String getFont() {
        return this.font;
    }
}

