/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.geom;

import java.util.Map;
import java.util.Set;
import znaishaded.net.atmp.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.PlacementStrategy;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;

public class ULayoutGroup {
    private final PlacementStrategy placementStrategy;

    public ULayoutGroup(PlacementStrategy placementStrategy) {
        this.placementStrategy = placementStrategy;
    }

    public void drawU(UGraphic ug, double width, double height) {
        for (Map.Entry<TextBlock, XPoint2D> ent : this.placementStrategy.getPositions(width, height).entrySet()) {
            TextBlock block = ent.getKey();
            XPoint2D pos = ent.getValue();
            block.drawU(ug.apply(UTranslate.point(pos)));
        }
    }

    public void add(TextBlock block) {
        this.placementStrategy.add(block);
    }

    public XRectangle2D getInnerPosition(String member, double width, double height, StringBounder stringBounder) {
        Set<Map.Entry<TextBlock, XPoint2D>> all = this.placementStrategy.getPositions(width, height).entrySet();
        XRectangle2D result = this.tryOne(all, member, stringBounder, InnerStrategy.STRICT);
        if (result == null) {
            result = this.tryOne(all, member, stringBounder, InnerStrategy.LAZZY);
        }
        return result;
    }

    private XRectangle2D tryOne(Set<Map.Entry<TextBlock, XPoint2D>> all, String member, StringBounder stringBounder, InnerStrategy mode) {
        for (Map.Entry<TextBlock, XPoint2D> ent : all) {
            TextBlock block = ent.getKey();
            XRectangle2D result = block.getInnerPosition(member, stringBounder, mode);
            if (result == null) continue;
            UTranslate translate = UTranslate.point(ent.getValue());
            return translate.apply(result);
        }
        return null;
    }
}

