/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.draw;

import java.util.Locale;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.project.TimeHeaderParameters;
import znaishaded.net.sourceforge.plantuml.project.draw.TimeHeader;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.project.timescale.TimeScale;

public abstract class TimeHeaderCalendar
extends TimeHeader {
    private final TimeHeaderParameters thParam;

    public TimeHeaderCalendar(TimeHeaderParameters thParam, TimeScale timeScale) {
        super(thParam.getTimelineStyle(), thParam.getClosedStyle(), thParam.getMin(), thParam.getMax(), timeScale, thParam.getColorSet());
        this.thParam = thParam;
    }

    protected final boolean isBold(Day wink) {
        return this.thParam.getVerticalSeparatorBefore().contains(wink);
    }

    protected final Locale locale() {
        return this.thParam.getLocale();
    }

    protected final int getLoadAt(Day instant) {
        return this.thParam.getLoadPlanable().getLoadAt(instant);
    }

    protected final void drawTextsBackground(UGraphic ug, double totalHeightWithoutFooter) {
        double height = totalHeightWithoutFooter - this.getFullHeaderHeight();
        Pending pending = null;
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            double x2 = this.getTimeScale().getEndingPosition(wink);
            HColor back = this.thParam.getColor(wink);
            HColor backDoW = this.thParam.getColor(wink.getDayOfWeek());
            if (backDoW != null) {
                back = backDoW;
            }
            if (back == null && this.getLoadAt(wink) == 0) {
                back = this.closedBackgroundColor();
            }
            if (back == null) {
                if (pending != null) {
                    pending.draw(ug, height);
                }
                pending = null;
            } else {
                if (pending != null && !pending.color.equals(back)) {
                    pending.draw(ug, height);
                    pending = null;
                }
                if (pending == null) {
                    pending = new Pending(back, x1, x2);
                } else {
                    pending.x2 = x2;
                }
            }
            wink = wink.increment();
        }
        if (pending != null) {
            pending.draw(ug, height);
        }
    }

    class Pending {
        final double x1;
        double x2;
        final HColor color;

        Pending(HColor color, double x1, double x2) {
            this.x1 = x1;
            this.x2 = x2;
            this.color = color;
        }

        public void draw(UGraphic ug, double height) {
            TimeHeaderCalendar.this.drawRectangle(ug.apply(this.color.bg()), height, this.x1, this.x2);
        }
    }
}

