/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.time;

import java.util.Locale;
import znaishaded.net.sourceforge.plantuml.project.time.Month;

public class MonthYear
implements Comparable<MonthYear> {
    private final int year;
    private final Month month;

    public static MonthYear create(int year, Month month) {
        return new MonthYear(year, month);
    }

    public String shortName(Locale locale) {
        return this.month.shortName(locale);
    }

    public String shortNameYYYY(Locale locale) {
        return this.month.shortName(locale) + " " + this.year;
    }

    public String longName(Locale locale) {
        return this.month.longName(locale);
    }

    public String longNameYYYY(Locale locale) {
        return this.month.longName(locale) + " " + this.year;
    }

    private MonthYear(int year, Month month) {
        this.year = year;
        this.month = month;
    }

    public int year() {
        return this.year;
    }

    public MonthYear next() {
        Month newMonth = this.month.next();
        int newYear = newMonth == Month.JANUARY ? this.year + 1 : this.year;
        return new MonthYear(newYear, newMonth);
    }

    public Month month() {
        return this.month;
    }

    private int internalNumber() {
        return this.year * 100 + this.month.ordinal();
    }

    public String toString() {
        return "" + this.year + "/" + (Object)((Object)this.month);
    }

    public int hashCode() {
        return this.year * 113 + this.month.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        MonthYear other = (MonthYear)obj;
        return other.internalNumber() == this.internalNumber();
    }

    @Override
    public int compareTo(MonthYear other) {
        return this.internalNumber() - other.internalNumber();
    }
}

