/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFont;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.salt.Cell;
import znaishaded.net.sourceforge.plantuml.salt.Positionner2;
import znaishaded.net.sourceforge.plantuml.salt.element.AbstractElement;
import znaishaded.net.sourceforge.plantuml.salt.element.Element;
import znaishaded.net.sourceforge.plantuml.salt.element.Grid;
import znaishaded.net.sourceforge.plantuml.salt.element.LeftFirst;
import znaishaded.net.sourceforge.plantuml.salt.element.TableStrategy;
import znaishaded.net.sourceforge.plantuml.salt.element.TopFirst;
import znaishaded.net.sourceforge.plantuml.style.ISkinSimple;

public class ElementPyramid
extends AbstractElement {
    private int rows;
    private int cols;
    private final TextBlock title;
    private final TableStrategy tableStrategy;
    private final Map<Element, Cell> positions1;
    private final Map<Cell, Element> positions2 = new HashMap<Cell, Element>();
    private double[] rowsStart;
    private double[] colsStart;

    public ElementPyramid(Positionner2 positionner, TableStrategy tableStrategy, String title, ISkinSimple spriteContainer) {
        this.positions1 = positionner.getAll();
        for (Map.Entry<Element, Cell> ent : this.positions1.entrySet()) {
            this.positions2.put(ent.getValue(), ent.getKey());
        }
        if (title != null) {
            FontConfiguration fontConfiguration = FontConfiguration.blackBlueTrue(UFont.byDefault(10));
            this.title = Display.getWithNewlines(title).create(fontConfiguration, HorizontalAlignment.LEFT, spriteContainer);
        } else {
            this.title = TextBlockUtils.empty(0.0, 0.0);
        }
        this.rows = positionner.getNbRows();
        this.cols = positionner.getNbCols();
        this.tableStrategy = tableStrategy;
        for (Cell c : this.positions1.values()) {
            this.rows = Math.max(this.rows, c.getMaxRow());
            this.cols = Math.max(this.cols, c.getMaxCol());
        }
    }

    @Override
    public XDimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        this.init(stringBounder);
        return new XDimension2D(this.colsStart[this.colsStart.length - 1], this.rowsStart[this.rowsStart.length - 1] + this.title.calculateDimension(stringBounder).getHeight());
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, XDimension2D dimToUse) {
        ug = ug.apply(this.getBlack());
        this.init(ug.getStringBounder());
        double titleHeight = this.title.calculateDimension(ug.getStringBounder()).getHeight();
        Grid grid = new Grid(this.rowsStart, this.colsStart, this.tableStrategy, this.title);
        for (Map.Entry<Element, Cell> ent : this.positions1.entrySet()) {
            Element elt = ent.getKey();
            Cell cell = ent.getValue();
            double xcell = this.colsStart[cell.getMinCol()];
            double supY = cell.getMinRow() == 0 ? titleHeight / 2.0 : 0.0;
            double ycell = this.rowsStart[cell.getMinRow()] + supY;
            double width = this.colsStart[cell.getMaxCol() + 1] - this.colsStart[cell.getMinCol()] - 1.0;
            double height = this.rowsStart[cell.getMaxRow() + 1] - this.rowsStart[cell.getMinRow()] - 1.0;
            grid.addCell(cell);
            elt.drawU(ug.apply(new UTranslate(xcell + 1.0, ycell + 1.0)), zIndex, new XDimension2D(width, height));
        }
        if (zIndex == 0) {
            grid.drawU(ug, 0.0, 0.0, this.getWhite());
        }
    }

    private void init(StringBounder stringBounder) {
        Element elt;
        if (this.rowsStart != null) {
            return;
        }
        double titleHeight = this.title.calculateDimension(stringBounder).getHeight();
        this.rowsStart = new double[this.rows + 1];
        this.rowsStart[0] = titleHeight / 2.0;
        for (int i = 1; i < this.rows + 1; ++i) {
            this.rowsStart[i] = titleHeight / 2.0;
        }
        this.colsStart = new double[this.cols + 1];
        ArrayList<Cell> all = new ArrayList<Cell>(this.positions1.values());
        Collections.sort(all, new LeftFirst());
        for (Cell cell : all) {
            elt = this.positions2.get(cell);
            XDimension2D dim = elt.getPreferredDimension(stringBounder, 0.0, 0.0);
            this.ensureColWidth(cell.getMinCol(), cell.getMaxCol() + 1, dim.getWidth() + 2.0);
        }
        Collections.sort(all, new TopFirst());
        for (Cell cell : all) {
            elt = this.positions2.get(cell);
            double supY = cell.getMinRow() == 0 ? titleHeight / 2.0 : 0.0;
            XDimension2D dim = elt.getPreferredDimension(stringBounder, 0.0, 0.0);
            this.ensureRowHeight(cell.getMinRow(), cell.getMaxRow() + 1, dim.getHeight() + supY + 2.0);
        }
    }

    private void ensureColWidth(int first, int last, double width) {
        double actual = this.colsStart[last] - this.colsStart[first];
        double missing = width - actual;
        if (missing > 0.0) {
            int i = last;
            while (i < this.colsStart.length) {
                int n = i++;
                this.colsStart[n] = this.colsStart[n] + missing;
            }
        }
    }

    private void ensureRowHeight(int first, int last, double height) {
        double actual = this.rowsStart[last] - this.rowsStart[first];
        double missing = height - actual;
        if (missing > 0.0) {
            int i = last;
            while (i < this.rowsStart.length) {
                int n = i++;
                this.rowsStart[n] = this.rowsStart[n] + missing;
            }
        }
    }

    public final int getNbRows() {
        return this.rows + 1;
    }

    public final int getNbCols() {
        return this.cols + 1;
    }
}

