/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.AffineTransform;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.geom.Side;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;
import znaishaded.net.sourceforge.plantuml.svek.extremity.Extremity;

class ExtremityCrowfoot
extends Extremity {
    private final XPoint2D contact;
    private double angle;
    private final Side side;

    @Override
    public XPoint2D somePoint() {
        return this.contact;
    }

    public ExtremityCrowfoot(XPoint2D p1, double angle, Side side) {
        this.contact = new XPoint2D(p1.getX(), p1.getY());
        this.angle = this.manageround(angle + 1.5707963267948966);
        this.side = side;
    }

    @Override
    public double getDecorationLength() {
        return 8.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        int xWing = 8;
        int yAperture = 8;
        AffineTransform rotate = AffineTransform.getRotateInstance(this.angle);
        XPoint2D middle = new XPoint2D(0.0, 0.0);
        XPoint2D left = new XPoint2D(0.0, -8.0);
        XPoint2D base = new XPoint2D(-8.0, 0.0);
        XPoint2D right = new XPoint2D(0.0, 8.0);
        left = left.transform(rotate);
        base = base.transform(rotate);
        right = right.transform(rotate);
        if (this.side == Side.WEST || this.side == Side.EAST) {
            left = new XPoint2D(middle.getX(), left.getY());
            right = new XPoint2D(middle.getX(), right.getY());
        }
        if (this.side == Side.SOUTH || this.side == Side.NORTH) {
            left = new XPoint2D(left.getX(), middle.getY());
            right = new XPoint2D(right.getX(), middle.getY());
        }
        ExtremityCrowfoot.drawLine(ug, this.contact.getX(), this.contact.getY(), base, left);
        ExtremityCrowfoot.drawLine(ug, this.contact.getX(), this.contact.getY(), base, right);
        ExtremityCrowfoot.drawLine(ug, this.contact.getX(), this.contact.getY(), base, middle);
    }

    private static void drawLine(UGraphic ug, double x, double y, XPoint2D p1, XPoint2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        ug.apply(new UTranslate(x + p1.getX(), y + p1.getY())).draw(new ULine(dx, dy));
    }
}

