/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tim.stdlib;

import java.util.List;
import java.util.Map;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.json.JsonValue;
import znaishaded.net.sourceforge.plantuml.tim.EaterException;
import znaishaded.net.sourceforge.plantuml.tim.EaterExceptionLocated;
import znaishaded.net.sourceforge.plantuml.tim.TContext;
import znaishaded.net.sourceforge.plantuml.tim.TFunctionSignature;
import znaishaded.net.sourceforge.plantuml.tim.TMemory;
import znaishaded.net.sourceforge.plantuml.tim.expression.TValue;
import znaishaded.net.sourceforge.plantuml.tim.stdlib.SimpleReturnFunction;
import znaishaded.net.sourceforge.plantuml.utils.LineLocation;

public class GetJsonType
extends SimpleReturnFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%get_json_type", 1);
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 1;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, LineLocation location, List<TValue> values, Map<String, TValue> named) throws EaterException, EaterExceptionLocated {
        TValue data = values.get(0);
        if (data.isString()) {
            return TValue.fromString("string");
        }
        if (data.isNumber()) {
            return TValue.fromString("number");
        }
        if (!data.isJson()) {
            return TValue.fromString("not_json");
        }
        JsonValue json = data.toJson();
        if (json.isArray()) {
            return TValue.fromString("array");
        }
        if (json.isObject()) {
            return TValue.fromString("object");
        }
        if (json.isBoolean()) {
            return TValue.fromString("boolean");
        }
        if (json.isNumber()) {
            return TValue.fromString("number");
        }
        if (json.isString()) {
            return TValue.fromString("string");
        }
        return TValue.fromString("json");
    }
}

