/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.version;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.text.StringLocated;
import znaishaded.net.sourceforge.plantuml.version.IteratorCounter2;

public class IteratorCounter2Impl
implements IteratorCounter2 {
    private List<StringLocated> data;
    private List<StringLocated> trace;
    private int nb;

    @Override
    public void copyStateFrom(IteratorCounter2 other) {
        IteratorCounter2Impl source = (IteratorCounter2Impl)other;
        this.nb = source.nb;
        this.data = source.data;
        this.trace = source.trace;
    }

    public IteratorCounter2Impl(List<StringLocated> data) {
        this(data, 0, new ArrayList<StringLocated>());
    }

    private IteratorCounter2Impl(List<StringLocated> data, int nb, List<StringLocated> trace) {
        this.data = data;
        this.nb = nb;
        this.trace = trace;
    }

    @Override
    public IteratorCounter2 cloneMe() {
        return new IteratorCounter2Impl(this.data, this.nb, new ArrayList<StringLocated>(this.trace));
    }

    @Override
    public int currentNum() {
        return this.nb;
    }

    @Override
    public boolean hasNext() {
        return this.nb < this.data.size();
    }

    @Override
    public StringLocated next() {
        StringLocated result = this.data.get(this.nb);
        ++this.nb;
        this.trace.add(result);
        return result;
    }

    @Override
    public StringLocated peek() {
        return this.data.get(this.nb);
    }

    @Override
    public StringLocated peekPrevious() {
        if (this.nb == 0) {
            return null;
        }
        return this.data.get(this.nb - 1);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final List<StringLocated> getTrace() {
        return Collections.unmodifiableList(this.trace);
    }
}

