/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.api;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.extensions.api.ApiParameter;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.utils.JsonUtils;

public class ApiParametersJsonParser {
    private final String NAME_KEY = "name";
    private final String DESCRIPTION_KEY = "description";
    private final ApiParameters apiParameters;
    private final MarkupParser markupParser;
    private final List<Map<String, Object>> json;
    private final Path path;

    public static ApiParameters parse(String anchorPrefix, MarkupParser markupParser, String jsonContent) {
        return new ApiParametersJsonParser(anchorPrefix, markupParser, jsonContent).parse();
    }

    private ApiParametersJsonParser(String anchorPrefix, MarkupParser markupParser, String jsonContent) {
        this.markupParser = markupParser;
        this.json = JsonUtils.deserializeAsList(jsonContent);
        this.apiParameters = new ApiParameters(anchorPrefix);
        this.path = Paths.get("", new String[0]);
    }

    public ApiParameters parse() {
        this.json.forEach(p -> this.parseParam(this.apiParameters.getRoot(), (Map<String, Object>)p));
        return this.apiParameters;
    }

    private void parseParam(ApiParameter current, Map<String, Object> param) {
        this.validateParam(param);
        MarkupParserResult parserResult = this.markupParser.parse(this.path, param.get("description").toString());
        ApiParameter apiParameter = current.add(param.get("name").toString(), new ApiLinkedText(param.getOrDefault("type", "").toString()), parserResult.contentToListOfMaps(), parserResult.getAllText());
        Object children = param.get("children");
        if (children != null) {
            List list = (List)children;
            list.forEach(p -> this.parseParam(apiParameter, (Map<String, Object>)p));
        }
    }

    private void validateParam(Map<String, Object> param) {
        boolean missingDescription;
        boolean missingName = !param.containsKey("name");
        boolean bl = missingDescription = !param.containsKey("description");
        if (missingName || missingDescription) {
            Stream<CharSequence> missingKeys = Stream.concat(missingName ? Stream.of("name") : Stream.empty(), missingDescription ? Stream.of("description") : Stream.empty());
            throw new IllegalArgumentException("missing required fields: " + missingKeys.collect(Collectors.joining(", ")) + "\nrecord: " + JsonUtils.serialize(param));
        }
    }
}

