/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.codesnippets.CodeSnippetsProps;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.features.PluginFeature;
import org.testingisdocumenting.znai.extensions.features.PluginFeatureList;
import org.testingisdocumenting.znai.extensions.file.ManipulatedSnippetContentProvider;
import org.testingisdocumenting.znai.extensions.file.SnippetsCommon;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class FileIncludePlugin
implements IncludePlugin {
    private String fileName;
    private PluginFeatureList features;
    private ManipulatedSnippetContentProvider contentProvider;

    @Override
    public PluginParamsDefinition parameters() {
        PluginParamsDefinition result = new PluginParamsDefinition();
        result.add("lang", PluginParamType.STRING, "force language to use for syntax highlight (by default is taken from file extension)", "yaml");
        result.add(SnippetsCommon.createParamsDefinition());
        return result;
    }

    @Override
    public String id() {
        return "file";
    }

    @Override
    public IncludePlugin create() {
        return new FileIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.fileName = pluginParams.getFreeParam();
        this.contentProvider = new ManipulatedSnippetContentProvider(this.fileName, componentsRegistry.resourceResolver().textContent(this.fileName), pluginParams);
        this.features = new PluginFeatureList(new PluginFeature[0]);
        this.features.add(SnippetsCommon.createCommonFeatures(componentsRegistry, markupPath, pluginParams, this.contentProvider).asList());
        String providedLang = pluginParams.getOpts().getString("lang");
        String langToUse = providedLang == null ? FileIncludePlugin.langFromFileName(this.fileName) : providedLang;
        Map<String, Object> props = CodeSnippetsProps.create(langToUse, this.contentProvider.snippetContent());
        props.putAll(pluginParams.getOpts().toMap());
        this.features.updateProps(props);
        return PluginResult.docElement("Snippet", props);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return this.features.combineAuxiliaryFilesWith(Stream.of(AuxiliaryFile.builtTime(componentsRegistry.resourceResolver().fullPath(this.fileName))));
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.contentProvider.snippetContent());
    }

    private static String langFromFileName(String fileName) {
        return FileIncludePlugin.extFromFileName(fileName);
    }

    private static String extFromFileName(String fileName) {
        int dotLastIdx = fileName.lastIndexOf(46);
        if (dotLastIdx == -1) {
            return "";
        }
        return fileName.substring(dotLastIdx + 1);
    }
}

