/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.inlinedcode;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.inlinedcode.InlinedCodePlugin;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class IdentifierInlinedCodePlugin
implements InlinedCodePlugin {
    private String identifier;
    private List<String> validationPaths;

    @Override
    public String id() {
        return "identifier";
    }

    @Override
    public InlinedCodePlugin create() {
        return new IdentifierInlinedCodePlugin();
    }

    @Override
    public PluginParamsDefinition parameters() {
        return new PluginParamsDefinition().addRequired("validationPath", PluginParamType.LIST_OR_SINGLE_STRING, "single file, or a list of files to use for the identifier validation", "[\"file1.py\", \"file2.py\"]");
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams) {
        this.identifier = pluginParams.getFreeParam();
        this.validationPaths = pluginParams.getOpts().getList("validationPath");
        this.validate(componentsRegistry.resourceResolver());
        return PluginResult.docElement("InlinedCode", Collections.singletonMap("code", this.identifier));
    }

    private void validate(ResourcesResolver resourcesResolver) {
        if (this.validationPaths.isEmpty()) {
            throw new IllegalArgumentException("validationPath is missing");
        }
        Pattern identifierRegexp = Pattern.compile("\\b" + this.identifier + "\\b", 8);
        boolean hasIdentifier = this.validationPaths.stream().anyMatch(path -> this.hasIdentifierInFile(resourcesResolver, (String)path, identifierRegexp));
        if (!hasIdentifier) {
            throw new RuntimeException("can't find <" + this.identifier + "> identifier in: " + String.join((CharSequence)", ", this.validationPaths));
        }
    }

    private boolean hasIdentifierInFile(ResourcesResolver resourceResolver, String path, Pattern identifierRegexp) {
        String validationContent = resourceResolver.textContent(path);
        Matcher matcher = identifierRegexp.matcher(validationContent);
        return matcher.find();
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return this.validationPaths.stream().map(path -> AuxiliaryFile.builtTime(componentsRegistry.resourceResolver().fullPath((String)path)));
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.identifier);
    }
}

