/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.table;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.parser.table.CsvTableParser;
import org.testingisdocumenting.znai.parser.table.JsonTableParser;
import org.testingisdocumenting.znai.parser.table.MapBasedMarkupTableMapping;
import org.testingisdocumenting.znai.parser.table.MarkupTableData;
import org.testingisdocumenting.znai.parser.table.MarkupTableDataMapping;

class MarkupTableDataFromContentAndParams {
    private final ComponentsRegistry componentsRegistry;
    private final String contentToParse;
    private final String mappingFileName;
    private final Path mappingPath;
    private final MarkupTableData markupTableData;

    MarkupTableDataFromContentAndParams(ComponentsRegistry componentsRegistry, PluginParams pluginParams, String contentToParse) {
        this.componentsRegistry = componentsRegistry;
        this.contentToParse = contentToParse;
        this.mappingFileName = pluginParams.getOpts().get("mappingPath", "");
        this.mappingPath = this.mappingFileName.isEmpty() ? null : componentsRegistry.resourceResolver().fullPath(this.mappingFileName);
        this.markupTableData = this.parse();
    }

    public MarkupTableData getMarkupTableData() {
        return this.markupTableData;
    }

    public Stream<String> columnNamesStream() {
        return this.markupTableData.columnNamesStream();
    }

    Stream<AuxiliaryFile> mappingAuxiliaryFile() {
        return this.mappingPath == null ? Stream.empty() : Stream.of(AuxiliaryFile.builtTime(this.mappingPath));
    }

    private MarkupTableData parse() {
        return (this.isJson() ? JsonTableParser.parse(this.contentToParse) : CsvTableParser.parse(this.contentToParse)).mapValues(this.createMapping());
    }

    private boolean isJson() {
        return this.contentToParse.trim().startsWith("[");
    }

    private MarkupTableDataMapping createMapping() {
        return new MapBasedMarkupTableMapping(this.mappingPath == null ? Collections.emptyMap() : this.createMappingFromFileContent());
    }

    private Map<Object, Object> createMappingFromFileContent() {
        MarkupTableData tableData = CsvTableParser.parseWithHeader(this.componentsRegistry.resourceResolver().textContent(this.mappingFileName), "from", "to");
        return Collections.unmodifiableMap(tableData.toKeyValue());
    }
}

