/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.reference;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.reference.DocReferences;
import org.testingisdocumenting.znai.reference.DocReferencesParser;
import org.testingisdocumenting.znai.structure.DocStructure;
import org.testingisdocumenting.znai.structure.DocUrl;
import org.testingisdocumenting.znai.utils.FileUtils;

public class GlobalDocReferences {
    private final ComponentsRegistry componentsRegistry;
    private final Path globalReferencesPathNoExt;
    private final Path globalReferencesPathCsv;
    private final Path globalReferencesPathJson;
    private DocReferences docReferences;

    public GlobalDocReferences(ComponentsRegistry componentsRegistry, Path globalReferencesPathNoExt) {
        this.componentsRegistry = componentsRegistry;
        this.globalReferencesPathNoExt = globalReferencesPathNoExt;
        this.globalReferencesPathCsv = globalReferencesPathNoExt.resolveSibling(globalReferencesPathNoExt.getFileName() + ".csv");
        this.globalReferencesPathJson = globalReferencesPathNoExt.resolveSibling(globalReferencesPathNoExt.getFileName() + ".json");
    }

    public boolean isPresent() {
        return this.isCsvPresent() || this.isJsonPresent();
    }

    public boolean isCsvPresent() {
        return Files.exists(this.globalReferencesPathCsv, new LinkOption[0]);
    }

    public boolean isJsonPresent() {
        return Files.exists(this.globalReferencesPathJson, new LinkOption[0]);
    }

    public void load() {
        String content = this.readReferenceContent();
        this.docReferences = content.isEmpty() ? new DocReferences() : DocReferencesParser.parse(content);
        this.validateLinks();
    }

    private void validateLinks() {
        DocStructure docStructure = this.componentsRegistry.docStructure();
        this.docReferences.pageUrlsStream().forEach(pageUrl -> docStructure.validateUrl(this.globalReferencesPathNoExt, "", new DocUrl(this.globalReferencesPathNoExt, (String)pageUrl)));
    }

    public Path getGlobalReferencesPathNoExt() {
        return this.globalReferencesPathNoExt;
    }

    public DocReferences getDocReferences() {
        return this.docReferences;
    }

    private String readReferenceContent() {
        if (this.isCsvPresent()) {
            return FileUtils.fileTextContent(this.globalReferencesPathCsv);
        }
        if (this.isJsonPresent()) {
            return FileUtils.fileTextContent(this.globalReferencesPathJson);
        }
        return "";
    }
}

