/*
 * Decompiled with CFR 0.152.
 */
package smetana.core;

import smetana.core.UnsupportedC;
import smetana.core.ZType;
import znaishaded.com.plantuml.api.cheerpj.WasmLog;

public final class CArray<O>
extends UnsupportedC {
    private final ZType type;
    private final Object[] data;
    private final int offset;

    public String toString() {
        return "Array " + (Object)((Object)this.type) + " offset=" + this.offset + " [" + this.data.length + "]" + this.data;
    }

    public static <O> CArray<O> ALLOC__(int size, ZType type) {
        CArray<O> result = new CArray<O>(new Object[size], 0, type);
        for (int i = 0; i < size; ++i) {
            result.data[i] = type.create();
        }
        return result;
    }

    public static <O> CArray<O> REALLOC__(int size, CArray<O> old, ZType type) {
        if (old == null) {
            return CArray.ALLOC__(size, type);
        }
        if (size <= old.data.length) {
            return old;
        }
        if (old.offset != 0) {
            throw new IllegalStateException();
        }
        WasmLog.log("Realloc from " + old.data.length + " to " + size);
        CArray<O> result = new CArray<O>(new Object[size], 0, type);
        System.arraycopy(old.data, 0, result.data, 0, old.data.length);
        for (int i = old.data.length; i < result.data.length; ++i) {
            result.data[i] = type.create();
        }
        return result;
    }

    private CArray(Object[] data, int offset, ZType type) {
        this.data = data;
        this.offset = offset;
        this.type = type;
    }

    public CArray<O> plus_(int delta) {
        return new CArray<O>(this.data, this.offset + delta, this.type);
    }

    public int minus_(CArray<O> other) {
        if (this.data != other.data) {
            throw new IllegalArgumentException();
        }
        return this.offset - other.offset;
    }

    public O get__(int i) {
        return (O)this.data[i + this.offset];
    }
}

