/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.reader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import znaishaded.com.fasterxml.jackson.databind.DeserializationFeature;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.ObjectMapper;
import znaishaded.io.swagger.io.Authentication;
import znaishaded.io.swagger.io.HttpClient;
import znaishaded.io.swagger.reader.SwaggerReader;
import znaishaded.io.swagger.report.Message;
import znaishaded.io.swagger.report.MessageBuilder;
import znaishaded.io.swagger.report.Severity;

final class SimpleSwaggerReader
implements SwaggerReader {
    private final ObjectMapper objectMapper = new ObjectMapper();

    SimpleSwaggerReader() {
        this.objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
    }

    @Override
    public JsonNode read(String url, Authentication authentication, MessageBuilder messageBuilder) {
        HttpClient httpClient = new HttpClient(url);
        JsonNode jsonNode = null;
        authentication.apply(httpClient);
        try {
            InputStream swaggerJson = httpClient.execute();
            jsonNode = this.objectMapper.readTree(swaggerJson);
        }
        catch (IOException | URISyntaxException e) {
            messageBuilder.append(new Message("", e.getMessage(), Severity.ERROR));
        }
        httpClient.close();
        return jsonNode;
    }
}

