/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.v3.core.util;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import znaishaded.com.fasterxml.jackson.annotation.JsonView;
import znaishaded.com.fasterxml.jackson.databind.JavaType;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.ObjectMapper;
import znaishaded.com.fasterxml.jackson.databind.introspect.Annotated;
import znaishaded.io.swagger.v3.core.converter.AnnotatedType;
import znaishaded.io.swagger.v3.core.converter.ModelConverters;
import znaishaded.io.swagger.v3.core.converter.ResolvedSchema;
import znaishaded.io.swagger.v3.core.util.Json;
import znaishaded.io.swagger.v3.core.util.ObjectMapperFactory;
import znaishaded.io.swagger.v3.core.util.PrimitiveType;
import znaishaded.io.swagger.v3.oas.annotations.ExternalDocumentation;
import znaishaded.io.swagger.v3.oas.annotations.extensions.Extension;
import znaishaded.io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import znaishaded.io.swagger.v3.oas.annotations.info.Info;
import znaishaded.io.swagger.v3.oas.annotations.info.License;
import znaishaded.io.swagger.v3.oas.annotations.links.Link;
import znaishaded.io.swagger.v3.oas.annotations.links.LinkParameter;
import znaishaded.io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import znaishaded.io.swagger.v3.oas.annotations.media.Encoding;
import znaishaded.io.swagger.v3.oas.annotations.media.ExampleObject;
import znaishaded.io.swagger.v3.oas.annotations.media.Schema;
import znaishaded.io.swagger.v3.oas.annotations.media.SchemaProperty;
import znaishaded.io.swagger.v3.oas.annotations.servers.Server;
import znaishaded.io.swagger.v3.oas.models.Components;
import znaishaded.io.swagger.v3.oas.models.examples.Example;
import znaishaded.io.swagger.v3.oas.models.headers.Header;
import znaishaded.io.swagger.v3.oas.models.info.Contact;
import znaishaded.io.swagger.v3.oas.models.media.ArraySchema;
import znaishaded.io.swagger.v3.oas.models.media.ComposedSchema;
import znaishaded.io.swagger.v3.oas.models.media.Content;
import znaishaded.io.swagger.v3.oas.models.media.Encoding;
import znaishaded.io.swagger.v3.oas.models.media.MediaType;
import znaishaded.io.swagger.v3.oas.models.media.Schema;
import znaishaded.io.swagger.v3.oas.models.servers.ServerVariable;
import znaishaded.io.swagger.v3.oas.models.servers.ServerVariables;
import znaishaded.io.swagger.v3.oas.models.tags.Tag;
import znaishaded.org.apache.commons.lang3.StringUtils;
import znaishaded.org.apache.commons.lang3.math.NumberUtils;
import znaishaded.org.slf4j.Logger;
import znaishaded.org.slf4j.LoggerFactory;

public abstract class AnnotationsUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(AnnotationsUtils.class);
    public static final String COMPONENTS_REF = "#/components/schemas/";

    public static boolean hasSchemaAnnotation(znaishaded.io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema == null) {
            return false;
        }
        return !StringUtils.isBlank(schema.type()) || !StringUtils.isBlank(schema.format()) || !StringUtils.isBlank(schema.title()) || !StringUtils.isBlank(schema.description()) || !StringUtils.isBlank(schema.ref()) || !StringUtils.isBlank(schema.name()) || schema.multipleOf() != 0.0 || !StringUtils.isBlank(schema.maximum()) || !StringUtils.isBlank(schema.minimum()) || schema.exclusiveMinimum() || schema.exclusiveMaximum() || schema.maxLength() != Integer.MAX_VALUE || schema.minLength() != 0 || schema.minProperties() != 0 || schema.maxProperties() != 0 || schema.requiredProperties().length != 0 || schema.required() || schema.nullable() || schema.readOnly() || schema.writeOnly() || !schema.accessMode().equals((Object)Schema.AccessMode.AUTO) || schema.deprecated() || schema.allowableValues().length != 0 || !StringUtils.isBlank(schema.defaultValue()) || !schema.implementation().equals(Void.class) || !StringUtils.isBlank(schema.example()) || !StringUtils.isBlank(schema.pattern()) || !schema.not().equals(Void.class) || schema.allOf().length != 0 || schema.oneOf().length != 0 || schema.anyOf().length != 0 || schema.subTypes().length != 0 || AnnotationsUtils.getExternalDocumentation(schema.externalDocs()).isPresent() || !StringUtils.isBlank(schema.discriminatorProperty()) || schema.discriminatorMapping().length != 0 || schema.extensions().length != 0 || schema.hidden() || schema.enumAsRef() || !schema.additionalProperties().equals((Object)Schema.AdditionalPropertiesValue.USE_ADDITIONAL_PROPERTIES_ANNOTATION);
    }

    public static boolean equals(Annotation thisAnnotation, Annotation thatAnnotation) {
        if (thisAnnotation == null && thatAnnotation == null) {
            return true;
        }
        if (thisAnnotation == null || thatAnnotation == null) {
            return false;
        }
        if (!thisAnnotation.annotationType().equals(thatAnnotation.annotationType())) {
            return false;
        }
        if (thisAnnotation instanceof znaishaded.io.swagger.v3.oas.annotations.media.Schema) {
            return AnnotationsUtils.equals((znaishaded.io.swagger.v3.oas.annotations.media.Schema)thisAnnotation, (znaishaded.io.swagger.v3.oas.annotations.media.Schema)thatAnnotation);
        }
        if (thisAnnotation instanceof znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema) {
            return AnnotationsUtils.equals((znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema)thisAnnotation, (znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema)thatAnnotation);
        }
        return true;
    }

    public static boolean equals(znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema thisArraySchema, znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema thatArraySchema) {
        if (thisArraySchema == null && thatArraySchema == null) {
            return true;
        }
        if (thisArraySchema == null || thatArraySchema == null) {
            return false;
        }
        if (thisArraySchema.maxItems() != thatArraySchema.maxItems()) {
            return false;
        }
        if (thisArraySchema.minItems() != thatArraySchema.minItems()) {
            return false;
        }
        if (thisArraySchema.uniqueItems() != thatArraySchema.uniqueItems()) {
            return false;
        }
        if (!Arrays.equals(thisArraySchema.extensions(), thatArraySchema.extensions())) {
            return false;
        }
        return AnnotationsUtils.equals(thisArraySchema.schema(), thatArraySchema.schema());
    }

    public static boolean equals(znaishaded.io.swagger.v3.oas.annotations.media.Schema thisSchema, znaishaded.io.swagger.v3.oas.annotations.media.Schema thatSchema) {
        if (thisSchema == null && thatSchema == null) {
            return true;
        }
        if (thisSchema == null || thatSchema == null) {
            return false;
        }
        if (!StringUtils.equals(thisSchema.type(), thatSchema.type())) {
            return false;
        }
        if (!StringUtils.equals(thisSchema.format(), thatSchema.format())) {
            return false;
        }
        if (!StringUtils.equals(thisSchema.title(), thatSchema.title())) {
            return false;
        }
        if (!StringUtils.equals(thisSchema.description(), thatSchema.description())) {
            return false;
        }
        if (!StringUtils.equals(thisSchema.ref(), thatSchema.ref())) {
            return false;
        }
        if (!StringUtils.equals(thisSchema.name(), thatSchema.name())) {
            return false;
        }
        if (!StringUtils.equals(thisSchema.defaultValue(), thatSchema.defaultValue())) {
            return false;
        }
        if (!StringUtils.equals(thisSchema.maximum(), thatSchema.maximum())) {
            return false;
        }
        if (!StringUtils.equals(thisSchema.minimum(), thatSchema.minimum())) {
            return false;
        }
        if (!StringUtils.equals(thisSchema.example(), thatSchema.example())) {
            return false;
        }
        if (!StringUtils.equals(thisSchema.pattern(), thatSchema.pattern())) {
            return false;
        }
        if (!StringUtils.equals(thisSchema.discriminatorProperty(), thatSchema.discriminatorProperty())) {
            return false;
        }
        if (thisSchema.multipleOf() != thatSchema.multipleOf()) {
            return false;
        }
        if (thisSchema.minLength() != thatSchema.minLength()) {
            return false;
        }
        if (thisSchema.minProperties() != thatSchema.minProperties()) {
            return false;
        }
        if (thisSchema.maxProperties() != thatSchema.maxProperties()) {
            return false;
        }
        if (thisSchema.maxLength() != thatSchema.maxLength()) {
            return false;
        }
        if (!Arrays.equals(thisSchema.allOf(), thatSchema.allOf())) {
            return false;
        }
        if (!Arrays.equals(thisSchema.oneOf(), thatSchema.oneOf())) {
            return false;
        }
        if (!Arrays.equals(thisSchema.anyOf(), thatSchema.anyOf())) {
            return false;
        }
        if (!Arrays.equals(thisSchema.subTypes(), thatSchema.subTypes())) {
            return false;
        }
        if (!Arrays.equals(thisSchema.discriminatorMapping(), thatSchema.discriminatorMapping())) {
            return false;
        }
        if (!Arrays.equals(thisSchema.extensions(), thatSchema.extensions())) {
            return false;
        }
        if (!Arrays.equals(thisSchema.allowableValues(), thatSchema.allowableValues())) {
            return false;
        }
        if (!Arrays.equals(thisSchema.requiredProperties(), thatSchema.requiredProperties())) {
            return false;
        }
        if (thisSchema.exclusiveMinimum() != thatSchema.exclusiveMinimum()) {
            return false;
        }
        if (thisSchema.exclusiveMaximum() != thatSchema.exclusiveMaximum()) {
            return false;
        }
        if (thisSchema.required() != thatSchema.required()) {
            return false;
        }
        if (thisSchema.nullable() != thatSchema.nullable()) {
            return false;
        }
        if (thisSchema.readOnly() != thatSchema.readOnly()) {
            return false;
        }
        if (thisSchema.writeOnly() != thatSchema.writeOnly()) {
            return false;
        }
        if (!thisSchema.accessMode().equals((Object)thatSchema.accessMode())) {
            return false;
        }
        if (thisSchema.deprecated() != thatSchema.deprecated()) {
            return false;
        }
        if (thisSchema.hidden() != thatSchema.hidden()) {
            return false;
        }
        if (thisSchema.enumAsRef() != thatSchema.enumAsRef()) {
            return false;
        }
        if (!thisSchema.implementation().equals(thatSchema.implementation())) {
            return false;
        }
        if (!thisSchema.not().equals(thatSchema.not())) {
            return false;
        }
        if (!StringUtils.equals(thisSchema.externalDocs().description(), thatSchema.externalDocs().description())) {
            return false;
        }
        if (!StringUtils.equals(thisSchema.externalDocs().url(), thatSchema.externalDocs().url())) {
            return false;
        }
        if (thisSchema.externalDocs().extensions().length != thatSchema.externalDocs().extensions().length) {
            return false;
        }
        if (!Arrays.equals(thisSchema.extensions(), thatSchema.extensions())) {
            return false;
        }
        return thisSchema.additionalProperties().equals((Object)thatSchema.additionalProperties());
    }

    public static boolean hasArrayAnnotation(znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema array) {
        if (array == null) {
            return false;
        }
        return array.uniqueItems() || array.maxItems() != Integer.MIN_VALUE || array.minItems() != Integer.MAX_VALUE || AnnotationsUtils.hasSchemaAnnotation(array.schema()) || AnnotationsUtils.hasSchemaAnnotation(array.arraySchema());
    }

    public static Optional<Example> getExample(ExampleObject example) {
        return AnnotationsUtils.getExample(example, false);
    }

    public static Optional<Example> getExample(ExampleObject example, boolean ignoreName) {
        if (example == null) {
            return Optional.empty();
        }
        Example exampleObject = new Example();
        if (!ignoreName && StringUtils.isNotBlank(example.name())) {
            if (StringUtils.isNotBlank(example.name())) {
                exampleObject.setDescription(example.name());
            }
            AnnotationsUtils.resolveExample(exampleObject, example);
            return Optional.of(exampleObject);
        }
        if (ignoreName && AnnotationsUtils.resolveExample(exampleObject, example)) {
            return Optional.of(exampleObject);
        }
        return Optional.empty();
    }

    private static boolean resolveExample(Example exampleObject, ExampleObject example) {
        boolean isEmpty = true;
        if (StringUtils.isNotBlank(example.summary())) {
            isEmpty = false;
            exampleObject.setSummary(example.summary());
        }
        if (StringUtils.isNotBlank(example.description())) {
            isEmpty = false;
            exampleObject.setDescription(example.description());
        }
        if (StringUtils.isNotBlank(example.externalValue())) {
            isEmpty = false;
            exampleObject.setExternalValue(example.externalValue());
        }
        if (StringUtils.isNotBlank(example.value())) {
            isEmpty = false;
            try {
                ObjectMapper mapper = ObjectMapperFactory.buildStrictGenericObjectMapper();
                exampleObject.setValue(mapper.readTree(example.value()));
            }
            catch (IOException e) {
                exampleObject.setValue(example.value());
            }
        }
        if (StringUtils.isNotBlank(example.ref())) {
            isEmpty = false;
            exampleObject.set$ref(example.ref());
        }
        if (example.extensions().length > 0) {
            isEmpty = false;
            Map<String, Object> extensions = AnnotationsUtils.getExtensions(example.extensions());
            if (extensions != null) {
                extensions.forEach(exampleObject::addExtension);
            }
        }
        return !isEmpty;
    }

    public static Optional<ArraySchema> getArraySchema(znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema arraySchema, JsonView jsonViewAnnotation) {
        return AnnotationsUtils.getArraySchema(arraySchema, null, jsonViewAnnotation);
    }

    public static Optional<ArraySchema> getArraySchema(znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema arraySchema, Components components, JsonView jsonViewAnnotation) {
        Map<String, Object> extensions;
        if (arraySchema == null || !AnnotationsUtils.hasArrayAnnotation(arraySchema)) {
            return Optional.empty();
        }
        ArraySchema arraySchemaObject = new ArraySchema();
        if (arraySchema.uniqueItems()) {
            arraySchemaObject.setUniqueItems(arraySchema.uniqueItems());
        }
        if (arraySchema.maxItems() > 0) {
            arraySchemaObject.setMaxItems(arraySchema.maxItems());
        }
        if (arraySchema.minItems() < Integer.MAX_VALUE) {
            arraySchemaObject.setMinItems(arraySchema.minItems());
        }
        if (arraySchema.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(arraySchema.extensions())) != null) {
            extensions.forEach(arraySchemaObject::addExtension);
        }
        if (arraySchema.schema() != null && arraySchema.schema().implementation().equals(Void.class)) {
            AnnotationsUtils.getSchemaFromAnnotation(arraySchema.schema(), components, jsonViewAnnotation).ifPresent(arraySchemaObject::setItems);
        }
        return Optional.of(arraySchemaObject);
    }

    public static Optional<Schema> getSchemaFromAnnotation(znaishaded.io.swagger.v3.oas.annotations.media.Schema schema, JsonView jsonViewAnnotation) {
        return AnnotationsUtils.getSchemaFromAnnotation(schema, null, jsonViewAnnotation);
    }

    public static Optional<Schema> getSchemaFromAnnotation(znaishaded.io.swagger.v3.oas.annotations.media.Schema schema, Components components, JsonView jsonViewAnnotation) {
        Class<?>[] schemaImplementations;
        Map<String, Object> extensions;
        if (schema == null || !AnnotationsUtils.hasSchemaAnnotation(schema)) {
            return Optional.empty();
        }
        Schema schemaObject = null;
        schemaObject = schema.oneOf().length > 0 || schema.allOf().length > 0 || schema.anyOf().length > 0 ? new ComposedSchema() : new Schema();
        if (StringUtils.isNotBlank(schema.description())) {
            schemaObject.setDescription(schema.description());
        }
        if (StringUtils.isNotBlank(schema.ref())) {
            schemaObject.set$ref(schema.ref());
        }
        if (StringUtils.isNotBlank(schema.type())) {
            schemaObject.setType(schema.type());
        }
        if (StringUtils.isNotBlank(schema.defaultValue())) {
            schemaObject.setDefault(schema.defaultValue());
        }
        if (StringUtils.isNotBlank(schema.example())) {
            try {
                schemaObject.setExample(Json.mapper().readTree(schema.example()));
            }
            catch (IOException e) {
                schemaObject.setExample(schema.example());
            }
        }
        if (StringUtils.isNotBlank(schema.format())) {
            schemaObject.setFormat(schema.format());
        }
        if (StringUtils.isNotBlank(schema.pattern())) {
            schemaObject.setPattern(schema.pattern());
        }
        if (schema.readOnly()) {
            schemaObject.setReadOnly(schema.readOnly());
        }
        if (schema.deprecated()) {
            schemaObject.setDeprecated(schema.deprecated());
        }
        if (schema.exclusiveMaximum()) {
            schemaObject.setExclusiveMaximum(schema.exclusiveMaximum());
        }
        if (schema.exclusiveMinimum()) {
            schemaObject.setExclusiveMinimum(schema.exclusiveMinimum());
        }
        if (schema.maxProperties() > 0) {
            schemaObject.setMaxProperties(schema.maxProperties());
        }
        if (schema.maxLength() != Integer.MAX_VALUE && schema.maxLength() > 0) {
            schemaObject.setMaxLength(schema.maxLength());
        }
        if (schema.minProperties() > 0) {
            schemaObject.setMinProperties(schema.minProperties());
        }
        if (schema.minLength() > 0) {
            schemaObject.setMinLength(schema.minLength());
        }
        if (schema.multipleOf() != 0.0) {
            schemaObject.setMultipleOf(BigDecimal.valueOf(schema.multipleOf()));
        }
        if (NumberUtils.isCreatable(schema.maximum())) {
            String filteredMaximum = schema.maximum().replace(",", "");
            schemaObject.setMaximum(new BigDecimal(filteredMaximum));
        }
        if (NumberUtils.isCreatable(schema.minimum())) {
            String filteredMinimum = schema.minimum().replace(",", "");
            schemaObject.setMinimum(new BigDecimal(filteredMinimum));
        }
        if (schema.nullable()) {
            schemaObject.setNullable(schema.nullable());
        }
        if (StringUtils.isNotBlank(schema.title())) {
            schemaObject.setTitle(schema.title());
        }
        if (schema.writeOnly()) {
            schemaObject.setWriteOnly(schema.writeOnly());
        }
        if (schema.accessMode().equals((Object)Schema.AccessMode.READ_ONLY)) {
            schemaObject.setReadOnly(true);
            schemaObject.setWriteOnly(null);
        } else if (schema.accessMode().equals((Object)Schema.AccessMode.WRITE_ONLY)) {
            schemaObject.setReadOnly(false);
            schemaObject.setWriteOnly(null);
        } else if (schema.accessMode().equals((Object)Schema.AccessMode.READ_WRITE)) {
            schemaObject.setReadOnly(null);
            schemaObject.setWriteOnly(null);
        }
        if (schema.requiredProperties().length > 0) {
            schemaObject.setRequired(Arrays.asList(schema.requiredProperties()));
        }
        if (schema.allowableValues().length > 0) {
            schemaObject.setEnum(Arrays.asList(schema.allowableValues()));
        }
        if (schema.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(schema.extensions())) != null) {
            extensions.forEach(schemaObject::addExtension);
        }
        AnnotationsUtils.getExternalDocumentation(schema.externalDocs()).ifPresent(schemaObject::setExternalDocs);
        if (!schema.not().equals(Void.class)) {
            Class<?> schemaImplementation = schema.not();
            Schema notSchemaObject = AnnotationsUtils.resolveSchemaFromType(schemaImplementation, components, jsonViewAnnotation);
            schemaObject.setNot(notSchemaObject);
        }
        if (schema.oneOf().length > 0) {
            for (Class<?> schemaImplementation : schemaImplementations = schema.oneOf()) {
                Schema oneOfSchemaObject = AnnotationsUtils.resolveSchemaFromType(schemaImplementation, components, jsonViewAnnotation);
                ((ComposedSchema)schemaObject).addOneOfItem(oneOfSchemaObject);
            }
        }
        if (schema.anyOf().length > 0) {
            for (Class<?> schemaImplementation : schemaImplementations = schema.anyOf()) {
                Schema anyOfSchemaObject = AnnotationsUtils.resolveSchemaFromType(schemaImplementation, components, jsonViewAnnotation);
                ((ComposedSchema)schemaObject).addAnyOfItem(anyOfSchemaObject);
            }
        }
        if (schema.allOf().length > 0) {
            for (Class<?> schemaImplementation : schemaImplementations = schema.allOf()) {
                Schema allOfSchemaObject = AnnotationsUtils.resolveSchemaFromType(schemaImplementation, components, jsonViewAnnotation);
                ((ComposedSchema)schemaObject).addAllOfItem(allOfSchemaObject);
            }
        }
        if (schema.additionalProperties().equals((Object)Schema.AdditionalPropertiesValue.TRUE)) {
            schemaObject.additionalProperties(true);
        } else if (schema.additionalProperties().equals((Object)Schema.AdditionalPropertiesValue.FALSE)) {
            schemaObject.additionalProperties(false);
        }
        return Optional.of(schemaObject);
    }

    public static Schema resolveSchemaFromType(Class<?> schemaImplementation, Components components, JsonView jsonViewAnnotation) {
        Schema schemaObject;
        PrimitiveType primitiveType = PrimitiveType.fromType(schemaImplementation);
        if (primitiveType != null) {
            schemaObject = primitiveType.createProperty();
        } else {
            schemaObject = new Schema();
            ResolvedSchema resolvedSchema = ModelConverters.getInstance().readAllAsResolvedSchema(new AnnotatedType().type(schemaImplementation).jsonViewAnnotation(jsonViewAnnotation));
            if (resolvedSchema != null) {
                Map<String, Schema> schemaMap = resolvedSchema.referencedSchemas;
                if (schemaMap != null) {
                    schemaMap.forEach((key, referencedSchema) -> {
                        if (components != null) {
                            components.addSchemas((String)key, (Schema)referencedSchema);
                        }
                    });
                }
                if (resolvedSchema.schema != null) {
                    if (StringUtils.isNotBlank(resolvedSchema.schema.getName())) {
                        schemaObject.set$ref(COMPONENTS_REF + resolvedSchema.schema.getName());
                    } else {
                        schemaObject = resolvedSchema.schema;
                    }
                }
            }
        }
        if (StringUtils.isBlank(schemaObject.get$ref()) && StringUtils.isBlank(schemaObject.getType())) {
            schemaObject.setType("string");
        }
        return schemaObject;
    }

    public static Optional<Set<Tag>> getTags(znaishaded.io.swagger.v3.oas.annotations.tags.Tag[] tags, boolean skipOnlyName) {
        if (tags == null) {
            return Optional.empty();
        }
        LinkedHashSet<Tag> tagsList = new LinkedHashSet<Tag>();
        for (znaishaded.io.swagger.v3.oas.annotations.tags.Tag tag : tags) {
            Map<String, Object> extensions;
            if (StringUtils.isBlank(tag.name()) || skipOnlyName && StringUtils.isBlank(tag.description()) && StringUtils.isBlank(tag.externalDocs().description()) && StringUtils.isBlank(tag.externalDocs().url())) continue;
            Tag tagObject = new Tag();
            if (StringUtils.isNotBlank(tag.description())) {
                tagObject.setDescription(tag.description());
            }
            tagObject.setName(tag.name());
            AnnotationsUtils.getExternalDocumentation(tag.externalDocs()).ifPresent(tagObject::setExternalDocs);
            if (tag.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(tag.extensions())) != null) {
                extensions.forEach(tagObject::addExtension);
            }
            tagsList.add(tagObject);
        }
        if (tagsList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(tagsList);
    }

    public static Optional<List<znaishaded.io.swagger.v3.oas.models.servers.Server>> getServers(Server[] servers) {
        if (servers == null) {
            return Optional.empty();
        }
        ArrayList serverObjects = new ArrayList();
        for (Server server : servers) {
            AnnotationsUtils.getServer(server).ifPresent(serverObjects::add);
        }
        if (serverObjects.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(serverObjects);
    }

    public static Optional<znaishaded.io.swagger.v3.oas.models.servers.Server> getServer(Server server) {
        if (server == null) {
            return Optional.empty();
        }
        znaishaded.io.swagger.v3.oas.models.servers.Server serverObject = new znaishaded.io.swagger.v3.oas.models.servers.Server();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank(server.url())) {
            serverObject.setUrl(server.url());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank(server.description())) {
            serverObject.setDescription(server.description());
            isEmpty = false;
        }
        if (server.extensions().length > 0) {
            Map<String, Object> extensions = AnnotationsUtils.getExtensions(server.extensions());
            if (extensions != null) {
                extensions.forEach(serverObject::addExtension);
            }
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        znaishaded.io.swagger.v3.oas.annotations.servers.ServerVariable[] serverVariables = server.variables();
        ServerVariables serverVariablesObject = new ServerVariables();
        for (znaishaded.io.swagger.v3.oas.annotations.servers.ServerVariable serverVariable : serverVariables) {
            Map<String, Object> extensions;
            ServerVariable serverVariableObject = new ServerVariable();
            if (StringUtils.isNotBlank(serverVariable.description())) {
                serverVariableObject.setDescription(serverVariable.description());
            }
            if (StringUtils.isNotBlank(serverVariable.defaultValue())) {
                serverVariableObject.setDefault(serverVariable.defaultValue());
            }
            if (serverVariable.allowableValues() != null && serverVariable.allowableValues().length > 0 && StringUtils.isNotBlank(serverVariable.allowableValues()[0])) {
                serverVariableObject.setEnum(Arrays.asList(serverVariable.allowableValues()));
            }
            if (serverVariable.extensions() != null && serverVariable.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(serverVariable.extensions())) != null) {
                extensions.forEach(serverVariableObject::addExtension);
            }
            serverVariablesObject.addServerVariable(serverVariable.name(), serverVariableObject);
        }
        serverObject.setVariables(serverVariablesObject);
        return Optional.of(serverObject);
    }

    public static Optional<znaishaded.io.swagger.v3.oas.models.ExternalDocumentation> getExternalDocumentation(ExternalDocumentation externalDocumentation) {
        Map<String, Object> extensions;
        if (externalDocumentation == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        znaishaded.io.swagger.v3.oas.models.ExternalDocumentation external = new znaishaded.io.swagger.v3.oas.models.ExternalDocumentation();
        if (StringUtils.isNotBlank(externalDocumentation.description())) {
            isEmpty = false;
            external.setDescription(externalDocumentation.description());
        }
        if (StringUtils.isNotBlank(externalDocumentation.url())) {
            isEmpty = false;
            external.setUrl(externalDocumentation.url());
        }
        if (externalDocumentation.extensions() != null && externalDocumentation.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(externalDocumentation.extensions())) != null) {
            extensions.forEach(external::addExtension);
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(external);
    }

    public static Optional<znaishaded.io.swagger.v3.oas.models.info.Info> getInfo(Info info) {
        Map<String, Object> extensions;
        if (info == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        znaishaded.io.swagger.v3.oas.models.info.Info infoObject = new znaishaded.io.swagger.v3.oas.models.info.Info();
        if (StringUtils.isNotBlank(info.description())) {
            infoObject.setDescription(info.description());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank(info.termsOfService())) {
            infoObject.setTermsOfService(info.termsOfService());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank(info.title())) {
            infoObject.setTitle(info.title());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank(info.version())) {
            infoObject.setVersion(info.version());
            isEmpty = false;
        }
        if (info.extensions() != null && info.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(info.extensions())) != null) {
            extensions.forEach(infoObject::addExtension);
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        AnnotationsUtils.getContact(info.contact()).ifPresent(infoObject::setContact);
        AnnotationsUtils.getLicense(info.license()).ifPresent(infoObject::setLicense);
        return Optional.of(infoObject);
    }

    public static Optional<Contact> getContact(znaishaded.io.swagger.v3.oas.annotations.info.Contact contact) {
        Map<String, Object> extensions;
        if (contact == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        Contact contactObject = new Contact();
        if (StringUtils.isNotBlank(contact.email())) {
            contactObject.setEmail(contact.email());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank(contact.name())) {
            contactObject.setName(contact.name());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank(contact.url())) {
            contactObject.setUrl(contact.url());
            isEmpty = false;
        }
        if (contact.extensions() != null && contact.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(contact.extensions())) != null) {
            extensions.forEach(contactObject::addExtension);
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(contactObject);
    }

    public static Optional<znaishaded.io.swagger.v3.oas.models.info.License> getLicense(License license) {
        Map<String, Object> extensions;
        if (license == null) {
            return Optional.empty();
        }
        znaishaded.io.swagger.v3.oas.models.info.License licenseObject = new znaishaded.io.swagger.v3.oas.models.info.License();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank(license.name())) {
            licenseObject.setName(license.name());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank(license.url())) {
            licenseObject.setUrl(license.url());
            isEmpty = false;
        }
        if (license.extensions() != null && license.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(license.extensions())) != null) {
            extensions.forEach(licenseObject::addExtension);
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(licenseObject);
    }

    public static Map<String, znaishaded.io.swagger.v3.oas.models.links.Link> getLinks(Link[] links) {
        HashMap<String, znaishaded.io.swagger.v3.oas.models.links.Link> linkMap = new HashMap<String, znaishaded.io.swagger.v3.oas.models.links.Link>();
        if (links == null) {
            return linkMap;
        }
        for (Link link : links) {
            AnnotationsUtils.getLink(link).ifPresent(linkResult -> linkMap.put(link.name(), (znaishaded.io.swagger.v3.oas.models.links.Link)linkResult));
        }
        return linkMap;
    }

    public static Optional<znaishaded.io.swagger.v3.oas.models.links.Link> getLink(Link link) {
        Map<String, Object> extensions;
        if (link == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        znaishaded.io.swagger.v3.oas.models.links.Link linkObject = new znaishaded.io.swagger.v3.oas.models.links.Link();
        if (StringUtils.isNotBlank(link.description())) {
            linkObject.setDescription(link.description());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank(link.operationId())) {
            linkObject.setOperationId(link.operationId());
            isEmpty = false;
            if (StringUtils.isNotBlank(link.operationRef())) {
                LOGGER.debug("OperationId and OperatonRef are mutually exclusive, there must be only one setted");
            }
        } else if (StringUtils.isNotBlank(link.operationRef())) {
            linkObject.setOperationRef(link.operationRef());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank(link.ref())) {
            linkObject.set$ref(link.ref());
            isEmpty = false;
        }
        if (link.extensions() != null && link.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(link.extensions())) != null) {
            extensions.forEach(linkObject::addExtension);
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        Map<String, String> linkParameters = AnnotationsUtils.getLinkParameters(link.parameters());
        if (linkParameters.size() > 0) {
            linkObject.setParameters(linkParameters);
        }
        if (StringUtils.isNotBlank(link.requestBody())) {
            JsonNode processedValue = null;
            try {
                processedValue = Json.mapper().readTree(link.requestBody());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (processedValue == null) {
                linkObject.requestBody(link.requestBody());
            } else {
                linkObject.requestBody(processedValue);
            }
        }
        return Optional.of(linkObject);
    }

    public static Map<String, String> getLinkParameters(LinkParameter[] linkParameter) {
        HashMap<String, String> linkParametersMap = new HashMap<String, String>();
        if (linkParameter == null) {
            return linkParametersMap;
        }
        for (LinkParameter parameter : linkParameter) {
            if (!StringUtils.isNotBlank(parameter.name())) continue;
            linkParametersMap.put(parameter.name(), parameter.expression());
        }
        return linkParametersMap;
    }

    public static Optional<Map<String, Header>> getHeaders(znaishaded.io.swagger.v3.oas.annotations.headers.Header[] annotationHeaders, JsonView jsonViewAnnotation) {
        if (annotationHeaders == null) {
            return Optional.empty();
        }
        HashMap headers = new HashMap();
        for (znaishaded.io.swagger.v3.oas.annotations.headers.Header header : annotationHeaders) {
            AnnotationsUtils.getHeader(header, jsonViewAnnotation).ifPresent(headerResult -> headers.put(header.name(), headerResult));
        }
        if (headers.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(headers);
    }

    public static Optional<Header> getHeader(znaishaded.io.swagger.v3.oas.annotations.headers.Header header, JsonView jsonViewAnnotation) {
        boolean isEmpty;
        if (header == null) {
            return Optional.empty();
        }
        Header headerObject = new Header();
        boolean bl = isEmpty = !StringUtils.isNotBlank(header.name());
        if (StringUtils.isNotBlank(header.description())) {
            headerObject.setDescription(header.description());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank(header.ref())) {
            headerObject.set$ref(header.ref());
            isEmpty = false;
        }
        if (header.deprecated()) {
            headerObject.setDeprecated(header.deprecated());
        }
        if (header.required()) {
            headerObject.setRequired(header.required());
            isEmpty = false;
        }
        headerObject.setStyle(Header.StyleEnum.SIMPLE);
        if (header.schema() != null && header.schema().implementation().equals(Void.class)) {
            AnnotationsUtils.getSchemaFromAnnotation(header.schema(), jsonViewAnnotation).ifPresent(headerObject::setSchema);
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(headerObject);
    }

    public static void addEncodingToMediaType(MediaType mediaType, Encoding encoding, JsonView jsonViewAnnotation) {
        if (encoding == null) {
            return;
        }
        if (StringUtils.isNotBlank(encoding.name())) {
            Map<String, Object> extensions;
            znaishaded.io.swagger.v3.oas.models.media.Encoding encodingObject = new znaishaded.io.swagger.v3.oas.models.media.Encoding();
            if (StringUtils.isNotBlank(encoding.contentType())) {
                encodingObject.setContentType(encoding.contentType());
            }
            if (StringUtils.isNotBlank(encoding.style())) {
                encodingObject.setStyle(Encoding.StyleEnum.valueOf(encoding.style()));
            }
            if (encoding.explode()) {
                encodingObject.setExplode(encoding.explode());
            }
            if (encoding.allowReserved()) {
                encodingObject.setAllowReserved(encoding.allowReserved());
            }
            if (encoding.headers() != null) {
                AnnotationsUtils.getHeaders(encoding.headers(), jsonViewAnnotation).ifPresent(encodingObject::headers);
            }
            if (encoding.extensions() != null && encoding.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(encoding.extensions())) != null) {
                extensions.forEach(encodingObject::addExtension);
            }
            mediaType.addEncoding(encoding.name(), encodingObject);
        }
    }

    public static Type getSchemaType(znaishaded.io.swagger.v3.oas.annotations.media.Schema schema) {
        return AnnotationsUtils.getSchemaType(schema, false);
    }

    public static Type getSchemaType(znaishaded.io.swagger.v3.oas.annotations.media.Schema schema, boolean nullIfNotFound) {
        if (schema == null) {
            if (nullIfNotFound) {
                return null;
            }
            return String.class;
        }
        String schemaType = schema.type();
        String schemaFormat = schema.format();
        Class<?> schemaImplementation = schema.implementation();
        if (!schemaImplementation.equals(Void.class)) {
            return schemaImplementation;
        }
        if (StringUtils.isBlank(schemaType)) {
            if (nullIfNotFound) {
                return null;
            }
            return String.class;
        }
        switch (schemaType) {
            case "number": {
                if ("float".equals(schemaFormat)) {
                    return Float.class;
                }
                if ("double".equals(schemaFormat)) {
                    return Double.class;
                }
                return BigDecimal.class;
            }
            case "integer": {
                if ("int32".equals(schemaFormat)) {
                    return Integer.class;
                }
                return Long.class;
            }
            case "boolean": {
                return Boolean.class;
            }
            case "string": {
                return String.class;
            }
        }
        if (nullIfNotFound) {
            return null;
        }
        return String.class;
    }

    /*
     * WARNING - void declaration
     */
    public static Optional<Content> getContent(znaishaded.io.swagger.v3.oas.annotations.media.Content[] annotationContents, String[] classTypes, String[] methodTypes, Schema schema, Components components, JsonView jsonViewAnnotation) {
        if (annotationContents == null || annotationContents.length == 0) {
            return Optional.empty();
        }
        Content content = new Content();
        for (znaishaded.io.swagger.v3.oas.annotations.media.Content annotationContent : annotationContents) {
            void var16_17;
            Encoding[] encodings;
            Map<String, Object> extensions;
            ExampleObject[] examples;
            MediaType mediaType = new MediaType();
            if (components != null) {
                AnnotationsUtils.getSchema(annotationContent, components, jsonViewAnnotation).ifPresent(mediaType::setSchema);
                if (annotationContent.schemaProperties().length > 0) {
                    if (mediaType.getSchema() == null) {
                        mediaType.schema(new Schema().type("object"));
                    }
                    Schema oSchema = mediaType.getSchema();
                    for (Annotation annotation : annotationContent.schemaProperties()) {
                        Class<?> schemaImplementation = annotation.schema().implementation();
                        boolean isArray = false;
                        if (schemaImplementation == Void.class && (schemaImplementation = annotation.array().schema().implementation()) != Void.class) {
                            isArray = true;
                        }
                        AnnotationsUtils.getSchema(annotation.schema(), annotation.array(), isArray, schemaImplementation, components, jsonViewAnnotation).ifPresent(arg_0 -> AnnotationsUtils.lambda$getContent$3(oSchema, (SchemaProperty)annotation, arg_0));
                    }
                }
                if (AnnotationsUtils.hasSchemaAnnotation(annotationContent.additionalPropertiesSchema()) && mediaType.getSchema() != null && !Boolean.TRUE.equals(mediaType.getSchema().getAdditionalProperties()) && !Boolean.FALSE.equals(mediaType.getSchema().getAdditionalProperties())) {
                    AnnotationsUtils.getSchemaFromAnnotation(annotationContent.additionalPropertiesSchema(), components, jsonViewAnnotation).ifPresent(s2 -> {
                        if ("array".equals(mediaType.getSchema().getType())) {
                            mediaType.getSchema().getItems().additionalProperties(s2);
                        } else {
                            mediaType.getSchema().additionalProperties(s2);
                        }
                    });
                }
            } else {
                mediaType.setSchema(schema);
            }
            if ((examples = annotationContent.examples()).length == 1 && StringUtils.isBlank(examples[0].name())) {
                AnnotationsUtils.getExample(examples[0], true).ifPresent(exampleObject -> mediaType.example(exampleObject.getValue()));
            } else {
                for (ExampleObject exampleObject2 : examples) {
                    AnnotationsUtils.getExample(exampleObject2).ifPresent(exampleObject -> mediaType.addExamples(example.name(), (Example)exampleObject));
                }
            }
            if (annotationContent.extensions() != null && annotationContent.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(annotationContent.extensions())) != null) {
                extensions.forEach(mediaType::addExtension);
            }
            Encoding[] encodingArray = encodings = annotationContent.encoding();
            int n = encodingArray.length;
            boolean bl = false;
            while (var16_17 < n) {
                Encoding encoding = encodingArray[var16_17];
                AnnotationsUtils.addEncodingToMediaType(mediaType, encoding, jsonViewAnnotation);
                ++var16_17;
            }
            if (StringUtils.isNotBlank(annotationContent.mediaType())) {
                content.addMediaType(annotationContent.mediaType(), mediaType);
                continue;
            }
            AnnotationsUtils.applyTypes(classTypes, methodTypes, content, mediaType);
        }
        if (content.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(content);
    }

    public static Optional<? extends Schema> getSchema(znaishaded.io.swagger.v3.oas.annotations.media.Content annotationContent, Components components, JsonView jsonViewAnnotation) {
        Class<?> schemaImplementation = annotationContent.schema().implementation();
        boolean isArray = false;
        if (schemaImplementation == Void.class && (schemaImplementation = annotationContent.array().schema().implementation()) != Void.class) {
            isArray = true;
        }
        return AnnotationsUtils.getSchema(annotationContent.schema(), annotationContent.array(), isArray, schemaImplementation, components, jsonViewAnnotation);
    }

    public static Optional<? extends Schema> getSchema(znaishaded.io.swagger.v3.oas.annotations.media.Schema schemaAnnotation, znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema arrayAnnotation, boolean isArray, Class<?> schemaImplementation, Components components, JsonView jsonViewAnnotation) {
        if (schemaImplementation != Void.class) {
            Schema schemaObject = AnnotationsUtils.resolveSchemaFromType(schemaImplementation, components, jsonViewAnnotation);
            if (StringUtils.isNotBlank(schemaAnnotation.format())) {
                schemaObject.setFormat(schemaAnnotation.format());
            }
            if (isArray) {
                Optional<ArraySchema> arraySchema = AnnotationsUtils.getArraySchema(arrayAnnotation, components, jsonViewAnnotation);
                if (arraySchema.isPresent()) {
                    arraySchema.get().setItems(schemaObject);
                    return arraySchema;
                }
                return Optional.empty();
            }
            return Optional.of(schemaObject);
        }
        Optional<Schema> schemaFromAnnotation = AnnotationsUtils.getSchemaFromAnnotation(schemaAnnotation, components, jsonViewAnnotation);
        if (schemaFromAnnotation.isPresent()) {
            if (StringUtils.isBlank(schemaFromAnnotation.get().get$ref()) && StringUtils.isBlank(schemaFromAnnotation.get().getType()) && !(schemaFromAnnotation.get() instanceof ComposedSchema)) {
                schemaFromAnnotation.get().setType("string");
            }
            return Optional.of(schemaFromAnnotation.get());
        }
        Optional<ArraySchema> arraySchemaFromAnnotation = AnnotationsUtils.getArraySchema(arrayAnnotation, components, jsonViewAnnotation);
        if (arraySchemaFromAnnotation.isPresent()) {
            if (arraySchemaFromAnnotation.get().getItems() != null && StringUtils.isBlank(arraySchemaFromAnnotation.get().getItems().get$ref()) && StringUtils.isBlank(arraySchemaFromAnnotation.get().getItems().getType())) {
                arraySchemaFromAnnotation.get().getItems().setType("string");
            }
            return Optional.of(arraySchemaFromAnnotation.get());
        }
        return Optional.empty();
    }

    public static void applyTypes(String[] classTypes, String[] methodTypes, Content content, MediaType mediaType) {
        if (methodTypes != null && methodTypes.length > 0) {
            for (String value : methodTypes) {
                content.addMediaType(value, mediaType);
            }
        } else if (classTypes != null && classTypes.length > 0) {
            for (String value : classTypes) {
                content.addMediaType(value, mediaType);
            }
        } else {
            content.addMediaType("*/*", mediaType);
        }
    }

    public static znaishaded.io.swagger.v3.oas.annotations.media.Schema getSchemaAnnotation(Annotated a) {
        if (a == null) {
            return null;
        }
        znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema arraySchema = a.getAnnotation(znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema.class);
        if (arraySchema != null) {
            return arraySchema.schema();
        }
        return a.getAnnotation(znaishaded.io.swagger.v3.oas.annotations.media.Schema.class);
    }

    public static znaishaded.io.swagger.v3.oas.annotations.media.Schema getSchemaDeclaredAnnotation(Annotated a) {
        if (a == null) {
            return null;
        }
        znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema arraySchema = a.getRawType().getDeclaredAnnotation(znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema.class);
        if (arraySchema != null) {
            return arraySchema.schema();
        }
        return a.getRawType().getDeclaredAnnotation(znaishaded.io.swagger.v3.oas.annotations.media.Schema.class);
    }

    public static znaishaded.io.swagger.v3.oas.annotations.media.Schema getSchemaAnnotation(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        znaishaded.io.swagger.v3.oas.annotations.media.Schema mp = null;
        znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema as = cls.getAnnotation(znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema.class);
        mp = as != null ? as.schema() : cls.getAnnotation(znaishaded.io.swagger.v3.oas.annotations.media.Schema.class);
        return mp;
    }

    public static znaishaded.io.swagger.v3.oas.annotations.media.Schema getSchemaDeclaredAnnotation(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        znaishaded.io.swagger.v3.oas.annotations.media.Schema mp = null;
        znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema as = cls.getDeclaredAnnotation(znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema.class);
        mp = as != null ? as.schema() : cls.getDeclaredAnnotation(znaishaded.io.swagger.v3.oas.annotations.media.Schema.class);
        return mp;
    }

    public static Map<String, Object> getExtensions(Extension ... extensions) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Extension extension : extensions) {
            String name = extension.name();
            String key = name.length() > 0 ? StringUtils.prependIfMissing(name, (CharSequence)"x-", new CharSequence[0]) : name;
            for (ExtensionProperty property : extension.properties()) {
                String propertyName = property.name();
                String propertyValue = property.value();
                JsonNode processedValue = null;
                boolean propertyAsJson = property.parseValue();
                if (!StringUtils.isNotBlank(propertyName) || !StringUtils.isNotBlank(propertyValue)) continue;
                if (key.isEmpty()) {
                    if (propertyAsJson) {
                        try {
                            processedValue = Json.mapper().readTree(propertyValue);
                            map.put(StringUtils.prependIfMissing(propertyName, (CharSequence)"x-", new CharSequence[0]), processedValue);
                        }
                        catch (Exception e) {
                            map.put(StringUtils.prependIfMissing(propertyName, (CharSequence)"x-", new CharSequence[0]), propertyValue);
                        }
                        continue;
                    }
                    map.put(StringUtils.prependIfMissing(propertyName, (CharSequence)"x-", new CharSequence[0]), propertyValue);
                    continue;
                }
                Object value = map.get(key);
                if (!(value instanceof Map)) {
                    value = new HashMap();
                    map.put(key, value);
                }
                Map mapValue = (Map)value;
                if (propertyAsJson) {
                    try {
                        processedValue = Json.mapper().readTree(propertyValue);
                        mapValue.put(propertyName, processedValue);
                    }
                    catch (Exception e) {
                        mapValue.put(propertyName, propertyValue);
                    }
                    continue;
                }
                mapValue.put(propertyName, propertyValue);
            }
        }
        return map;
    }

    public static znaishaded.io.swagger.v3.oas.annotations.media.Schema getSchemaAnnotation(Annotation ... annotations) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof znaishaded.io.swagger.v3.oas.annotations.media.Schema)) continue;
            return (znaishaded.io.swagger.v3.oas.annotations.media.Schema)annotation;
        }
        return null;
    }

    public static znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema getArraySchemaAnnotation(Annotation ... annotations) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema)) continue;
            return (znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema)annotation;
        }
        return null;
    }

    public static <T> T getAnnotation(Class<T> cls, Annotation ... annotations) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!cls.isAssignableFrom(annotation.getClass())) continue;
            return (T)annotation;
        }
        return null;
    }

    public static Annotation[] removeAnnotations(Annotation[] annotations, Class ... classes) {
        if (annotations == null) {
            return null;
        }
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            boolean found = false;
            for (Class cls : classes) {
                if (!cls.isAssignableFrom(annotation.getClass())) continue;
                found = true;
            }
            if (found) continue;
            result.add(annotation);
        }
        return result.toArray(new Annotation[result.size()]);
    }

    public static void updateAnnotation(Class<?> clazz, znaishaded.io.swagger.v3.oas.annotations.media.Schema newAnnotation) {
        try {
            Field field = Class.class.getDeclaredField("annotations");
            field.setAccessible(true);
            Map annotations = (Map)field.get(clazz);
            annotations.put(znaishaded.io.swagger.v3.oas.annotations.media.Schema.class, newAnnotation);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static Annotation mergeSchemaAnnotations(Annotation[] ctxAnnotations, JavaType type) {
        znaishaded.io.swagger.v3.oas.annotations.media.Schema cAs;
        znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema cA;
        znaishaded.io.swagger.v3.oas.annotations.media.Schema cS;
        znaishaded.io.swagger.v3.oas.annotations.media.Schema tAs;
        znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema tA;
        znaishaded.io.swagger.v3.oas.annotations.media.Schema tS = type.getRawClass().getDeclaredAnnotation(znaishaded.io.swagger.v3.oas.annotations.media.Schema.class);
        if (!AnnotationsUtils.hasSchemaAnnotation(tS)) {
            tS = null;
        }
        if (!AnnotationsUtils.hasArrayAnnotation(tA = type.getRawClass().getDeclaredAnnotation(znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema.class))) {
            tA = null;
        }
        znaishaded.io.swagger.v3.oas.annotations.media.Schema schema = tAs = tA == null ? null : tA.schema();
        if (!AnnotationsUtils.hasSchemaAnnotation(tAs)) {
            tAs = null;
        }
        if (!AnnotationsUtils.hasSchemaAnnotation(cS = AnnotationsUtils.getSchemaAnnotation(ctxAnnotations))) {
            cS = null;
        }
        if (!AnnotationsUtils.hasArrayAnnotation(cA = AnnotationsUtils.getArraySchemaAnnotation(ctxAnnotations))) {
            cA = null;
        }
        znaishaded.io.swagger.v3.oas.annotations.media.Schema schema2 = cAs = cA == null ? null : cA.schema();
        if (!AnnotationsUtils.hasSchemaAnnotation(cAs)) {
            cAs = null;
        }
        if (tS == null && tA == null && cS == null && cA == null) {
            return null;
        }
        if (tS == null && tA == null && cS != null) {
            return cS;
        }
        if (tS == null && tA == null && cS == null && cA != null) {
            return cA;
        }
        if (tS == null && tA != null && cS == null && cA == null) {
            return tA;
        }
        if (tS == null && tA != null && cS != null && cA == null) {
            if (tAs != null) {
                return tA;
            }
            return AnnotationsUtils.mergeArrayWithSchemaAnnotation(tA, cS);
        }
        if (tS != null && tA == null && cS == null && cA != null) {
            if (cAs != null) {
                return cA;
            }
            return AnnotationsUtils.mergeArrayWithSchemaAnnotation(cA, tS);
        }
        if (tA != null && cA != null) {
            return AnnotationsUtils.mergeArraySchemaAnnotations(cA, tA);
        }
        if (tS != null && cS == null && cA == null) {
            return tS;
        }
        if (tS != null && cS != null) {
            return AnnotationsUtils.mergeSchemaAnnotations(tS, cS);
        }
        return tS;
    }

    public static znaishaded.io.swagger.v3.oas.annotations.media.Schema mergeSchemaAnnotations(final znaishaded.io.swagger.v3.oas.annotations.media.Schema master, final znaishaded.io.swagger.v3.oas.annotations.media.Schema patch) {
        if (master == null) {
            return patch;
        }
        if (patch == null) {
            return master;
        }
        if (!AnnotationsUtils.hasSchemaAnnotation(patch)) {
            return master;
        }
        znaishaded.io.swagger.v3.oas.annotations.media.Schema schema = new znaishaded.io.swagger.v3.oas.annotations.media.Schema(){

            @Override
            public Class<?> implementation() {
                if (!master.implementation().equals(Void.class) || patch.implementation().equals(Void.class)) {
                    return master.implementation();
                }
                return patch.implementation();
            }

            @Override
            public Class<?> not() {
                if (!master.not().equals(Void.class) || patch.not().equals(Void.class)) {
                    return master.not();
                }
                return patch.not();
            }

            @Override
            public Class<?>[] oneOf() {
                if (master.oneOf().length > 0 || patch.oneOf().length == 0) {
                    return master.oneOf();
                }
                return patch.oneOf();
            }

            @Override
            public Class<?>[] anyOf() {
                if (master.anyOf().length > 0 || patch.anyOf().length == 0) {
                    return master.anyOf();
                }
                return patch.anyOf();
            }

            @Override
            public Class<?>[] allOf() {
                if (master.allOf().length > 0 || patch.allOf().length == 0) {
                    return master.allOf();
                }
                return patch.allOf();
            }

            @Override
            public String name() {
                if (StringUtils.isNotBlank(master.name()) || StringUtils.isBlank(patch.name())) {
                    return master.name();
                }
                return patch.name();
            }

            @Override
            public String title() {
                if (StringUtils.isNotBlank(master.title()) || StringUtils.isBlank(patch.title())) {
                    return master.title();
                }
                return patch.title();
            }

            @Override
            public double multipleOf() {
                if (master.multipleOf() != 0.0 || patch.multipleOf() == 0.0) {
                    return master.multipleOf();
                }
                return patch.multipleOf();
            }

            @Override
            public String maximum() {
                if (StringUtils.isNotBlank(master.maximum()) || StringUtils.isBlank(patch.maximum())) {
                    return master.maximum();
                }
                return patch.maximum();
            }

            @Override
            public boolean exclusiveMaximum() {
                if (master.exclusiveMaximum() || !patch.exclusiveMaximum()) {
                    return master.exclusiveMaximum();
                }
                return patch.exclusiveMaximum();
            }

            @Override
            public String minimum() {
                if (StringUtils.isNotBlank(master.minimum()) || StringUtils.isBlank(patch.minimum())) {
                    return master.minimum();
                }
                return patch.minimum();
            }

            @Override
            public boolean exclusiveMinimum() {
                if (master.exclusiveMinimum() || !patch.exclusiveMinimum()) {
                    return master.exclusiveMinimum();
                }
                return patch.exclusiveMinimum();
            }

            @Override
            public int maxLength() {
                if (master.maxLength() != Integer.MAX_VALUE && master.maxLength() > 0 || patch.maxLength() == Integer.MAX_VALUE || patch.maxLength() == 0) {
                    return master.maxLength();
                }
                return patch.maxLength();
            }

            @Override
            public int minLength() {
                if (master.minLength() != 0 || patch.minLength() == 0) {
                    return master.minLength();
                }
                return patch.minLength();
            }

            @Override
            public String pattern() {
                if (StringUtils.isNotBlank(master.pattern()) || StringUtils.isBlank(patch.pattern())) {
                    return master.pattern();
                }
                return patch.pattern();
            }

            @Override
            public int maxProperties() {
                if (master.maxProperties() != 0 || patch.maxProperties() == 0) {
                    return master.maxProperties();
                }
                return patch.maxProperties();
            }

            @Override
            public int minProperties() {
                if (master.minProperties() != 0 || patch.minProperties() == 0) {
                    return master.minProperties();
                }
                return patch.minProperties();
            }

            @Override
            public String[] requiredProperties() {
                if (master.requiredProperties().length > 0 || patch.requiredProperties().length == 0) {
                    return master.requiredProperties();
                }
                return patch.requiredProperties();
            }

            @Override
            public boolean required() {
                if (master.required() || !patch.required()) {
                    return master.required();
                }
                return patch.required();
            }

            @Override
            public String description() {
                if (StringUtils.isNotBlank(master.description()) || StringUtils.isBlank(patch.description())) {
                    return master.description();
                }
                return patch.description();
            }

            @Override
            public String format() {
                if (StringUtils.isNotBlank(master.format()) || StringUtils.isBlank(patch.format())) {
                    return master.format();
                }
                return patch.format();
            }

            @Override
            public String ref() {
                if (StringUtils.isNotBlank(master.ref()) || StringUtils.isBlank(patch.ref())) {
                    return master.ref();
                }
                return patch.ref();
            }

            @Override
            public boolean nullable() {
                if (master.nullable() || !patch.nullable()) {
                    return master.nullable();
                }
                return patch.nullable();
            }

            @Override
            public boolean readOnly() {
                if (master.readOnly() || !patch.readOnly()) {
                    return master.readOnly();
                }
                return patch.readOnly();
            }

            @Override
            public boolean writeOnly() {
                if (master.writeOnly() || !patch.writeOnly()) {
                    return master.writeOnly();
                }
                return patch.writeOnly();
            }

            @Override
            public Schema.AccessMode accessMode() {
                if (!master.accessMode().equals((Object)Schema.AccessMode.AUTO) || patch.accessMode().equals((Object)Schema.AccessMode.AUTO)) {
                    return master.accessMode();
                }
                return patch.accessMode();
            }

            @Override
            public String example() {
                if (StringUtils.isNotBlank(master.example()) || StringUtils.isBlank(patch.example())) {
                    return master.example();
                }
                return patch.example();
            }

            @Override
            public ExternalDocumentation externalDocs() {
                if (AnnotationsUtils.getExternalDocumentation(master.externalDocs()).isPresent() || !AnnotationsUtils.getExternalDocumentation(patch.externalDocs()).isPresent()) {
                    return master.externalDocs();
                }
                return patch.externalDocs();
            }

            @Override
            public boolean deprecated() {
                if (master.deprecated() || !patch.deprecated()) {
                    return master.deprecated();
                }
                return patch.deprecated();
            }

            @Override
            public String type() {
                if (StringUtils.isNotBlank(master.type()) || StringUtils.isBlank(patch.type())) {
                    return master.type();
                }
                return patch.type();
            }

            @Override
            public String[] allowableValues() {
                if (master.allowableValues().length > 0 || patch.allowableValues().length == 0) {
                    return master.allowableValues();
                }
                return patch.allowableValues();
            }

            @Override
            public String defaultValue() {
                if (StringUtils.isNotBlank(master.defaultValue()) || StringUtils.isBlank(patch.defaultValue())) {
                    return master.defaultValue();
                }
                return patch.defaultValue();
            }

            @Override
            public String discriminatorProperty() {
                if (StringUtils.isNotBlank(master.discriminatorProperty()) || StringUtils.isBlank(patch.discriminatorProperty())) {
                    return master.discriminatorProperty();
                }
                return patch.discriminatorProperty();
            }

            @Override
            public DiscriminatorMapping[] discriminatorMapping() {
                if (master.discriminatorMapping().length > 0 || patch.discriminatorMapping().length == 0) {
                    return master.discriminatorMapping();
                }
                return patch.discriminatorMapping();
            }

            @Override
            public boolean hidden() {
                if (master.hidden() || !patch.hidden()) {
                    return master.hidden();
                }
                return patch.hidden();
            }

            @Override
            public boolean enumAsRef() {
                if (master.enumAsRef() || !patch.enumAsRef()) {
                    return master.enumAsRef();
                }
                return patch.enumAsRef();
            }

            @Override
            public Class<?>[] subTypes() {
                if (master.subTypes().length > 0 || patch.subTypes().length == 0) {
                    return master.subTypes();
                }
                return patch.subTypes();
            }

            @Override
            public Extension[] extensions() {
                if (master.extensions().length > 0 || patch.extensions().length == 0) {
                    return master.extensions();
                }
                return patch.extensions();
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return znaishaded.io.swagger.v3.oas.annotations.media.Schema.class;
            }

            @Override
            public Schema.AdditionalPropertiesValue additionalProperties() {
                if (!master.additionalProperties().equals((Object)Schema.AdditionalPropertiesValue.USE_ADDITIONAL_PROPERTIES_ANNOTATION) || patch.additionalProperties().equals((Object)Schema.AdditionalPropertiesValue.USE_ADDITIONAL_PROPERTIES_ANNOTATION)) {
                    return master.additionalProperties();
                }
                return patch.additionalProperties();
            }
        };
        return schema;
    }

    public static znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema mergeArraySchemaAnnotations(final znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema master, final znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema patch) {
        if (master == null) {
            return patch;
        }
        if (patch == null) {
            return master;
        }
        if (!AnnotationsUtils.hasArrayAnnotation(patch)) {
            return master;
        }
        znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema newArraySchema = new znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema.class;
            }

            @Override
            public znaishaded.io.swagger.v3.oas.annotations.media.Schema schema() {
                znaishaded.io.swagger.v3.oas.annotations.media.Schema patchSchema = patch.schema();
                if (!AnnotationsUtils.hasSchemaAnnotation(patchSchema)) {
                    patchSchema = null;
                }
                if (patchSchema == null) {
                    return master.schema();
                }
                return AnnotationsUtils.mergeSchemaAnnotations(master.schema(), patch.schema());
            }

            @Override
            public znaishaded.io.swagger.v3.oas.annotations.media.Schema arraySchema() {
                znaishaded.io.swagger.v3.oas.annotations.media.Schema patchSchema = patch.arraySchema();
                if (!AnnotationsUtils.hasSchemaAnnotation(patchSchema)) {
                    patchSchema = null;
                }
                if (patchSchema == null) {
                    return master.arraySchema();
                }
                return AnnotationsUtils.mergeSchemaAnnotations(master.arraySchema(), patch.arraySchema());
            }

            @Override
            public int maxItems() {
                if (master.maxItems() != 0 || patch.maxItems() == 0) {
                    return master.maxItems();
                }
                return patch.maxItems();
            }

            @Override
            public int minItems() {
                if (master.minItems() != 0 || patch.minItems() == 0) {
                    return master.minItems();
                }
                return patch.minItems();
            }

            @Override
            public boolean uniqueItems() {
                if (master.uniqueItems() || !patch.uniqueItems()) {
                    return master.uniqueItems();
                }
                return patch.uniqueItems();
            }

            @Override
            public Extension[] extensions() {
                if (master.extensions().length > 0 || patch.extensions().length == 0) {
                    return master.extensions();
                }
                return patch.extensions();
            }
        };
        return newArraySchema;
    }

    public static znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema mergeArrayWithSchemaAnnotation(final znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema arraySchema, final znaishaded.io.swagger.v3.oas.annotations.media.Schema schema) {
        if (arraySchema == null || schema == null) {
            return arraySchema;
        }
        if (!AnnotationsUtils.hasSchemaAnnotation(schema)) {
            return arraySchema;
        }
        znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema newArraySchema = new znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return znaishaded.io.swagger.v3.oas.annotations.media.ArraySchema.class;
            }

            @Override
            public znaishaded.io.swagger.v3.oas.annotations.media.Schema schema() {
                return schema;
            }

            @Override
            public znaishaded.io.swagger.v3.oas.annotations.media.Schema arraySchema() {
                return arraySchema.arraySchema();
            }

            @Override
            public int maxItems() {
                return arraySchema.maxItems();
            }

            @Override
            public int minItems() {
                return arraySchema.minItems();
            }

            @Override
            public boolean uniqueItems() {
                return arraySchema.uniqueItems();
            }

            @Override
            public Extension[] extensions() {
                return arraySchema.extensions();
            }
        };
        return newArraySchema;
    }

    private static /* synthetic */ void lambda$getContent$3(Schema oSchema, SchemaProperty sp, Schema s2) {
        if ("array".equals(oSchema.getType())) {
            oSchema.getItems().addProperty(sp.name(), s2);
        } else {
            oSchema.addProperty(sp.name(), s2);
        }
    }
}

