/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.v3.parser.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import znaishaded.io.swagger.v3.parser.core.models.AuthorizationValue;
import znaishaded.io.swagger.v3.parser.models.RefFormat;
import znaishaded.io.swagger.v3.parser.processors.ExternalRefProcessor;
import znaishaded.io.swagger.v3.parser.util.ClasspathHelper;
import znaishaded.io.swagger.v3.parser.util.RemoteUrl;
import znaishaded.org.apache.commons.io.IOUtils;
import znaishaded.org.apache.commons.lang3.StringUtils;

public class RefUtils {
    private static final String REFERENCE_SEPARATOR = "#/";

    private RefUtils() {
    }

    public static String computeDefinitionName(String ref) {
        String plausibleName;
        String definitionPath;
        String[] refParts = ref.split(REFERENCE_SEPARATOR);
        if (refParts.length > 2) {
            throw new RuntimeException("Invalid ref format: " + ref);
        }
        String file = refParts[0];
        String string = definitionPath = refParts.length == 2 ? refParts[1] : null;
        if (definitionPath != null) {
            String[] jsonPathElements = definitionPath.split("/");
            plausibleName = jsonPathElements[jsonPathElements.length - 1];
        } else {
            String[] filePathElements = file.split("/");
            plausibleName = filePathElements[filePathElements.length - 1];
            String[] split = plausibleName.split("\\.");
            plausibleName = split[0];
            for (int i = 1; i < split.length - 1; ++i) {
                plausibleName = plausibleName + "." + split[i];
            }
        }
        return plausibleName;
    }

    public static Optional<String> getExternalPath(String ref) {
        if (ref == null) {
            return Optional.empty();
        }
        return Optional.of(ref.split(REFERENCE_SEPARATOR)).filter(it -> ((String[])it).length == 2).map(it -> it[0]).filter(it -> !it.isEmpty());
    }

    public static boolean isAnExternalRefFormat(RefFormat refFormat) {
        return refFormat == RefFormat.URL || refFormat == RefFormat.RELATIVE;
    }

    public static RefFormat computeRefFormat(String ref) {
        RefFormat result = RefFormat.INTERNAL;
        if ((ref = RefUtils.mungedRef(ref)).startsWith("http") || ref.startsWith("https")) {
            result = RefFormat.URL;
        } else if (ref.startsWith(REFERENCE_SEPARATOR)) {
            result = RefFormat.INTERNAL;
        } else if (ref.startsWith(".") || ref.startsWith("/") || ref.indexOf(REFERENCE_SEPARATOR) > 0) {
            result = RefFormat.RELATIVE;
        }
        return result;
    }

    public static String mungedRef(String refString) {
        if (!(refString.contains(":") || refString.startsWith("#") || refString.startsWith("/") || refString.contains("$") || refString.indexOf(".") <= 0)) {
            return "./" + refString;
        }
        return refString;
    }

    public static String readExternalUrlRef(String file, RefFormat refFormat, List<AuthorizationValue> auths, String rootPath) {
        String result;
        if (!RefUtils.isAnExternalRefFormat(refFormat)) {
            throw new RuntimeException("Ref is not external");
        }
        try {
            if (refFormat != RefFormat.URL) {
                String url = RefUtils.buildUrl(rootPath, file);
                return RefUtils.readExternalRef(url, RefFormat.URL, auths, null);
            }
            result = RemoteUrl.urlToString(file, auths);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load " + (Object)((Object)refFormat) + " ref: " + file, e);
        }
        return result;
    }

    public static String readExternalClasspathRef(String file, RefFormat refFormat, List<AuthorizationValue> auths, String rootPath) {
        String result;
        if (!RefUtils.isAnExternalRefFormat(refFormat)) {
            throw new RuntimeException("Ref is not external");
        }
        try {
            if (refFormat == RefFormat.URL) {
                result = RemoteUrl.urlToString(file, auths);
            } else {
                String pathRef = ExternalRefProcessor.join(rootPath, file);
                result = ClasspathHelper.loadFileFromClasspath(pathRef);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load " + (Object)((Object)refFormat) + " ref: " + file, e);
        }
        return result;
    }

    public static String buildUrl(String rootPath, String relativePath) {
        int i;
        String[] rootPathParts = rootPath.split("/");
        String[] relPathParts = relativePath.split("/");
        if (rootPath == null || relativePath == null) {
            return null;
        }
        int trimRoot = 0;
        int trimRel = 0;
        if (!"".equals(rootPathParts[rootPathParts.length - 1])) {
            trimRoot = 1;
        }
        if ("".equals(relPathParts[0])) {
            trimRel = 1;
            trimRoot = rootPathParts.length - 3;
        }
        for (i = 0; i < rootPathParts.length && "".equals(rootPathParts[i]); ++i) {
            ++trimRel;
        }
        for (i = 0; i < relPathParts.length; ++i) {
            if (".".equals(relPathParts[i])) {
                ++trimRel;
                continue;
            }
            if (!"..".equals(relPathParts[i])) continue;
            ++trimRel;
            ++trimRoot;
        }
        Object[] outputParts = new String[rootPathParts.length + relPathParts.length - trimRoot - trimRel];
        System.arraycopy(rootPathParts, 0, outputParts, 0, rootPathParts.length - trimRoot);
        System.arraycopy(relPathParts, trimRel, outputParts, rootPathParts.length - trimRoot, relPathParts.length - trimRel);
        return StringUtils.join(outputParts, "/");
    }

    public static String readExternalRef(String file, RefFormat refFormat, List<AuthorizationValue> auths, Path parentDirectory) {
        if (!RefUtils.isAnExternalRefFormat(refFormat)) {
            throw new RuntimeException("Ref is not external");
        }
        String result = null;
        try {
            if (refFormat == RefFormat.URL) {
                result = RemoteUrl.urlToString(file, auths);
            } else {
                Path pathToUse = parentDirectory.resolve(file).normalize();
                if (Files.exists(pathToUse, new LinkOption[0])) {
                    result = RefUtils.readAll(pathToUse);
                } else {
                    String url = file;
                    if (url.contains("..")) {
                        int parentCount = 0;
                        while (url.contains("..")) {
                            url = url.substring(url.indexOf(".") + 2);
                            ++parentCount;
                        }
                        for (int i = 0; i < parentCount - 1; ++i) {
                            parentDirectory = parentDirectory.getParent();
                        }
                        url = parentDirectory + url;
                    } else {
                        url = parentDirectory + url.substring(url.indexOf(".") + 1);
                    }
                    Path pathToUse2 = parentDirectory.resolve(url).normalize();
                    if (Files.exists(pathToUse2, new LinkOption[0])) {
                        result = RefUtils.readAll(pathToUse2);
                    }
                }
                if (result == null) {
                    result = ClasspathHelper.loadFileFromClasspath(file);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load " + (Object)((Object)refFormat) + " ref: " + file + " path: " + parentDirectory, e);
        }
        return result;
    }

    private static String readAll(Path path) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(path.toFile());){
            String string = IOUtils.toString((InputStream)inputStream, StandardCharsets.UTF_8);
            return string;
        }
    }
}

