/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class ProgressBar {
    private static final Logger logger = Logger.getLogger("znaishaded.com.plantuml.ProgressBar");
    private static boolean enable;
    private static String last;
    private static final AtomicInteger total;
    private static final AtomicInteger done;

    private static synchronized void print(String message) {
        logger.log(Level.INFO, ProgressBar.buildClearMessage() + message);
        last = message;
    }

    public static synchronized void clear() {
        logger.log(Level.INFO, ProgressBar.buildClearMessage());
        last = null;
    }

    private static String buildClearMessage() {
        if (last != null) {
            int i;
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < last.length(); ++i) {
                sb.append("\b");
            }
            for (i = 0; i < last.length(); ++i) {
                sb.append(" ");
            }
            for (i = 0; i < last.length(); ++i) {
                sb.append("\b");
            }
            return sb.toString();
        }
        return "";
    }

    public static void incTotal(int nb) {
        total.addAndGet(nb);
        ProgressBar.printBar(done.intValue(), total.intValue());
    }

    private static synchronized void printBar(int done, int total) {
        if (!enable) {
            return;
        }
        if (total == 0) {
            return;
        }
        ProgressBar.print("[" + ProgressBar.getBar(done, total) + "] " + done + "/" + total);
    }

    private static String getBar(int done, int total) {
        StringBuilder sb = new StringBuilder();
        int width = 30;
        int value = 30 * done / total;
        for (int i = 0; i < 30; ++i) {
            sb.append(i < value ? (char)'#' : ' ');
        }
        return sb.toString();
    }

    public static void incDone(boolean error) {
        done.incrementAndGet();
        ProgressBar.printBar(done.intValue(), total.intValue());
    }

    public static void setEnable(boolean value) {
        enable = value;
    }

    static {
        logger.setUseParentHandlers(false);
        logger.addHandler(new StdErrHandler());
        last = null;
        total = new AtomicInteger();
        done = new AtomicInteger();
    }

    private static class StdErrHandler
    extends Handler {
        @Override
        public void publish(LogRecord record) {
            String message = record.getMessage();
            System.err.print(message);
            this.flush();
        }

        @Override
        public void flush() {
            System.err.flush();
        }

        @Override
        public void close() {
            this.flush();
        }
    }
}

