/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3;

import java.util.Collection;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Instruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionList;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.decoration.Rainbow;
import znaishaded.net.sourceforge.plantuml.klimt.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.klimt.color.Colors;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteType;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;

public class Branch {
    private final InstructionList list;
    private final Display labelTest;
    private final LinkRendering labelPositive;
    private LinkRendering inlinkRendering = LinkRendering.none();
    private final LinkRendering inlabel;
    private LinkRendering special;
    private final HColor color;
    private Ftile ftile;
    private Gtile gtile;

    public StyleSignatureBasic getDefaultStyleDefinitionArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    public StyleSignatureBasic getDefaultStyleDefinitionDiamond() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
    }

    public boolean containsBreak() {
        return this.list.containsBreak();
    }

    public Branch(StyleBuilder styleBuilder, Swimlane swimlane, LinkRendering labelPositive, Display labelTest, HColor color, LinkRendering inlabel) {
        this.inlabel = Objects.requireNonNull(inlabel);
        this.labelTest = Objects.requireNonNull(labelTest);
        this.labelPositive = Objects.requireNonNull(labelPositive);
        Style style = this.getDefaultStyleDefinitionDiamond().getMergedStyle(styleBuilder);
        this.color = color == null ? style.value(PName.BackGroundColor).asColor(styleBuilder.getSkinParam().getIHtmlColorSet()) : color;
        this.list = new InstructionList(swimlane);
    }

    public Collection<WeldingPoint> getWeldingPoints() {
        return this.ftile.getWeldingPoints();
    }

    public CommandExecutionResult add(Instruction ins) {
        this.list.add(ins);
        return CommandExecutionResult.ok();
    }

    public boolean kill() {
        return this.list.kill();
    }

    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote) {
        return this.list.addNote(note, position, type, colors, swimlaneNote);
    }

    public final void setInlinkRendering(LinkRendering inlinkRendering) {
        this.inlinkRendering = Objects.requireNonNull(inlinkRendering);
    }

    public void updateFtile(FtileFactory factory) {
        this.ftile = factory.decorateOut(this.list.createFtile(factory), this.inlinkRendering);
    }

    public void updateGtile(ISkinParam skinParam, StringBounder stringBounder) {
        this.gtile = this.list.createGtile(skinParam, stringBounder);
    }

    public Collection<? extends Swimlane> getSwimlanes() {
        return this.list.getSwimlanes();
    }

    public final Display getLabelTest() {
        return this.labelTest;
    }

    public final Rainbow getOut() {
        if (this.special != null) {
            return this.special.getRainbow();
        }
        if (this.inlinkRendering == null) {
            return null;
        }
        return this.inlinkRendering.getRainbow();
    }

    public Rainbow getInColor(Rainbow arrowColor) {
        if (this.isEmpty()) {
            return this.getFtile().getOutLinkRendering().getRainbow(arrowColor);
        }
        if (this.labelPositive.getRainbow().size() > 0) {
            return this.labelPositive.getRainbow();
        }
        LinkRendering linkIn = this.getFtile().getInLinkRendering();
        Rainbow color = linkIn.getRainbow(arrowColor);
        if (color.size() == 0) {
            return arrowColor;
        }
        return color;
    }

    public Display getInlabel() {
        return this.inlabel.getDisplay();
    }

    public Rainbow getInRainbow(Rainbow defaultColor) {
        return this.inlabel.getRainbow(defaultColor);
    }

    public Rainbow getLabelPositiveRainbow(Rainbow defaultColor) {
        return this.labelPositive.getRainbow(defaultColor);
    }

    public final Ftile getFtile() {
        return this.ftile;
    }

    public Gtile getGtile() {
        return this.gtile;
    }

    public ISkinParam skinParam() {
        if (this.gtile != null) {
            return this.gtile.skinParam();
        }
        return this.ftile.skinParam();
    }

    public final HColor getColor() {
        return this.color;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Instruction getLast() {
        return this.list.getLast();
    }

    public boolean isOnlySingleStopOrSpot() {
        return this.list.isOnlySingleStopOrSpot();
    }

    public void setSpecial(LinkRendering link) {
        this.special = link;
    }

    public final LinkRendering getSpecial() {
        return this.special;
    }

    public final Display getDisplayPositive() {
        LinkRendering in;
        if (this.ftile != null && (in = this.ftile.getInLinkRendering()) != null && !Display.isNull(in.getDisplay())) {
            return in.getDisplay();
        }
        return this.labelPositive.getDisplay();
    }

    public Display getSpecialDisplay() {
        if (this.special != null && !Display.isNull(this.special.getDisplay())) {
            return this.special.getDisplay();
        }
        return null;
    }

    private TextBlock getTextBlock(Display display) {
        if (display == null) {
            return TextBlockUtils.EMPTY_TEXT_BLOCK;
        }
        Style style = this.getDefaultStyleDefinitionArrow().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
        LineBreakStrategy lineBreak = style.wrapWidth();
        FontConfiguration fcArrow = style.getFontConfiguration(this.skinParam().getIHtmlColorSet());
        return display.create0(fcArrow, HorizontalAlignment.LEFT, this.skinParam(), lineBreak, CreoleMode.SIMPLE_LINE, null, null);
    }

    public final TextBlock getTextBlockPositive() {
        return this.getTextBlock(this.getDisplayPositive());
    }

    public final TextBlock getTextBlockSpecial() {
        return this.getTextBlock(this.getSpecialDisplay());
    }
}

