/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.Collection;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.klimt.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Sheet;
import znaishaded.net.sourceforge.plantuml.klimt.creole.SheetBlock1;
import znaishaded.net.sourceforge.plantuml.klimt.creole.SheetBlock2;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.svek.image.Opale;
import znaishaded.net.sourceforge.plantuml.utils.MathUtils;

public class FtileWithNotes
extends AbstractFtile {
    private final Ftile tile;
    private TextBlock left;
    private TextBlock right;
    private final VerticalAlignment verticalAlignment;
    private final double suppSpace = 20.0;

    public StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.note);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    public FtileWithNotes(Ftile tile, Collection<PositionedNote> notes, VerticalAlignment verticalAlignment) {
        super(tile.skinParam());
        this.verticalAlignment = verticalAlignment;
        this.tile = tile;
        for (PositionedNote note : notes) {
            ISkinParam skinParam2 = this.skinParam();
            if (note.getColors() != null) {
                skinParam2 = note.getColors().mute(skinParam2);
            }
            Style style = this.getStyleSignature().getMergedStyle(this.skinParam().getCurrentStyleBuilder()).eventuallyOverride(note.getColors());
            HColor noteBackgroundColor = style.value(PName.BackGroundColor).asColor(this.getIHtmlColorSet());
            HColor borderColor = style.value(PName.LineColor).asColor(this.getIHtmlColorSet());
            FontConfiguration fc = style.getFontConfiguration(this.getIHtmlColorSet());
            double shadowing = style.value(PName.Shadowing).asDouble();
            LineBreakStrategy wrapWidth = style.wrapWidth();
            UStroke stroke = style.getStroke();
            Sheet sheet = this.skinParam().sheet(fc, this.skinParam().getDefaultTextAlignment(HorizontalAlignment.LEFT), CreoleMode.FULL).createSheet(note.getDisplay());
            final SheetBlock1 sheet1 = new SheetBlock1(sheet, wrapWidth, this.skinParam().getPadding());
            SheetBlock2 sheet2 = new SheetBlock2(sheet1, new Stencil(){

                @Override
                public double getStartingX(StringBounder stringBounder, double y) {
                    return -6.0;
                }

                @Override
                public double getEndingX(StringBounder stringBounder, double y) {
                    return sheet1.getEndingX(stringBounder, y) + 15.0;
                }
            }, UStroke.simple());
            Opale opale = new Opale(shadowing, borderColor, noteBackgroundColor, sheet2, false, stroke);
            TextBlock opaleMarged = TextBlockUtils.withMargin(opale, 10.0, 10.0);
            if (note.getNotePosition() == NotePosition.LEFT) {
                if (this.left == null) {
                    this.left = opaleMarged;
                    continue;
                }
                this.left = TextBlockUtils.mergeTB(this.left, opaleMarged, HorizontalAlignment.CENTER);
                continue;
            }
            if (this.right == null) {
                this.right = opaleMarged;
                continue;
            }
            this.right = TextBlockUtils.mergeTB(this.right, opaleMarged, HorizontalAlignment.CENTER);
        }
        if (this.left == null) {
            this.left = TextBlockUtils.empty(0.0, 0.0);
        }
        if (this.right == null) {
            this.right = TextBlockUtils.empty(0.0, 0.0);
        }
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        XDimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimTile = this.tile.calculateDimension(stringBounder);
        double xDelta = this.left.calculateDimension(stringBounder).getWidth();
        double yDelta = this.verticalAlignment == VerticalAlignment.TOP ? 0.0 : (dimTotal.getHeight() - ((XDimension2D)dimTile).getHeight()) / 2.0;
        return new UTranslate(xDelta, yDelta);
    }

    private UTranslate getTranslateForLeft(StringBounder stringBounder) {
        XDimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        XDimension2D dimLeft = this.left.calculateDimension(stringBounder);
        double xDelta = 0.0;
        double yDelta = this.verticalAlignment == VerticalAlignment.TOP ? 0.0 : (dimTotal.getHeight() - dimLeft.getHeight()) / 2.0;
        return new UTranslate(0.0, yDelta);
    }

    private UTranslate getTranslateForRight(StringBounder stringBounder) {
        XDimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        XDimension2D dimRight = this.right.calculateDimension(stringBounder);
        double xDelta = dimTotal.getWidth() - dimRight.getWidth();
        double yDelta = this.verticalAlignment == VerticalAlignment.TOP ? 0.0 : (dimTotal.getHeight() - dimRight.getHeight()) / 2.0;
        return new UTranslate(xDelta, yDelta);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        this.left.drawU(ug.apply(this.getTranslateForLeft(stringBounder)));
        this.right.drawU(ug.apply(this.getTranslateForRight(stringBounder)));
        ug.apply(this.getTranslate(stringBounder)).draw(this.tile);
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        XDimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry orig = this.tile.calculateDimension(stringBounder);
        UTranslate translate = this.getTranslate(stringBounder);
        if (orig.hasPointOut()) {
            return new FtileGeometry(dimTotal, orig.getLeft() + translate.getDx(), orig.getInY() + translate.getDy(), orig.getOutY() + translate.getDy());
        }
        return new FtileGeometry(dimTotal, orig.getLeft() + translate.getDx(), orig.getInY() + translate.getDy());
    }

    private XDimension2D calculateDimensionInternal(StringBounder stringBounder) {
        FtileGeometry dimTile = this.tile.calculateDimension(stringBounder);
        XDimension2D dimLeft = this.left.calculateDimension(stringBounder);
        XDimension2D dimRight = this.right.calculateDimension(stringBounder);
        double height = MathUtils.max(dimLeft.getHeight(), dimRight.getHeight(), ((XDimension2D)dimTile).getHeight());
        return new XDimension2D(((XDimension2D)dimTile).getWidth() + dimLeft.getWidth() + dimRight.getWidth(), height);
    }

    @Override
    public final LinkRendering getInLinkRendering() {
        return this.tile.getInLinkRendering();
    }
}

