/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.asciiart;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.asciiart.AbstractComponentText;
import znaishaded.net.sourceforge.plantuml.asciiart.AsciiShape;
import znaishaded.net.sourceforge.plantuml.asciiart.UmlCharArea;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.txt.UGraphicTxt;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;

public class ComponentTextShape
extends AbstractComponentText {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final AsciiShape shape;

    public ComponentTextShape(ComponentType type, Display stringsToDisplay, AsciiShape shape) {
        this.type = type;
        this.stringsToDisplay = stringsToDisplay;
        this.shape = shape;
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        XDimension2D dimensionToUse = area.getDimensionToUse();
        UmlCharArea charArea = ((UGraphicTxt)ug).getCharArea();
        int width = (int)dimensionToUse.getWidth();
        int height = (int)dimensionToUse.getHeight();
        charArea.fillRect(' ', 0, 0, width, height);
        int xman = width / 2 - this.shape.getWidth() / 2 + 1;
        if (this.type.name().endsWith("_HEAD")) {
            charArea.drawStringsLRSimple(this.stringsToDisplay.asList(), 1, this.getHeight());
            charArea.drawShape(this.shape, xman, 0);
        } else {
            charArea.drawStringsLRSimple(this.stringsToDisplay.asList(), 1, 0);
            charArea.drawShape(this.shape, xman, 1);
        }
    }

    private int getHeight() {
        return this.shape.getHeight();
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + this.getHeight();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWcWidth(this.stringsToDisplay) + 2;
    }
}

