/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.TitledDiagram;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontParam;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.utils.BlocLines;

public class CommandMultilinesFooter
extends CommandMultilines<TitledDiagram> {
    public static final CommandMultilinesFooter ME = new CommandMultilinesFooter();

    private CommandMultilinesFooter() {
        super("^(?:(left|right|center)?[%s]*)footer$");
    }

    @Override
    public String getPatternEnd() {
        return "^end[%s]?footer$";
    }

    @Override
    public CommandExecutionResult execute(TitledDiagram diagram, BlocLines lines) throws NoSuchColorException {
        lines = lines.trim();
        Matcher2 m3 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        if (!m3.find()) {
            throw new IllegalStateException();
        }
        String align = m3.group(1);
        Display strings = (lines = lines.subExtract(1, 1)).toDisplay();
        if (strings.size() > 0) {
            HorizontalAlignment ha = HorizontalAlignment.fromString(align, HorizontalAlignment.CENTER);
            if (align == null) {
                ha = FontParam.FOOTER.getStyleDefinition(null).getMergedStyle(((UmlDiagram)diagram).getSkinParam().getCurrentStyleBuilder()).getHorizontalAlignment();
            }
            diagram.getFooter().putDisplay(strings, ha);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Empty footer");
    }
}

