/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.drawing.eps;

import java.io.UnsupportedEncodingException;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.eps.EpsGraphicsMacro;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFont;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFontContext;

public class EpsGraphicsMacroAndText
extends EpsGraphicsMacro {
    public void drawText(String text, FontConfiguration fontConfiguration, double x, double y) {
        this.append(EpsGraphicsMacroAndText.format(x) + " " + EpsGraphicsMacroAndText.format(y) + " moveto", true);
        this.appendColor(this.getColor());
        UFont font = fontConfiguration.getFont();
        int size = font.getSize();
        this.append("/" + this.getPSName(fontConfiguration) + " findfont " + size + " scalefont setfont", true);
        this.append("100 -100 scale", true);
        this.append("(" + this.getTextAsEps(text) + ") show", false);
        this.append(".01 -.01 scale", true);
    }

    private String getPSName(FontConfiguration fontConfiguration) {
        UFont font = fontConfiguration.getFont();
        StringBuilder sb = new StringBuilder(font.getFamily(UFontContext.EPS));
        return sb.toString();
    }

    private String getTextAsEps(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '(') {
                sb.append("\\(");
                continue;
            }
            if (c == ')') {
                sb.append("\\)");
                continue;
            }
            if (c < ' ') {
                sb.append("?");
                continue;
            }
            if (c >= ' ' && c <= '\u007f') {
                sb.append(c);
                continue;
            }
            String s2 = "" + c;
            try {
                byte[] b = s2.getBytes("ISO-8859-1");
                if (b.length == 1) {
                    int code = b[0] & 0xFF;
                    sb.append("\\" + Integer.toOctalString(code));
                    continue;
                }
                sb.append('?');
                continue;
            }
            catch (UnsupportedEncodingException e) {
                sb.append('?');
            }
        }
        return sb.toString();
    }
}

