/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.drawing.tikz;

import znaishaded.net.sourceforge.plantuml.klimt.UParam;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColorGradient;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UDriver;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.tikz.TikzGraphics;
import znaishaded.net.sourceforge.plantuml.utils.MathUtils;

public class DriverRectangleTikz
implements UDriver<URectangle, TikzGraphics> {
    @Override
    public void draw(URectangle rect, double x, double y, ColorMapper mapper, UParam param, TikzGraphics tikz) {
        double width = rect.getWidth();
        double height = rect.getHeight();
        double r = MathUtils.min(rect.getRx(), rect.getRy(), width / 2.0, height / 2.0);
        HColor back = param.getBackcolor();
        if (back instanceof HColorGradient) {
            HColorGradient gr = (HColorGradient)back;
            tikz.setGradientColor(gr.getColor1(), gr.getColor2(), gr.getPolicy());
        } else {
            tikz.setFillColor(back);
        }
        tikz.setStrokeColor(param.getColor());
        tikz.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDashTikz());
        if (r == 0.0) {
            tikz.rectangle(x, y, width, height);
        } else {
            tikz.rectangleRound(x, y, width, height, r);
        }
    }
}

