/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.sprite;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import znaishaded.net.atmp.PixelImage;
import znaishaded.net.sourceforge.plantuml.klimt.AffineTransformType;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UImage;
import znaishaded.net.sourceforge.plantuml.klimt.sprite.Sprite;
import znaishaded.net.sourceforge.plantuml.log.Logme;
import znaishaded.net.sourceforge.plantuml.security.SImageIO;
import znaishaded.net.sourceforge.plantuml.utils.Log;

public class SpriteImage
implements Sprite {
    private final UImage img;

    public SpriteImage(BufferedImage img) {
        this.img = new UImage(new PixelImage(Objects.requireNonNull(img), AffineTransformType.TYPE_BILINEAR));
    }

    @Override
    public TextBlock asTextBlock(final HColor color, final double scale) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                ColorMapper colorMapper = ug.getColorMapper();
                if (colorMapper == ColorMapper.MONOCHROME) {
                    ug.draw(SpriteImage.this.img.monochrome().scale(scale));
                } else if (color == null) {
                    ug.draw(SpriteImage.this.img.scale(scale));
                } else {
                    ug.draw(SpriteImage.this.img.muteColor(color.toColor(colorMapper)).scale(scale));
                }
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D((double)SpriteImage.this.img.getWidth() * scale, (double)SpriteImage.this.img.getHeight() * scale);
            }
        };
    }

    public static Sprite fromInternal(String name) {
        if (name.endsWith(".png")) {
            throw new IllegalArgumentException();
        }
        InputStream is = SpriteImage.getInternalSprite(name + ".png");
        if (is == null) {
            return null;
        }
        try {
            return new SpriteImage(SImageIO.read(is));
        }
        catch (IOException e) {
            Logme.error(e);
            return null;
        }
    }

    public static InputStream getInternalSprite(String inner) {
        String path = "/sprites/" + inner;
        Log.info("Triying " + path);
        InputStream is = SpriteImage.class.getResourceAsStream(path);
        return is;
    }
}

